/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef GETTEXTEXPORTPLUGIN_H
#define GETTEXTEXPORTPLUGIN_H

#include <catalogfileplugin.h>

#include <qstringlist.h>

namespace KBabel {
class Catalog;
}
class KURL;
class QFile;
class QTextCodec;

/* ****************************************************************************
  The class for exporting GNU gettext PO files. As an extra information,
  it stores the list of all obsolete entries.
**************************************************************************** */

class GettextExportPlugin: public KBabel::CatalogExportPlugin
{
public:
    GettextExportPlugin(QObject* parent, const char* name, const QStringList &);
    virtual KBabel::ConversionStatus save(const QString& file, const QString& mimetype, const KBabel::Catalog* catalog);
    
private:
    QStringList msgidAsList( const KBabel::Catalog* catalog, uint item, bool plural=false ) const;
    QStringList msgstrAsList( const KBabel::Catalog* catalog, uint item, uint pluralNr=0 ) const;
};

#endif
