/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002-2003 	by Stanislav Visnovsky
                        	    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */

#include "catalogfileplugin.h"

#include <qstringlist.h>

#include <kdebug.h>
#include <ktrader.h>

using namespace KBabel;

struct KBabel::CatalogExportPluginPrivate
{
    bool _stop;
};

CatalogExportPlugin::CatalogExportPlugin(QObject* parent, const char* name) : QObject(parent,name)
{
    d = new CatalogExportPluginPrivate;
    d->_stop=false;
}

CatalogExportPlugin::~CatalogExportPlugin()
{
    delete d;
}

QStringList CatalogExportPlugin::availableExportMimeTypes()
{
    QStringList result;
    
    KTrader::OfferList offers = KTrader::self()->query("KBabelFilter", "exist [X-KDE-Export]");
    
    for( KTrader::OfferListIterator ptr = offers.begin(); ptr!=offers.end() ; ptr++ )
    {
	result += (*ptr)->property("X-KDE-Export").toStringList();
    }
    
    return result;
}

void CatalogExportPlugin::stop()
{
    d->_stop = true;
}

bool CatalogExportPlugin::isStopped() const
{
    return d->_stop;
}
