//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "namecache.h"
#include "deviceaddress.h"
#include <dcopclient.h>
#include <kapplication.h>

namespace KBluetooth {
namespace NameCache {

bool getCachedName(const KBluetooth::DeviceAddress& addr, QString& name, DCOPClient* dc)
{
    if (dc == NULL) {
         dc = KApplication::dcopClient();
    }
    QByteArray param;
    QDataStream paramStream(param, IO_WriteOnly);
    paramStream << QString(addr);
    QByteArray retData;

    QCString retType;
    if (dc->call( "kbluetoothd", "DeviceNameCache", "getCachedDeviceName(QString)",
        param, retType, retData, false))
    {
        QDataStream retStream(retData,IO_ReadOnly);
        QString retStr;
        retStream >> retStr;
        if (retStr.length() == 0) {
            name = QString(addr);
            return false;
        }
        else {
            name = retStr;
            return true;
        }
    }
    else {
        name = QString(addr);
        return false;
    }

}

bool getCachedClass(const KBluetooth::DeviceAddress& addr, int& devClass, DCOPClient* dc )
{
    if (dc == NULL) {
         dc = KApplication::dcopClient();
    }
    QByteArray param;
    QDataStream paramStream(param, IO_WriteOnly);
    paramStream << QString(addr);
    QByteArray retData;

    QCString retType;
    if (dc->call( "kbluetoothd", "DeviceNameCache", "getCachedDeviceClass(QString)",
        param, retType, retData, false))
    {
        QDataStream retStream(retData,IO_ReadOnly);
        retStream >> devClass;
        return true;
    }
    else {
        devClass = 0;
        return false;
    }

}

bool resolveCachedName(const QString& name, KBluetooth::DeviceAddress& addr, DCOPClient* dc)
{
    if (dc == NULL) {
         dc = KApplication::dcopClient();
    }
    QByteArray param;
    QDataStream paramStream(param, IO_WriteOnly);
    paramStream << name;
    QByteArray retData;

    QCString retType;
    if (dc->call( "kbluetoothd", "DeviceNameCache", "resolveCachedDeviceName(QString)",
        param, retType, retData, false))
    {
        QDataStream retStream(retData,IO_ReadOnly);
        QString retStr;
        retStream >> retStr;
        addr = KBluetooth::DeviceAddress(retStr);
        if (addr == KBluetooth::DeviceAddress::invalid) return false;
        return true;
    }
    else {
        addr = KBluetooth::DeviceAddress::invalid;
        return false;
    }
}

}
}
