/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klocale.h>

#include <qstring.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <kmessagebox.h>

#include <qvalidator.h>
#include <qregexp.h>

#ifdef HAVE_QOBEX_BLUETOOTH
#include <qobex/qobexbttransport.h>
#endif

#include "discoverabledevicewidget.h"
#include "bluetoothdevicewidget.h"

BluetoothDeviceWidget::BluetoothDeviceWidget( QWidget* parent, const char* name, WFlags fl )
  : DiscoverableDeviceWidget( parent, name, fl )
{
  QRegExp rx( "([0-9A-Fa-f]{2}:){5}[0-9A-Fa-f]{2}" );
  QValidator* validator = new QRegExpValidator( rx, mHandInputInput, "addressvalidator" );

  mHandInputInput->setValidator( validator );
  mHandInputInput->setInputMask( ">NN:NN:NN:NN:NN:NN" );
  mHandInputInput->setText( "00:00:00:00:00:00" );
}

BluetoothDeviceWidget::~BluetoothDeviceWidget()
{
}

QString BluetoothDeviceWidget::anyDevice() const
{
  return "00:00:00:00:00:00";
}

void BluetoothDeviceWidget::slotDiscoveryButtonPressed()
{
  clearDiscoveredDevices();

#ifdef HAVE_QOBEX_BLUETOOTH
  // Fixme make this a thread 
  // Get all avlaiable bluetooth devices. May take long time ...
  QValueList<bdaddr_t> devs = QObexBtTransport::inquireDevices();

  QValueList<bdaddr_t>::Iterator it;
  for ( it = devs.begin(); it != devs.end(); ++it ) {
    // Read the remote device name.
    QString devName = QObexBtTransport::getRemoteName( *it );
    QString addr = QObexBtTransport::address2String( *it );
    int channel = QObexBtTransport::getRfCommChannel( *it, QObexBtTransport::ObexFileServ );
    
    // Report this device
    discoveredDevice( devName, addr, 0 < channel );
  }
#endif
}

#include "bluetoothdevicewidget.moc"
