/*****************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen <kdebluetooth@schaettgen.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *****************************************************************************/

#ifndef NOATUNCONTROLLER_H
#define NOATUNCONTROLLER_H

#include "controller.h"
#include <qstringlist.h>
#include <qxml.h>
#include <vector>
#include "dcopcall.h"

class DCOPClient;

/**
@author Fred Schaettgen
*/
class NoatunController : public Controller, public QXmlDefaultHandler
{
Q_OBJECT
public:
    NoatunController(QObject* parent);
    ~NoatunController();
    void commandDINF(unsigned int &bitrate,
        unsigned int &sampleRate, unsigned int &channels);
    void commandFADE();
    void commandFFWD();
    SongInfo commandINFO();
    SongInfo commandINF2();
    void commandLADD(QString filename);
    void commandNEXT();
    void commandPAUS();
    void commandPLAY(QString filename, bool clear = false);
    QStringList commandPLST(int &curPos, bool useFilenames = false);
    void commandPREV();
    void commandREPT(bool repeat);
    void commandRMAL();
    void commandRWND();
    void commandSHFL(bool shuffle);
    void commandSLCT(Q_UINT16 index);
    void commandSTEN();
    void commandSTOP();
    void commandSTRT();
    void commandVOLM(Q_UINT8 volume);
    bool commandFULL();
    void commandSEEK(Q_UINT32 seconds);
    Q_UINT32 commandPLEN();
    bool commandGVOL(Q_UINT8 &volume);
    int currentIndex();

    struct PlaylistEntry {
        int track;
        QString title;
        QString local;
        QString url;
        int samplerate;
        int bitrate;
        int channels;
    };

    bool startElement(const QString &namespaceURI, const QString &localName,
        const QString &qName, const QXmlAttributes &atts );

private:
    std::vector<PlaylistEntry> playlistEntries;
    DCOPClient* dcopClient;
    QString noatunPlaylist;
    QString noatunDCOPApp;
    QString localPlaylist;
    DCOPCall createDCOPCaller();
    int getPosition();
    void setPosition(int secPos);
    unsigned int numTracks;
    QString setupXMLPlaylist(bool copyOrig = false);
    void readXMLPlaylist(QString srcfile = "");
    bool saveXMLPlaylist(QString destfile = "");

    void loadPlaylist();
    void savePlaylist();

};

#endif
