/***************************************************************************
                          mimesources.h  -  description
                             -------------------
    begin                : Son Sep 14 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIMESOURCES_H
#define MIMESOURCES_H

#include <qdragobject.h>

/**
 * Drag object for a text selection
 * Contains the text as plain/text (without formatting) and as kbarcode/Qt XML (with formatting)
 * Copied from the KPresenter source and modified by Dominik Seichter. See kprdrag.cc .
 */
class DSTextDrag : public QTextDrag
{
    Q_OBJECT
    public:
        DSTextDrag( QWidget *dragSource = 0L, const char *name = 0L );

        void setPlain( const QString &_plain ) { setText( _plain ); }
        void setKBarcode( const QCString &_kbarcode ) { kbarcode = _kbarcode; }

        virtual QByteArray encodedData( const char *mime ) const;
        virtual const char* format( int i ) const;

        static bool canDecode( QMimeSource* e );
        static const char * selectionMimeType();
        void setTextObjectNumber( int number );
        static int decodeTextObjectNumber( QMimeSource *e );

    protected:
        QCString kbarcode;
        int m_textObjectNumber;
};


/** Copy and paste of DrawingRect's
  *@author Dominik Seichter
  */
class DrawingRect;
class RectDrag : public QStoredDrag {
    public:
        RectDrag();

        void setRect( const DrawingRect* rect );

        static bool canDecode( QMimeSource * );
        static bool decode( QMimeSource *, DrawingRect* rect );        
};

/** Copy and paste of MyCanvasLine's
  *@author Dominik Seichter
  */
class MyCanvasLine;
class LineDrag : public QStoredDrag {
    public:
        LineDrag();

        void setLine( const MyCanvasLine* line );

        static bool canDecode( QMimeSource * );
        static bool decode( QMimeSource *, MyCanvasLine* line );
};

class CanvasBarcode;
struct barcodeData;

/** Copy and paste of Barcodes's. Barcodes are copied as QPixmap
  * so that they can be used in e.g. KWord, but also in KBarcodes
  * internal XML format so that the barcode settings can be changed
  * again.
  
  *@author Dominik Seichter
  */
class BarcodeDrag : public QDragObject {
    public:
        BarcodeDrag();

        virtual const char* format( int i ) const;
        virtual bool provides( const char* format ) const;

        void setBarcode( const barcodeData* barcode );
        QByteArray encodedData ( const char* format ) const;
        
        static bool canDecode( QMimeSource* e, const char* format );
        static bool decode( QMimeSource *, CanvasBarcode* barcode );
        static bool decode( QMimeSource* e, QPixmap* barcode );

    private:
        void setPixmap( const QPixmap & pix );

        QByteArray data;
        QByteArray pixdata;
};

#endif
