#include "barcodedialog.h"
#include "mybarcode.h"
#include "printersettings.h"
#include "barcodecombo.h"
#include "mimesources.h"

// KDE includes
#include <kapplication.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kimageio.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprinter.h>
#include <kpushbutton.h>

// Qt includes
#include <qclipboard.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qlayout.h>

BarCodeDialog::BarCodeDialog( QWidget* parent,  const char* name )
    : QDialog( parent, name, false)
{
    setCaption( i18n( "Barcode Generator" ) );

    BarCodeDialogLayout = new QHBoxLayout( this, 11, 6, "BarCodeDialogLayout");
    Layout5 = new QVBoxLayout( 0, 0, 6, "Layout5");
    Layout6 = new QVBoxLayout( 0, 0, 6, "Layout2");
    QHBoxLayout* Layout7 = new QHBoxLayout( 0, 6, 6 );
    
    widget = new BarcodeWidget( this, "widget" );
    
    buttonGenerate = new KPushButton( this, "buttonGenerate" );
    buttonGenerate->setText( i18n( "&Generate" ) );
    buttonGenerate->setEnabled( BarCode::haveBarcode() );
    buttonGenerate->setIconSet( SmallIconSet("barcode") );
    
    buttonSave = new KPushButton( this, "buttonSave" );
    buttonSave->setText( i18n( "&Save" ) );
    buttonSave->setEnabled( false );
    buttonSave->setIconSet( SmallIconSet("filesave") );
        
    buttonCopy = new KPushButton( this, "buttonCopy" );
    buttonCopy->setText( i18n("&Copy") );
    buttonCopy->setEnabled( false );
    buttonCopy->setIconSet( SmallIconSet("editcopy") );
    
    buttonPrint = new KPushButton( this );
    buttonPrint->setText( i18n("&Print") );
    buttonPrint->setEnabled( false );
    buttonPrint->setIconSet( SmallIconSet("fileprint") );
    
    buttonClose = new KPushButton( this );
    buttonClose->setText( i18n("&Close" ) );
    buttonClose->setIconSet( SmallIconSet("fileclose") );
    

    barcode = new QLabel( this, "barcode" );
#if QT_VERSION >= 0x030100
    barcode->setFrameStyle( QFrame::GroupBoxPanel | QFrame::Sunken );
#endif
    barcode->setMargin( 5 );

    connect( buttonGenerate, SIGNAL( clicked() ), this, SLOT( generate() ) );
    connect( buttonSave, SIGNAL( clicked() ), this, SLOT( save() ) );
    connect( buttonPrint, SIGNAL( clicked() ), this, SLOT( print() ) );
    connect( buttonCopy, SIGNAL( clicked() ), this, SLOT( copy() ) );

    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Expanding );

    Layout5->addWidget( buttonGenerate );
    Layout5->addWidget( buttonSave );
    Layout5->addWidget( buttonPrint );
    Layout5->addWidget( buttonCopy );
    Layout5->addItem( spacer );
    Layout5->addWidget( buttonClose );

    Layout7->addWidget( barcode );
    Layout7->addItem( spacer );
    
    Layout6->addWidget( widget );
    Layout6->addLayout( Layout7 );
    Layout6->addItem( spacer );

    BarCodeDialogLayout->addLayout( Layout6 );
    BarCodeDialogLayout->addLayout( Layout5 );

    connect( buttonClose, SIGNAL( clicked() ), this, SLOT( close() ) );

    b = 0;
    show();
}

BarCodeDialog::~BarCodeDialog()
{
    if( b )
        delete b;
}

void BarCodeDialog::generate()
{
    if( b )
        delete b;

    barcodeData d = widget->getData();
    b = new BarCode( &d );
        
    barcode->setPixmap( b->pixmap() );
    buttonSave->setEnabled( !barcode->pixmap()->isNull() );
    buttonPrint->setEnabled( !barcode->pixmap()->isNull() );
    buttonCopy->setEnabled( !barcode->pixmap()->isNull() );
}

void BarCodeDialog::save()
{
    if(!barcode->pixmap()->isNull()) {
        KFileDialog fd( ":save_image", KImageIO::pattern( KImageIO::Writing ), this, "fd", true );
        fd.setMode( KFile::File );
        fd.setOperationMode( KFileDialog::Saving );       
        if( fd.exec() == QDialog::Accepted ) {
            QString path = fd.selectedURL().path();
            QString filter = fd.currentFilter();
            QString extension = filter.right( filter.length() - filter.findRev(".") -1 ).upper();
            path = path + "." + extension.lower();
            if(!b->pixmap().save( path, extension, 0 ))
                KMessageBox::error( this, i18n("An error occurred during saving the image") );
        }
    }        
}

void BarCodeDialog::print()
{
    if( barcode->pixmap()->isNull() )
        return;

    KPrinter* printer = PrinterSettings::getInstance()->setupPrinter( this );
    if( !printer )
        return;

    // unless we can center the barcode
    printer->setFullPage( false );
    
    QPainter p( printer );
    // TODO: center barcode
    p.drawPixmap( QPoint( 0, 0 ), b->printerPixmap( printer ));
    p.end();
    delete printer;
}

void BarCodeDialog::copy()
{
    if( barcode->pixmap()->isNull() )
        return;

    BarcodeDrag* drag = new BarcodeDrag();
    barcodeData data = b->data();
    drag->setBarcode( &data );
#if QT_VERSION >= 0x030100
    kapp->clipboard()->setData( drag, QClipboard::Clipboard );
#else
    kapp->clipboard()->setData( drag );
#endif

}
