
/*
 * typedefs.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TYPEDEFS_H
#define TYPEDEFS_H

#include "config.h"
#include "dialogs/typedefs.h"

/*
 * Location for configuration file
 */

extern const char configfile[];

/*
 * Maximum path length
 */

#define PATHLENGTH	255

/*
 * Program definitions
 */

#define PROGRAM_VERSION	"0.03p"

/*
 * Playlist header
 */

#define PLAYLISTHEADER "Juice " PROGRAM_VERSION " playlist file - Please do not edit manually!"

/*
 * Help menu filenames
 */

extern const char helphelp[];
extern const char mainhelp[];
extern const char setuphelp[];
extern const char mixerhelp[];
extern const char browsehelp[];
extern const char rearrangehelp[];
extern const char playlistshelp[];
extern const char savehelp[];
extern const char loadhelp[];
extern const char newtrackhelp[];
extern const char curtrackhelp[];
extern const char stopresumehelp[];
extern const char pathhelp[];
extern const char inputhelp[];
extern const char mpg123help[];

/*
 * Setup definitions
 */

extern char *audiopath;					/* Default audio search path */
extern char *playlistpath;				/* Default playlist search path */
extern bool confirmdialogs;				/* Enable/Disable confirmation dialogs */
extern char *playername;				/* Command to execute player */
extern char *audiotype;					/* Audio type */
extern char *playlisttype;				/* Playlist type */
extern int fadingtime;					/* Fading time in milliseconds */
extern volatile bool mpg123frontend;	/* Generic player / MPG123 flag */
extern char *mpg123name;				/* Command to execute mpg123 */
extern bool intersessionmemory;			/* Enable/Disable intersession memory */
extern bool helpdialogs;				/* Enable/Disable help dialogs */
extern int displaymode;					/* Mode in which tracks will be displayed in the browse and playlist dialogs */
extern int displayformat;				/* Format in which tracks will be displayed in the browse and playlist dialogs */
extern int shortenmethod;				/* Method that will be used to fit files (that is too long to be displayed properly) into the menu */

/*
 * Menu Identifiers
 */

#define ID_EDIT			1
#define ID_SETUP		2
#define ID_MIXER		3
#define ID_BROWSE		4
#define ID_REARRANGE	5
#define ID_PLAYLISTS	6
#define ID_TRACKMENU	7
#define ID_SAVE			8
#define ID_LOAD			9
#define ID_NEWTRACK		10
#define ID_CURTRACK		11
#define ID_STOPRESUME	12
#define ID_HELP			13
#define ID_AUDIOPATH	14
#define ID_PLAYLISTPATH	15
#define ID_INPUT		16
#define ID_HELPHELP		17
#define ID_MPG123		18

/*
 * Global variables
 */

extern bool track_paused;

#endif
