
/*
 * cmd.c -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PLAYER_CMD_C
#define PLAYER_CMD_C

#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>

//#include "typedefs.h"
#include "child.h"

char **cmd_args;

#ifdef WITH_SHELL_SUPPORT
const char shellpath[] = "/bin/sh";
const char shellname[] = "sh";
const char shellargs[] = "-c";
#endif

void split_cmd_args (const char *progname)
{
   char word[255];
   int i,j,nargs;
#ifdef WITH_SHELL_SUPPORT
   cmd_args = (char **) malloc (3 * sizeof (char *));
   cmd_args[0] = (char *) shellpath;
   cmd_args[1] = (char *) shellname;
   cmd_args[2] = (char *) shellargs;
   nargs = 3;
   i = 0;
#else
   cmd_args = NULL;
   i = nargs = 0;
#endif
   while (i < (int) strlen (progname))
	 {
		j = 0;
		while ((i < (int) strlen (progname)) && (!isspace (progname[i])))
		  word[j++] = progname[i++];
		while ((i < (int) strlen (progname)) && (isspace (progname[i]))) i++;
		word[j] = '\0';
		cmd_args = (char **) realloc (cmd_args,(nargs + 1) * sizeof (char *));
		cmd_args[nargs] = (char *) malloc ((strlen (word) + 1) * sizeof (char));
		strcpy (cmd_args[nargs],word);
		nargs++;
	 }
   cmd_args = (char **) realloc (cmd_args,(nargs + 1) * sizeof (char *));
   cmd_args[nargs] = NULL;
}

bool run_command_list (const int nargs, ...)
{
   va_list ap;
   char **tmp;
   int i,j;
   bool result;
   tmp = NULL;
   i = 0;
#ifdef WITH_SHELL_SUPPORT
   while (cmd_args[i + 1])
#else
   while (cmd_args[i])
#endif
	 {
		i++;
		tmp = (char **) realloc (tmp,i * sizeof (char *));
#ifdef WITH_SHELL_SUPPORT
		tmp[i - 1] = cmd_args[i];
#else
		tmp[i - 1] = cmd_args[i - 1];
#endif
	 }
   va_start (ap,nargs);
   for (j = 0; j < nargs; j++)
	 {
		tmp = (char **) realloc (tmp,(i + 1) * sizeof (char *));
		tmp[i] = va_arg (ap,char *);
		i++;
	 }
   tmp = (char **) realloc (tmp,(i + 1) * sizeof (char *));
   tmp[i] = NULL;
   va_end (ap);
   result = child_create (*cmd_args,tmp);
   free (tmp);
   return result;
}

bool run_command_null (const char *arguments[])
{
   char **tmp;
   int i,j;
   bool result;
   tmp = NULL;
   i = 0;
#ifdef WITH_SHELL_SUPPORT
   while (cmd_args[i + 1])
#else
   while (cmd_args[i])
#endif
	 {
		i++;
		tmp = (char **) realloc (tmp,i * sizeof (char *));
#ifdef WITH_SHELL_SUPPORT
		tmp[i - 1] = cmd_args[i];
#else
		tmp[i - 1] = cmd_args[i - 1];
#endif
	 }
   j = 0;
   while (arguments[j] != NULL)
	 {
		tmp = (char **) realloc (tmp,(i + 1) * sizeof (char *));
		tmp[i] = (char *) arguments[j];
		i++;
		j++;
	 }
   tmp = (char **) realloc (tmp,(i + 1) * sizeof (char *));
   tmp[i] = NULL;
   result = child_create (*cmd_args,tmp);
   free (tmp);
   return result;
}

void destroy_split_args ()
{
#ifdef WITH_SHELL_SUPPORT
   int i = 3;
#else
   int i = 0;
#endif
   while (cmd_args[i])
	 {
		free (cmd_args[i]);
		i++;
	 }
   free (cmd_args);
}

#endif
