%define name    jdresolve
%define	version	0.5.2
%define release 1
%define prefix  /usr

Summary: jdresolve resolves IP addresses into hostnames with recursion

Name: %{name}
Version: %{version}
Release: %{release}

Copyright: GPL
Group: Development/Languages
Source: http://www.jdrowell.com/files/%{name}-%{version}.tar.gz
Url: http://www.jdrowell.com/Linux/Projects/jdresolve
Packager: John Douglas Rowell <me@jdrowell.com>

BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
Requires: perl >= 5.004, perl-Net-DNS >= 0.12

%description
        The jdresolve application resolves IP addresses into hostnames.
To reduce the time necessary to resolve large batches of addresses,
jdresolve opens many concurrent connections to the DNS servers, and
keeps a large number of text lines in memory. These lines can have any
content, as long as the IP addresses are the first field to the left.
This is usually the case with most formats of HTTP and FTP log files.

        For addresses that can't be resolved due to timeouts or
incorrectly configured reverse mappings, a recursive algorithm is
available. A search is made for the parent domains (classes C, B and A)
of the IP address and those domain names become available for composing
a fake hostname, thru a user defined mask.

%changelog
* Mon Aug 16 1999 John Douglas Rowell <me@jdrowell.com>
- version 0.5.1
- fixed warning messages on FreeBSD
- added jdresolve-mergedb and jdresolve-unresolved utils

* Wed Jul 27 1999 John Douglas Rowell <me@jdrowell.com>
- version 0.5
- Added database support (--database and jdresolve-dumpdb)

* Wed Jul 14 1999 John Douglas Rowell <me@jdrowell.com>
- First build (v0.4).

%ifarch noarch

%prep

%setup

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{prefix}/bin
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc CHANGELOG  COPYING  CREDITS  INSTALL  README  TODO
/usr/bin/jdresolve
/usr/bin/jdresolve-dumpdb
/usr/bin/jdresolve-mergedb
/usr/bin/jdresolve-unresolved
/usr/bin/rhost

%endif

