/* Kernel module to match tproxied packets
 */
#include <linux/module.h>
#include <linux/types.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4/ip_conntrack.h>
#include <linux/netfilter_ipv4/ip_tables.h>

static int
match(const struct sk_buff *skb,
      const struct net_device *in,
      const struct net_device *out,
      const void *matchinfo,
      int offset,
      const void *hdr,
      u_int16_t datalen,
      int *hotdrop)
{
	enum ip_conntrack_info ctinfo;
	struct ip_conntrack *ct;
	
	ct = ip_conntrack_get((struct sk_buff *)skb, &ctinfo);
	if (ct)
		return ct->status & IPS_TPROXY;
	else
		return 0;
}

static int check(const char *tablename,
		 const struct ipt_ip *ip,
		 void *matchinfo,
		 unsigned int matchsize,
		 unsigned int hook_mask)
{
	if (matchsize != 0)
		return 0;

	return 1;
}

static struct ipt_match tproxy_match
= { { NULL, NULL }, "tproxy", &match, &check, NULL, THIS_MODULE };

static int __init init(void)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,25)
	if (ip_conntrack_module)
		__MOD_INC_USE_COUNT(ip_conntrack_module);
#endif
	return ipt_register_match(&tproxy_match);
}

static void __exit fini(void)
{
	ipt_unregister_match(&tproxy_match);
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,25)
	if (ip_conntrack_module)
		__MOD_DEC_USE_COUNT(ip_conntrack_module);
#endif
}

module_init(init);
module_exit(fini);
MODULE_LICENSE("GPL");
