// -*- C++ -*-
// --------------------------------------------------------------------
// The visitor base class.
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEVISITOR_H
#define IPEVISITOR_H

#include "ipeobj.h"

class IpeGroup;
class IpePath;
class IpeMark;
class IpeText;
class IpeImage;
class IpeReference;

// --------------------------------------------------------------------

class IPE_EXPORT IpeVisitor {
public:
  virtual ~IpeVisitor();

  //! Operator syntax: Visitor(IpeObject).
  void operator()(const IpeObject *obj) { obj->Accept(*this); }

  //! Operator syntax: Visitor(IpePgObject).
  void operator()(const IpePgObject &obj) { obj.Object()->Accept(*this); }

  virtual void VisitGroup(const IpeGroup *obj);
  virtual void VisitPath(const IpePath *obj);
  virtual void VisitMark(const IpeMark *obj);
  virtual void VisitText(const IpeText *obj);
  virtual void VisitImage(const IpeImage *obj);
  virtual void VisitReference(const IpeReference *obj);
  virtual void VisitObject(const IpeObject *obj);
};

// --------------------------------------------------------------------
#endif
