<?php
/*
 File: remote_login.php3
 $Author: chuck $
 $Revision: 1.1.2.4 $
 $Date: 2000/06/28 13:55:15 $
 
 Originally by: Mike Richichi <mrichich@drew.edu>
 Date: May 20, 2000
 Stolen from: imp CVS remote_login.php, hacked to work with IMP 2.2.0
 
 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
require '../lib/horde.lib';
require './lib/imp.lib';
require './config/defaults.php3';
require './config/mailbox.php3';
require '../config/horde.php3';
require './config/html.php3';

page_open(array('sess' => 'HordeSession'));

/* If we already have a session... */
if (isset($imp) && is_object($imp)) {
	/* Make sure that if a username was specified, it is the current username */
	if ((!isset($imapuser) || $imapuser == $imp->user) && (!isset($pass) || $pass == $imp->pass)) {
		page_close();
		/* ... just redirect to the frameset */
		$sess->mode = 'get'; // make sure the sessionid is in the url, in case the cookie doesn't take with the redirect
		header('Location: ' . $sess->url('index.php3'));
		exit;
	} else {
		/* disable the old session */
		$imp = false;
		$sess->unregister('imp');
		/* go on to a loginform or new session, as appropriate */
	}
}

/* Create a new session if we're given the proper parameters. */
if (isset($imapuser) && isset($pass)) {
    if (!isset($mailbox)) $mailbox = 'INBOX';
    $imp = new ImpSession();
    $imp->construct();
    $imp->pickle();
    $sess->register('imp');
	page_close();
	/* Redirect the user to the IMP frameset. */
	$sess->mode = 'get'; // make sure the sessionid is in the url, in case the cookie doesn't take with the redirect
	header('Location: ' . $sess->url('index.php3'));
	exit;
}
page_close();

if (!isset($imapuser)) {
	if (isset($PATH_INFO)) $imapuser = basename($PATH_INFO);
}
	 
?>

<html>
<head>
</head>

<body bgcolor="white">

<form action="<?php $sess->pself_url() ?>" method="post">
<input type="hidden" notab name="actionid" value="6">
<input type="hidden" notab name="mailbox" value="INBOX">
Username:&nbsp;&nbsp;<input type="text" tabindex="1" name="imapuser" value="<?php if (isset($imapuser)) echo $imapuser ?>"><br>
Password:&nbsp;&nbsp;<input type="password" tabindex="2" name="pass"><br><br>
<input type="submit" tabindex="3" value="Log in">
<input type="reset" value="Clear">
</form>

</body>
</html>
