/* reset tape drive -- 'mt' should handle this -- don't want to patch it yet */

/* don't forget to use -static when compiling this one! */

#include <stdio.h>
#include <sys/mtio.h>

int main(int argc, char *argv[], char *envp[])
{
	FILE *p;
	int status;
	struct mtop op;

	if (argc!=1) {
		printf("Usage is:\n\t%s\nresets tape drive /dev/tape\n", argv[0]);
		exit(1);
	}

	if (((p = fopen("/dev/tape", "r")) == NULL) &&
	    ((p = fopen("/dev/rmt0", "r")) == NULL) &&
	    ((p = fopen("/dev/tape-reset", "r")))) {
		perror("Could not open tape device /dev/{tape,rmt0,tape-reset}");
		exit(1);
	}
	
	op.mt_op = MTRESET;
	op.mt_count = 1;
	status = ioctl(fileno(p), MTIOCTOP, &op);
	fclose(p);
	printf("%s: return status: %d\n", argv[0], status);
	if (status!=0)
		perror("mtreset");
	exit(status);
}

