/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* The march element  Up/Down(rp, wn, rn) */

.text

.align 16

.globl marchel_rp_wn_rn_ml
marchel_rp_wn_rn_ml:


#define NormalEl
#include "marchel_ml_template.S"


/* The real test routine ****************************************************/

.align 16

begintest:
loop:
/* rp, wn */
	movq  (%eax), %mm2		/* mm2 = data from memory */

	movq  %mm1, (%eax)		/* write neg pattern (mm1) to memory */

	movq  %mm2, %mm7		/* save read pattern in mm7 for
					   error reporting */
	pcmpeqd %mm0, %mm2		/* compare on 32-bit basis; 1's = ok */
	psrlq %mm3, %mm2		/* shift 16 places to right */
	movd  %mm2, %edx		/* copy to 32-bit register */
	notl  %edx			/* invert check: all 0's = ok */
	test  %edx, %ebp		/* test bits of edx */
	jnz   fault1			/* in case of not all 0's: fault! */

part2:
/* rn */
	movq  (%eax), %mm2		/* mm2 = data from memory */

	movq  %mm2, %mm7		/* save read pattern in mm7 for
					   error reporting */
	pcmpeqd %mm1, %mm2		/* compare on 32-bit basis; 1's = ok */
	psrlq %mm3, %mm2		/* shift 16 places to right */
	movd  %mm2, %edx		/* copy to 32-bit register */
	notl  %edx			/* invert check: all 0's = ok */
	test  %edx, %ebp		/* test bits of edx */
	jnz   fault2			/* in case of not all 0's: fault! */

nextadr:
	addl  %ebx, %eax		/* address++ or -- */
	cmpl  %edi, %eax		/* test if enough */
conditionbyte:
	jbe   loop			/* autonomous loop */

	call  update_adr
	jnc   loop                      /* carry set = end of test */

	ret



/* Error reporting **********************************************************/

fault1:
	/* Store error */
	movl  error_p, %edx		/* get pointer to store address */
	cmpl  lasterror_p, %edx		/* skip if all space used */
	jae   errorfull1

	movl  $0, (%edx)		/* seq.num of `read' element */
	addl  $4, %edx
	movl  %eax, (%edx)		/* error address */
	addl  $4, %edx
	movq  %mm0, (%edx)		/* expected pattern */
	addl  $8, %edx
	movq  %mm7, (%edx)		/* read pattern */
	addl  $8, %edx
	movl  %edx, error_p		/* write back new error_p */

errorfull1:
	movl  sub_errorno, %edx		/* increase error count */
	addl  $1, %edx
	movl  %edx, sub_errorno

	/* Continue test */
	jmp   part2

fault2:
	/* Store error */
	movl  error_p, %edx		/* get pointer to store address */
	cmpl  lasterror_p, %edx		/* skip if all space used */
	jae   errorfull2

	movl  $1, (%edx)		/* seq.num of `read' element */
	addl  $4, %edx
	movl  %eax, (%edx)		/* error address */
	addl  $4, %edx
	movq  %mm1, (%edx)		/* expected pattern */
	addl  $8, %edx
	movq  %mm7, (%edx)		/* read pattern */
	addl  $8, %edx
	movl  %edx, error_p		/* write back new error_p */

errorfull2:
	movl  sub_errorno, %edx		/* increase error count */
	addl  $1, %edx
	movl  %edx, sub_errorno

	/* Continue test */
	jmp   nextadr


/* 
Some data might be needed for local reference. This should be right here
(not in the .data area) to have it cached like the program itself. 

test_data:
	.fill 12
*/

endtest:
	nop


