///////
   //    AccessibilityCheck.h
   //    AccessibilityCheck Class declaration
   //
   //    Class for AccessibilityCheck storage
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: AccessibilityCheck.h,v 1.1 2004/03/30 11:07:35 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 29.03.2004
///////

#ifndef _ACCESSIBILITYCHECK_H
#define _ACCESSIBILITYCHECK_H

#include <Object.h>
#include <htString.h>


class AccessibilityCheck : public Object
{

   // Write the object to the output
   friend ostream& operator<<( ostream&, const AccessibilityCheck& );
   
   public:
   
      // Construction / Destruction
      AccessibilityCheck();
      virtual ~AccessibilityCheck();

///////
   //    Public Interface
///////

      void Reset();

      void SetIDCheck(unsigned int id) { IDCheck = id; }
      void SetIDUrl        (unsigned int id) { IDUrl = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetAttrPosition (unsigned int ap) { AttrPosition = ap; }
      void SetCode (unsigned int c) { Code = c; }

      unsigned int GetIDCheck() const          { return IDCheck; }
      unsigned int GetIDUrl() const          { return IDUrl; }
      unsigned int GetTagPosition() const    { return TagPosition; }
      unsigned int GetAttrPosition() const   { return AttrPosition; }
      unsigned int GetCode() const   { return Code; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}
      static void SetLastID (unsigned int d) { last_id=d; }
      static unsigned int GetLastID () { return last_id;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int   IDCheck;
      unsigned int   IDUrl;
      unsigned int   TagPosition;
      unsigned int   AttrPosition;
      unsigned int   Code;
      
///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level
      static unsigned int last_id; // last id for the accessibility check

};

#endif
