#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>

#include "hping2.h"
#include "globals.h"

void send_rawip (int signal_id)
{
	int errno_save = errno;
	char *packet;

	packet = malloc(data_size);
	if (packet == NULL) {
		perror("[send_rawip] malloc()");
		errno = errno_save;
		return;
	}
	memset(packet, 0, data_size);
	data_handler(packet, data_size);
	send_ip_handler(packet, data_size);
	free(packet);

	sent_pkt++;
	Signal(SIGALRM, send_rawip);
	
	if (count != -1 && count == sent_pkt)	/* count reached */
	{
		Signal(SIGALRM, print_statistics);
		alarm(COUNTREACHED_TIMEOUT);
	}
	else if (!opt_listenmode)
	{
		if (opt_waitinusec == FALSE)
			alarm(sending_wait);
		else
			setitimer(ITIMER_REAL, &usec_delay, NULL);
	}
	errno = errno_save;
}
