/*
 * hfsputils - tools for reading and writing Macintosh HFS volumes
 *
 * The structure defined here is saved in the users home directory
 * to cache the status of the HFS+ access.
 *
 * Copyright (C) 2000 Klaus Halfmann <khalfmann@libra.de>
 * Original 1996-1998 Robert Leslie <rob@mars.org>
 * Additional work by  Brad Boyer (flar@pants.nu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: hpcache.h,v 1.3 2000/09/26 06:27:44 hasi Exp $
 */

/* call volume_open etc. and set the record to the volumes record */
extern int hpcache_open(volume* vol, record* rev, char* devicename);

/* call volume_open etc. and set the record to the last used folder */
extern int hpcache_reopen(volume* vol, record* rev);

/* Set the current folder to the given CNID */
extern int hpcache_cwd(UInt32 cnid);

/* Delete the information collected by _open */
extern int hpcache_destroy();
