// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         The info field area 
// ****************************************************************************

// Copyright 2008, 2009, 2010, 2011 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#ifndef __INFOFIELD_H__
#define __INFOFIELD_H__

#include <QtGui>      //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

#ifndef __DEVICE_H__
  #include "device.h"
#endif

class t_InfoFieldLocal;

class t_InfoField: public QFrame
{
   Q_OBJECT

   public:
      t_InfoField ();
      t_InfoField (QWidget *pParent);
     ~t_InfoField ();

   public slots:
      void SlotShowInfo (t_pDevice pDevice);

   private:
      t_InfoFieldLocal *pOwn;
};

typedef t_InfoField *t_pInfoField;


// ------------------------------------
//             Error codes
// ------------------------------------

   #ifdef __MODULES_H__
      enum
      {
         ERROR_INFOFIELD_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_INFOFIELD + 1,
         
      };
   #endif

#endif
