use strict;
use Data::Dumper;

# Initialise filenames and check they're there

unless(-f 't/rpmfiles.txt') {
  print STDERR "test data missing...";
  print "1..0\n";
  exit 0;
}

print "1..1\n";

my $t = 1;

##############################################################################
#                   S U P P O R T   R O U T I N E S
##############################################################################

##############################################################################
# Print out 'n ok' or 'n not ok' as expected by test harness.
# First arg is test number (n).  If only one following arg, it is interpreted
# as true/false value.  If two args, equality = true.
#

sub ok {
  my($n, $x, $y) = @_;
  die "Sequence error got $n expected $t" if($n != $t);
  $x = 0 if(@_ > 2  and  $x ne $y);
  print(($x ? '' : 'not '), 'ok ', $t++, "\n");
}

my $gpath = $ENV{GPT_LOCATION};

if (!defined($gpath))
{
  $gpath = $ENV{GLOBUS_LOCATION};

}

if (!defined($gpath))
{
   die "GPT_LOCATION or GLOBUS_LOCATION needs to be set before running this script"
}

@INC = (@INC, "$gpath/lib/perl");

require Grid::GPT::PkgDist;
require Grid::GPT::Definitions;

my $dist = new Grid::GPT::PkgDist(pkglist => "t/rpmfiles.txt");


open (OUT, ">t/rpmnames.rslt");
select OUT;
print "++++++++++++++++Table++++++++++++++++++\n";
$dist->printtable();
select STDOUT;
close OUT;

my $result = ! system("diff -b -w t/rpmnames.rslt t/rpmnames.exp");

ok($t, $result);
