/*
 *  PGGraphvizHelpController.m
 *  graphviz
 *
 *  Created by Glen Low on Wed May 12 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#import "PGGraphvizHelpController.h"

@implementation PGGraphvizHelpController

- (void) awakeFromNib
	{
		NSBundle* mainBundle = [NSBundle mainBundle];

		NSEnumerator* eachResource = [[NSArray arrayWithContentsOfFile:
			[mainBundle pathForResource: @"Online" ofType: @"plist"]] objectEnumerator];
		NSDictionary* nextResource;
		while ((nextResource = [eachResource nextObject]))
			{
				NSString* nextTitle = [nextResource objectForKey: @"title"];
				if (nextTitle)
					{
						id <NSMenuItem> item = [resources
							addItemWithTitle: nextTitle
							action: @selector (navigate:)
							keyEquivalent: @""];
							
						if ([item respondsToSelector: @selector (setIndentationLevel:)])
							{
								NSNumber* indent = [nextResource objectForKey: @"indent"];
								if (indent)
									[item setIndentationLevel: [indent intValue]];
							}
						[item setRepresentedObject: [NSURL URLWithString: [nextResource objectForKey: @"url"]]];
						[item setTarget: self];
					}
				else
					[resources addItem: [NSMenuItem separatorItem]];
			}
		
		NSEnumerator* eachGuide = [[mainBundle pathsForResourcesOfType: @"pdf" inDirectory: @"Guides"] objectEnumerator];
		NSString* nextGuide;
		while ((nextGuide = [eachGuide nextObject]))
			{
				NSString* file = [[nextGuide lastPathComponent] stringByDeletingPathExtension];
				NSString* name = [file substringToIndex: [file length] - 5];
				id <NSMenuItem> item = [guides
					addItemWithTitle: [mainBundle localizedStringForKey: [NSString stringWithFormat: @"layout.%@", name] value: name table: @"Descriptions"]
					action: @selector (navigate:)
					keyEquivalent: @""];
				[item setRepresentedObject: [NSURL fileURLWithPath: nextGuide]];
				[item setTarget: self];			
			}

		// add all the manuals we can find
		NSEnumerator* eachManual = [[mainBundle pathsForResourcesOfType: @"pdf" inDirectory: @"Manuals"] objectEnumerator];
		NSString* nextManual;
		while ((nextManual = [eachManual nextObject]))
			{
				id <NSMenuItem> item = [manuals
					addItemWithTitle: [[nextManual lastPathComponent] stringByDeletingPathExtension]
					action: @selector (navigate:)
					keyEquivalent: @""];
				[item setRepresentedObject: [NSURL fileURLWithPath: nextManual]];
				[item setTarget: self];			
			}
	}
	
- (void) navigate: (id) sender
	{
		[[NSWorkspace sharedWorkspace] openURL: [sender representedObject]];
	}
	
@end
