/* $Id: simple.h,v 1.5 2005/04/05 12:02:56 ellson Exp $ $Revision: 1.5 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/
#include <stdio.h>
#include "pathplan.h"

#define MAXINTS  10000	/* modify this line to reflect the max no. of 
	intersections you want reported -- 50000 seems to break the program */

#define SLOPE(p,q) ( ( ( p.y ) - ( q.y ) ) / ( ( p.x ) - ( q.x ) ) )

#define after(v) (((v)==((v)->poly->finish))?((v)->poly->start):((v)+1))
#define prior(v) (((v)==((v)->poly->start))?((v)->poly->finish):((v)-1))

struct position  { float x,y; };


struct vertex	{	
	struct position pos;
	struct polygon *poly;
	struct active_edge *active;
		};

struct polygon	{ struct vertex *start,*finish;};

struct intersection   { 
	struct vertex *firstv,*secondv; 
	struct polygon *firstp,*secondp; 
	float x,y; } ;

struct active_edge { struct vertex *name; struct active_edge *next,*last; }; 
struct active_edge_list { struct active_edge *first,*final ; int number ; } ;
struct data    { int nvertices, npolygons, ninters;} ;
