/* $Id: bufferGraphStream.h,v 1.6 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

//#include <io.h>
#include <fcntl.h>
// at one point i was able to nest two yacc parsers okay, but it stopped working,
// ag_yyparse seems to mess up the state of the input stream for gs_yyparse.
// so just make a brand new stream for each agread.
// (this is only successful sometimes)
struct bufferGraphStream {
	FILE *fin;
	static std::pair<bool,int> braceCount(const char *s) {
		bool action = false;
		int ct = 0;
		for(const char *ci = s; *ci; ++ci)
			if(*ci=='{')
				++ct,action=true;
			else if(*ci=='}')
				--ct,action=true;
		return std::make_pair(action,ct);
	}
	bufferGraphStream(FILE *f) : fin(0) {
		fin = tmpfile();
		bool action=false;
		int countBrace = 0;
		while(!action || countBrace) {
			char buf2[400];
			fgets(buf2,400,f);
			fputs(buf2,fin);
			std::pair<bool,int> bi = braceCount(buf2);
			action |= bi.first;
			countBrace += bi.second;
		}
		fseek(fin,0,SEEK_SET);
		setvbuf(fin,0,_IONBF,0);
	}
	~bufferGraphStream() {
		if(fin)
			fclose(fin);
	}
};
