/* $Id: circo.c,v 1.11 2004/12/11 19:26:05 ellson Exp $ $Revision: 1.11 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/


/*
 * Written by Krishnam Raju Pericherla
 * Derived from Kaufman&Wiese and Six&Tollis algorithms.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include   "circular.h"
#include        <time.h>
#ifdef HAVE_UNISTD_H
#include	<unistd.h>
#endif

char *Info[] = {
    "circo",			/* Program */
    VERSION,			/* Version */
    BUILDDATE			/* Build Date */
};

static GVC_t *gvc;

#ifndef MSWIN32
static void intr(int s)
{
    if (gvc->g)
	dotneato_write(gvc);
    dotneato_terminate(gvc);
    exit(1);
}
#endif

int main(int argc, char **argv)
{
    graph_t *g, *prev = NULL;

    gvc = gvNEWcontext(Info, username());

    dotneato_initialize(gvc, argc, argv);
#ifndef MSWIN32
    signal(SIGUSR1, toggle);
    signal(SIGINT, intr);
#endif

    while ((g = next_input_graph())) {
	if (prev) {
	    circo_cleanup(prev);
	    agclose(prev);
	}
	prev = g;

	gvBindContext(gvc, g);

	circo_layout(g);
	dotneato_write(gvc);
    }
    dotneato_terminate(gvc);
    return 1;
}
