/*
 * gom_driver.h: interface to soundcard driver
 */

/* 
 * This file is part of the package
 *
 * gom, Gom is nOt yet another Mixer
 *
 * (c) Stephan Suerken <suerken@fh-worms.de> 1996, 1997
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * INCLUDES
 */

/*
 * MACROS
 */

/* driver-known channels & channel channels (volumes) */
#define GOM_DRIVER_CHANNELS         SOUND_MIXER_NRDEVICES  /* = gom_driver_C_len()    */
#define GOM_DRIVER_CHANNEL_CHANNELS 2                      /* = gom_driver_C_C_len(c) */

/*
 * DECLARATIONS/DEFINTIONS
 */

/*
 * FUNCTION PROTOTYPES
 */

/*
 * THIS DRIVER'S ID
 */
char * 
gom_driver();


/*
 * DEVICE
 */

char * 
gom_driver_d();
int
gom_driver_d_opened();
int 
gom_driver_d_set(enum gom_info_types std_verb,
		 char * device_file);


/*
 * MIXER CHANNELS KNOWN TO THIS DRIVER
 */

int
gom_driver_C (int c);
int
gom_driver_C_first ()		       ;
int
gom_driver_C_last ()		       ;
int
gom_driver_C_next(int c, int jump)		       ;
int
gom_driver_C_len ()		       ;
char * 
gom_driver_C_name(unsigned c);

/*
 * AVAILABLE CHANNELS
 */

int
gom_driver_c (int c);
int
gom_driver_c_first ()		       ;
int
gom_driver_c_last ()		       ;
int
gom_driver_c_next (int c, int jump)		       ;
int
gom_driver_c_len ()		       ;
char * 
gom_driver_c_name(int c);


/*
 * CHANNEL CHANNELS
 */

int
gom_driver_C_C (int c, int cc);
int
gom_driver_C_C_first (int c)		       ;
int
gom_driver_C_C_last (int c)		       ;
int
gom_driver_C_C_next (int c, int cc, int jump);
int
gom_driver_C_C_len (int c)    ;
char * 
gom_driver_C_C_name (int c, int cc);

/*
 * AVAILABLE CHANNEL CHANNELS
 */

int
gom_driver_c_c (int c, int cc);
int
gom_driver_c_c_first (int c)		       ;
int
gom_driver_c_c_last (int c)		       ;
int
gom_driver_c_c_next (int c, int cc, int jump);
int
gom_driver_c_c_len (int c);
char * 
gom_driver_c_c_name (int c, int cc);

/*
 * VOLUMES
 */
int 
gom_driver_c_c_v_max ();
int 
gom_driver_c_c_v_range(int v);
int
gom_driver_c_c_v (int c, int cc);
void
gom_driver_c_c_v_set (enum gom_info_types std_verb,
		      int c, int cc, int v);

/*
 * RECORD
 */
int
gom_driver_c_r (int c);
void 
gom_driver_c_r_set (enum gom_info_types std_verb,
		    int c, int r);
