/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs.h,v 1.47 2000/04/19 01:29:02 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PREFS_H__
#define __PREFS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include "main.h"
#include "srcctrl.h"

/* general/global options and macros */
#define AUTO_INDENT			(1 << 0)
#define SHOW_TABS			(1 << 1)
#define SHOW_MSGBAR			(1 << 2)
#define SHOW_TOOLBAR			(1 << 3)
#define PIC_TEXT_TOOLBAR		(1 << 4)
#define TEXT_ONLY_TOOLBAR		(1 << 5)
#define PIC_ONLY_TOOLBAR		(1 << 6)
#define SHOW_TOOLTIPS			(1 << 7)
#define USE_WORDWRAP			(1 << 8)
#define SAVE_WIN_WIDTH			(1 << 9)
#define SAVE_WIN_HEIGHT			(1 << 10)
#define SAVE_WIN_POS			(1 << 11)
#define USE_MSGBOX			(1 << 12)
#define SHOW_PRJBAR			(1 << 13)
#define TOOLBAR_RAISED			(1 << 14)
#define SHOW_HTML_TOOLBAR		(1 << 15)
#define SHOW_SPLASH			(1 << 16)
#define ENABLE_SESSION			(1 << 17)
#define DO_BACKUP			(1 << 18)
#define DOC_TABS_TOP			(1 << 19)
#define DOC_TABS_BOTTOM			(1 << 20)
#define DOC_TABS_LEFT			(1 << 21)
#define DOC_TABS_RIGHT			(1 << 22)
#define ADVANCED_HTML_TB		(1 << 23)
#define USE_FONTSET			(1 << 24)
#define HTML_TAG_LOWER			(1 << 25)
#define HTML_TAG_UPPER			(1 << 26)
#define USE_GTK_THEME_FONTS		(1 << 27)
#define USER_NAME_IN_TITLE		(1 << 28)
#define HOST_NAME_IN_TITLE		(1 << 29)

#define DEFAULT_OPTIONS 		(AUTO_INDENT      | SHOW_TABS     | \
					 SHOW_MSGBAR      | SHOW_TOOLBAR  | \
					 PIC_ONLY_TOOLBAR | SHOW_TOOLTIPS | \
					 SAVE_WIN_HEIGHT  | USE_MSGBOX | \
					 SHOW_SPLASH      | SHOW_PRJBAR | \
					 DO_BACKUP        | DOC_TABS_TOP | \
					 SHOW_HTML_TOOLBAR| HTML_TAG_UPPER | \
					 SAVE_WIN_WIDTH   | SAVE_WIN_HEIGHT)

/* these macros operate on the global variable 'options' */
#define IS_AUTO_INDENT()		(prefs.options1 & AUTO_INDENT)
#define IS_SHOW_TABS()			(prefs.options1 & SHOW_TABS)
#define IS_SHOW_MSGBAR()		(prefs.options1 & SHOW_MSGBAR)
#define IS_SHOW_TOOLBAR()		(prefs.options1 & SHOW_TOOLBAR)
#define IS_TEXT_PIC_TOOLBAR()		(prefs.options1 & PIC_TEXT_TOOLBAR)
#define IS_TEXT_TOOLBAR()		(prefs.options1 & TEXT_ONLY_TOOLBAR)
#define IS_PIC_TOOLBAR()		(prefs.options1 & PIC_ONLY_TOOLBAR)
#define IS_SHOW_TOOLTIPS()		(prefs.options1 & SHOW_TOOLTIPS)
#define IS_USE_WORDWRAP()		(prefs.options1 & USE_WORDWRAP)
#define IS_USE_MSGBOX()			(prefs.options1 & USE_MSGBOX)
#define IS_SAVE_WIN_WIDTH()		(prefs.options1 & SAVE_WIN_WIDTH)
#define IS_SAVE_WIN_HEIGHT()		(prefs.options1 & SAVE_WIN_HEIGHT)
#define IS_SAVE_WIN_POS()		(prefs.options1 & SAVE_WIN_POS)
#define IS_SHOW_PRJBAR()		(prefs.options1 & SHOW_PRJBAR)
#define IS_TOOLBAR_RAISED()		(prefs.options1 & TOOLBAR_RAISED)
#define IS_SHOW_HTML_TOOLBAR()		(prefs.options1 & SHOW_HTML_TOOLBAR)
#define IS_SHOW_SPLASH()		(prefs.options1 & SHOW_SPLASH)
#define IS_ENABLE_SESSION()		(prefs.options1 & ENABLE_SESSION)
#define IS_DO_BACKUP()			(prefs.options1 & DO_BACKUP)
#define IS_DOC_TABS_TOP()		(prefs.options1 & DOC_TABS_TOP)
#define IS_DOC_TABS_BOTTOM()		(prefs.options1 & DOC_TABS_BOTTOM)
#define IS_DOC_TABS_LEFT()		(prefs.options1 & DOC_TABS_LEFT)
#define IS_DOC_TABS_RIGHT()		(prefs.options1 & DOC_TABS_RIGHT)
#define IS_ADVANCED_HTML_TB()		(prefs.options1 & ADVANCED_HTML_TB)
#define IS_USE_FONTSET()		(prefs.options1 & USE_FONTSET)
#define IS_HTML_TAG_LOWER()		(prefs.options1 & HTML_TAG_LOWER)
#define IS_HTML_TAG_UPPER()		(prefs.options1 & HTML_TAG_UPPER)
#define IS_USE_GTK_THEME_FONTS()	(prefs.options1 & USE_GTK_THEME_FONTS)
#define IS_USER_NAME_IN_TITLE()		(prefs.options1 & USER_NAME_IN_TITLE)
#define IS_HOST_NAME_IN_TITLE()		(prefs.options1 & HOST_NAME_IN_TITLE)

#define SET_SHOW_TABS()			(prefs.options1 |= SHOW_TABS)
#define SET_SHOW_MSGBAR()		(prefs.options1 |= SHOW_MSGBAR)
#define SET_SHOW_TOOLBAR()		(prefs.options1 |= SHOW_TOOLBAR)
#define SET_TEXT_ONLY_TOOLBAR()		(prefs.options1 |= TEXT_ONLY_TOOLBAR)
#define SET_PIC_ONLY_TOOLBAR()		(prefs.options1 |= PIC_ONLY_TOOLBAR)
#define SET_PIC_TEXT_TOOLBAR()		(prefs.options1 |= PIC_TEXT_TOOLBAR)
#define SET_SHOW_TOOLTIPS()		(prefs.options1 |= SHOW_TOOLTIPS)
#define SET_USE_WORDWRAP()		(prefs.options1 |= USE_WORDWRAP)
#define SET_SHOW_PRJBAR()		(prefs.options1 |= SHOW_PRJBAR)
#define SET_TOOLBAR_RAISED()		(prefs.options1 |= TOOLBAR_RAISED)
#define SET_SHOW_HTML_TOOLBAR()		(prefs.options1 |= SHOW_HTML_TOOLBAR)
#define SET_DOC_TABS_TOP()		(prefs.options1 |= DOC_TABS_TOP)
#define SET_DOC_TABS_BOTTOM()		(prefs.options1 |= DOC_TABS_BOTTOM)
#define SET_DOC_TABS_LEFT()		(prefs.options1 |= DOC_TABS_LEFT)
#define SET_DOC_TABS_RIGHT()		(prefs.options1 |= DOC_TABS_RIGHT)
#define SET_ADVANCED_HTML_TB()		(prefs.options1 |= ADVANCED_HTML_TB)
#define SET_USE_FONTSET()		(prefs.options1 |= USE_FONTSET)
#define SET_HTML_TAG_LOWER()		(prefs.options1 |= HTML_TAG_LOWER)
#define SET_HTML_TAG_UPPER()		(prefs.options1 |= HTML_TAG_UPPER)

#define CLEAR_SHOW_TABS()		(prefs.options1 &= ~SHOW_TABS)
#define CLEAR_SHOW_MSGBAR()		(prefs.options1 &= ~SHOW_MSGBAR)
#define CLEAR_SHOW_TOOLBAR()		(prefs.options1 &= ~SHOW_TOOLBAR)
#define CLEAR_PIC_TEXT_TOOLBAR()	(prefs.options1 &= ~PIC_TEXT_TOOLBAR)
#define CLEAR_TEXT_ONLY_TOOLBAR()	(prefs.options1 &= ~TEXT_ONLY_TOOLBAR)
#define CLEAR_PIC_ONLY_TOOLBAR()	(prefs.options1 &= ~PIC_ONLY_TOOLBAR)
#define CLEAR_SHOW_TOOLTIPS()		(prefs.options1 &= ~SHOW_TOOLTIPS)
#define CLEAR_USE_WORDWRAP()		(prefs.options1 &= ~USE_WORDWRAP)
#define CLEAR_USE_MSGBOX()		(prefs.options1 &= ~USE_MSGBOX)
#define CLEAR_SHOW_PRJBAR()		(prefs.options1 &= ~SHOW_PRJBAR)
#define CLEAR_TOOLBAR_RAISED()		(prefs.options1 &= ~TOOLBAR_RAISED)
#define CLEAR_SHOW_HTML_TOOLBAR()	(prefs.options1 &= ~SHOW_HTML_TOOLBAR)
#define CLEAR_DOC_TABS_TOP()		(prefs.options1 &= ~DOC_TABS_TOP)
#define CLEAR_DOC_TABS_BOTTOM()		(prefs.options1 &= ~DOC_TABS_BOTTOM)
#define CLEAR_DOC_TABS_LEFT()		(prefs.options1 &= ~DOC_TABS_LEFT)
#define CLEAR_DOC_TABS_RIGHT()		(prefs.options1 &= ~DOC_TABS_RIGHT)
#define CLEAR_ADVANCED_HTML_TB()	(prefs.options1 &= ~ADVANCED_HTML_TB)
#define CLEAR_USE_FONTSET()		(prefs.options1 &= ~USE_FONTSET)
#define CLEAR_HTML_TAG_LOWER()		(prefs.options1 &= ~HTML_TAG_LOWER)
#define CLEAR_HTML_TAG_UPPER()		(prefs.options1 &= ~HTML_TAG_UPPER)

/* main toolbar options */
#define SHOW_MAIN_NEW			(1 << 0)
#define SHOW_MAIN_OPEN			(1 << 1)
#define SHOW_MAIN_CLOSE			(1 << 2)
#define SHOW_MAIN_SAVE			(1 << 3)
#define SHOW_MAIN_PRINT			(1 << 4)
#define SHOW_MAIN_CUT			(1 << 5)
#define SHOW_MAIN_COPY			(1 << 6)
#define SHOW_MAIN_PASTE			(1 << 7)
#define SHOW_MAIN_PREFS			(1 << 8)
#define SHOW_MAIN_EXIT			(1 << 9)
#define SHOW_MAIN_FIND			(1 << 10)
#define SHOW_MAIN_FIND_NEXT		(1 << 11)
#define SHOW_MAIN_REPLACE		(1 << 12)
#define SHOW_MAIN_UNDO			(1 << 13)
#define SHOW_MAIN_REDO			(1 << 14)
#define SHOW_MAIN_WINNEW		(1 << 15)
#define SHOW_MAIN_WINCLOSE		(1 << 16)
 
#define DEFAULT_MAIN_TB_OPT		(SHOW_MAIN_NEW   | SHOW_MAIN_OPEN  | \
					 SHOW_MAIN_CLOSE | SHOW_MAIN_SAVE  | \
					 SHOW_MAIN_PRINT | SHOW_MAIN_CUT   | \
					 SHOW_MAIN_COPY  | SHOW_MAIN_PASTE | \
					 SHOW_MAIN_PREFS | SHOW_MAIN_EXIT  | \
					 SHOW_MAIN_FIND  | SHOW_MAIN_REPLACE | \
					 SHOW_MAIN_UNDO  | SHOW_MAIN_REDO | \
					 SHOW_MAIN_WINNEW| \
					 SHOW_MAIN_WINCLOSE | \
					 SHOW_MAIN_FIND_NEXT)

#define MAIN_TB_STR_NEW			"main_tb_new"
#define MAIN_TB_STR_OPEN		"main_tb_open"
#define MAIN_TB_STR_CLOSE		"main_tb_close"
#define MAIN_TB_STR_SAVE		"main_tb_save"
#define MAIN_TB_STR_PRINT		"main_tb_print"
#define MAIN_TB_STR_CUT			"main_tb_cut"
#define MAIN_TB_STR_COPY		"main_tb_copy"
#define MAIN_TB_STR_UNDO		"main_tb_undo"
#define MAIN_TB_STR_REDO		"main_tb_redo"
#define MAIN_TB_STR_PASTE		"main_tb_paste"
#define MAIN_TB_STR_FIND		"main_tb_find"
#define MAIN_TB_STR_FNEXT		"main_tb_fnext"
#define MAIN_TB_STR_REPLACE		"main_tb_replace"
#define MAIN_TB_STR_PREFS		"main_tb_prefs"
#define MAIN_TB_STR_EXIT		"main_tb_exit"
#define MAIN_TB_STR_WINNEW		"main_tb_winnew"
#define MAIN_TB_STR_WINCLOSE		"main_tb_winclose"


#ifdef USE_HTMLTAGS
/* html toolbar options */
#define SHOW_HTML_TTL			(1 << 0)
#define SHOW_HTML_LINK			(1 << 1)
#define SHOW_HTML_TARG			(1 << 2)
#define SHOW_HTML_IMG			(1 << 3)
#define SHOW_HTML_CMNT			(1 << 4)
#define SHOW_HTML_H1			(1 << 5)
#define SHOW_HTML_H2			(1 << 6)
#define SHOW_HTML_H3			(1 << 7)
#define SHOW_HTML_H4			(1 << 8)
#define SHOW_HTML_H5			(1 << 9)
#define SHOW_HTML_H6			(1 << 10)
#define SHOW_HTML_LEFT			(1 << 11)
#define SHOW_HTML_CENT			(1 << 12)
#define SHOW_HTML_RGHT			(1 << 13)
#define SHOW_HTML_BOLD			(1 << 14)
#define SHOW_HTML_ITAL			(1 << 15)
#define SHOW_HTML_ULNE			(1 << 16)
#define SHOW_HTML_TTY			(1 << 17)
#define SHOW_HTML_STRK			(1 << 18)
#define SHOW_HTML_EMPH			(1 << 19)
#define SHOW_HTML_STRG			(1 << 20)
#define SHOW_HTML_SUB			(1 << 21)
#define SHOW_HTML_SUP			(1 << 22)
#define SHOW_HTML_SEP			(1 << 23)
#define SHOW_HTML_PARA			(1 << 24)
#define SHOW_HTML_LBRK			(1 << 25)
#define SHOW_HTML_BIG			(1 << 26)
#define SHOW_HTML_SMLL			(1 << 27)
#define SHOW_HTML_ORDR			(1 << 28)
#define SHOW_HTML_UORD			(1 << 29)
#define SHOW_HTML_LITM			(1 << 30)
#define SHOW_HTML_DEF			(1 << 31)

#define SHOW_HTML_DLIST			(1 << 0)
#define SHOW_HTML_DTERM			(1 << 1)
#define SHOW_HTML_FONTM1		(1 << 2)
#define SHOW_HTML_FONTP1		(1 << 3)
#define SHOW_HTML_MENU			(1 << 4)
#define SHOW_HTML_PRE			(1 << 5)

#define DEFAULT_HTML_TB_OPT1		(SHOW_HTML_TTL  | SHOW_HTML_LINK | \
					 SHOW_HTML_TARG | SHOW_HTML_IMG  | \
					 SHOW_HTML_CMNT | SHOW_HTML_H1   | \
					 SHOW_HTML_H2   | SHOW_HTML_H3   | \
					 SHOW_HTML_LEFT | SHOW_HTML_CENT | \
					 SHOW_HTML_RGHT | SHOW_HTML_BOLD | \
					 SHOW_HTML_ITAL | SHOW_HTML_ULNE | \
					 SHOW_HTML_TTY  | SHOW_HTML_STRK | \
					 SHOW_HTML_EMPH | SHOW_HTML_STRG | \
					 SHOW_HTML_SUB  | SHOW_HTML_SUP  | \
					 SHOW_HTML_SEP  | SHOW_HTML_PARA | \
					 SHOW_HTML_LBRK | SHOW_HTML_BIG  | \
					 SHOW_HTML_SMLL | SHOW_HTML_ORDR | \
					 SHOW_HTML_UORD | SHOW_HTML_LITM)

#define DEFAULT_HTML_TB_OPT2		0

#define SHOW_HTML_FONT_BIG		(1 << 0)
#define SHOW_HTML_FONT_BOLD		(1 << 1)
#define SHOW_HTML_FONT_EMPH		(1 << 2)
#define SHOW_HTML_FONT_FONTM1		(1 << 3)
#define SHOW_HTML_FONT_FONTP1		(1 << 4)
#define SHOW_HTML_FONT_H1		(1 << 5)
#define SHOW_HTML_FONT_H2		(1 << 6)
#define SHOW_HTML_FONT_H3		(1 << 7)
#define SHOW_HTML_FONT_H4		(1 << 8)
#define SHOW_HTML_FONT_H5		(1 << 9)
#define SHOW_HTML_FONT_H6		(1 << 10)
#define SHOW_HTML_FONT_ITAL		(1 << 11)
#define SHOW_HTML_FONT_PRE		(1 << 12)
#define SHOW_HTML_FONT_SMLL		(1 << 13)
#define SHOW_HTML_FONT_STRG		(1 << 14)
#define SHOW_HTML_FONT_STRK		(1 << 15)
#define SHOW_HTML_FONT_SUB		(1 << 16)
#define SHOW_HTML_FONT_SUP		(1 << 17)
#define SHOW_HTML_FONT_TTY		(1 << 18)
#define SHOW_HTML_FONT_ULNE		(1 << 19)

#define DEFAULT_HTML_FONT_TB_OPT1	(SHOW_HTML_FONT_BIG	| \
					 SHOW_HTML_FONT_BOLD	| \
					 SHOW_HTML_FONT_EMPH	| \
					 SHOW_HTML_FONT_FONTM1	| \
					 SHOW_HTML_FONT_FONTP1	| \
					 SHOW_HTML_FONT_H1	| \
					 SHOW_HTML_FONT_H2	| \
					 SHOW_HTML_FONT_H3	| \
					 SHOW_HTML_FONT_H4	| \
					 SHOW_HTML_FONT_H5	| \
					 SHOW_HTML_FONT_H6	| \
					 SHOW_HTML_FONT_ITAL	| \
					 SHOW_HTML_FONT_PRE	| \
					 SHOW_HTML_FONT_SMLL	| \
					 SHOW_HTML_FONT_STRG	| \
					 SHOW_HTML_FONT_STRK	| \
					 SHOW_HTML_FONT_SUB	| \
					 SHOW_HTML_FONT_SUP	| \
					 SHOW_HTML_FONT_TTY	| \
					 SHOW_HTML_FONT_ULNE)

#define SHOW_HTML_LIST_DEF		(1 << 0)
#define SHOW_HTML_LIST_DLIST		(1 << 1)
#define SHOW_HTML_LIST_DTERM		(1 << 2)
#define SHOW_HTML_LIST_LITM		(1 << 3)
#define SHOW_HTML_LIST_MENU		(1 << 4)
#define SHOW_HTML_LIST_ORDR		(1 << 5)
#define SHOW_HTML_LIST_UORD		(1 << 6)

#define DEFAULT_HTML_LIST_TB_OPT1	(SHOW_HTML_LIST_DEF	| \
					 SHOW_HTML_LIST_DLIST	| \
					 SHOW_HTML_LIST_DTERM	| \
					 SHOW_HTML_LIST_LITM	| \
					 SHOW_HTML_LIST_MENU	| \
					 SHOW_HTML_LIST_ORDR	| \
					 SHOW_HTML_LIST_UORD)

#define SHOW_HTML_TBL_DATA		(1 << 0)
#define SHOW_HTML_TBL_DATA2		(1 << 1)
#define SHOW_HTML_TBL_HDR		(1 << 2)
#define SHOW_HTML_TBL_HDR2		(1 << 3)
#define SHOW_HTML_TBL_NEW		(1 << 4)
#define SHOW_HTML_TBL_NEW2		(1 << 5)
#define SHOW_HTML_TBL_ROW		(1 << 6)
#define SHOW_HTML_TBL_ROW2		(1 << 7)
#define SHOW_HTML_TBL_WIZ		(1 << 8)

#define DEFAULT_HTML_TBL_TB_OPT1	(SHOW_HTML_TBL_DATA	| \
					 SHOW_HTML_TBL_DATA2	| \
					 SHOW_HTML_TBL_HDR	| \
					 SHOW_HTML_TBL_HDR2	| \
					 SHOW_HTML_TBL_NEW	| \
					 SHOW_HTML_TBL_NEW2	| \
					 SHOW_HTML_TBL_ROW	| \
					 SHOW_HTML_TBL_ROW2	| \
					 SHOW_HTML_TBL_WIZ)

#define SHOW_HTML_FORM_BUTTON		(1 << 0)
#define SHOW_HTML_FORM_CHECK		(1 << 1)
#define SHOW_HTML_FORM_IMAGE		(1 << 2)
#define SHOW_HTML_FORM_NEW		(1 << 3)
#define SHOW_HTML_FORM_OPT		(1 << 4)
#define SHOW_HTML_FORM_PASS		(1 << 5)
#define SHOW_HTML_FORM_RADIO		(1 << 6)
#define SHOW_HTML_FORM_RESET		(1 << 7)
#define SHOW_HTML_FORM_SEL		(1 << 8)
#define SHOW_HTML_FORM_SUBMIT		(1 << 9)
#define SHOW_HTML_FORM_TAREA		(1 << 10)
#define SHOW_HTML_FORM_TFIELD		(1 << 11)

#define DEFAULT_HTML_FORM_TB_OPT1	(SHOW_HTML_FORM_BUTTON	| \
					 SHOW_HTML_FORM_CHECK	| \
					 SHOW_HTML_FORM_IMAGE	| \
					 SHOW_HTML_FORM_NEW	| \
					 SHOW_HTML_FORM_OPT	| \
					 SHOW_HTML_FORM_PASS	| \
					 SHOW_HTML_FORM_RADIO	| \
					 SHOW_HTML_FORM_RESET	| \
					 SHOW_HTML_FORM_SEL	| \
					 SHOW_HTML_FORM_SUBMIT	| \
					 SHOW_HTML_FORM_TAREA	| \
					 SHOW_HTML_FORM_TFIELD)

#define SHOW_HTML_FRAME_BASE		(1 << 0)
#define SHOW_HTML_FRAME_NEW		(1 << 1)
#define SHOW_HTML_FRAME_NEW2		(1 << 2)
#define SHOW_HTML_FRAME_NO		(1 << 3)
#define SHOW_HTML_FRAME_SET		(1 << 4)
#define SHOW_HTML_FRAME_SET2		(1 << 5)
#define SHOW_HTML_FRAME_WIZ		(1 << 6)

#define DEFAULT_HTML_FRAME_TB_OPT1	(SHOW_HTML_FRAME_BASE	| \
					 SHOW_HTML_FRAME_NEW	| \
					 SHOW_HTML_FRAME_NEW2	| \
					 SHOW_HTML_FRAME_NO	| \
					 SHOW_HTML_FRAME_SET	| \
					 SHOW_HTML_FRAME_SET2	| \
					 SHOW_HTML_FRAME_WIZ)

/*
 * Pref names.
 */
#define HTML_TB_STR_BIG			"html_tb_big"
#define HTML_TB_STR_BOLD		"html_tb_bold"
#define HTML_TB_STR_CENT		"html_tb_cent"
#define HTML_TB_STR_CMNT		"html_tb_cmnt"
#define HTML_TB_STR_DEF			"html_tb_def"
#define HTML_TB_STR_DLIST		"html_tb_dlist"
#define HTML_TB_STR_DTERM		"html_tb_dterm"
#define HTML_TB_STR_EMPH		"html_tb_emph"
#define HTML_TB_STR_FONTM1		"html_tb_fontm1"
#define HTML_TB_STR_FONTP1		"html_tb_fontp1"
#define HTML_TB_STR_H1			"html_tb_h1"
#define HTML_TB_STR_H2			"html_tb_h2"
#define HTML_TB_STR_H3			"html_tb_h3"
#define HTML_TB_STR_H4			"html_tb_h4"
#define HTML_TB_STR_H5			"html_tb_h5"
#define HTML_TB_STR_H6			"html_tb_h6"
#define HTML_TB_STR_IMG			"html_tb_img"
#define HTML_TB_STR_ITAL		"html_tb_ital"
#define HTML_TB_STR_LBRK		"html_tb_lbrk"
#define HTML_TB_STR_LEFT		"html_tb_left"
#define HTML_TB_STR_LINK		"html_tb_link"
#define HTML_TB_STR_LITM		"html_tb_litm"
#define HTML_TB_STR_MENU		"html_tb_menu"
#define HTML_TB_STR_ORDR		"html_tb_ordr"
#define HTML_TB_STR_PARA		"html_tb_para"
#define HTML_TB_STR_PRE			"html_tb_pre"
#define HTML_TB_STR_RGHT		"html_tb_rght"
#define HTML_TB_STR_SEP			"html_tb_sep"
#define HTML_TB_STR_SMLL		"html_tb_smll"
#define HTML_TB_STR_STRG		"html_tb_strg"
#define HTML_TB_STR_STRK		"html_tb_strk"
#define HTML_TB_STR_SUB			"html_tb_sub"
#define HTML_TB_STR_SUP			"html_tb_sup"
#define HTML_TB_STR_TARG		"html_tb_targ"
#define HTML_TB_STR_TTL			"html_tb_ttl"
#define HTML_TB_STR_TTY			"html_tb_tty"
#define HTML_TB_STR_ULNE		"html_tb_ulne"
#define HTML_TB_STR_UORD		"html_tb_uord"
#define HTML_FONT_TB_STR_H1		"html_font_tb_h1"
#define HTML_FONT_TB_STR_H2		"html_font_tb_h2"
#define HTML_FONT_TB_STR_H3		"html_font_tb_h3"
#define HTML_FONT_TB_STR_H4		"html_font_tb_h4"
#define HTML_FONT_TB_STR_H5		"html_font_tb_h5"
#define HTML_FONT_TB_STR_H6		"html_font_tb_h6"
#define HTML_FONT_TB_STR_BOLD		"html_font_tb_bold"
#define HTML_FONT_TB_STR_ITAL		"html_font_tb_ital"
#define HTML_FONT_TB_STR_ULNE		"html_font_tb_ulne"
#define HTML_FONT_TB_STR_TTY		"html_font_tb_tty"
#define HTML_FONT_TB_STR_STRK		"html_font_tb_strk"
#define HTML_FONT_TB_STR_EMPH		"html_font_tb_emph"
#define HTML_FONT_TB_STR_STRG		"html_font_tb_strg"
#define HTML_FONT_TB_STR_FONTP1		"html_font_tb_fontp1"
#define HTML_FONT_TB_STR_FONTM1		"html_font_tb_fontm1"
#define HTML_FONT_TB_STR_PRE		"html_font_tb_pre"
#define HTML_FONT_TB_STR_SUP		"html_font_tb_sup"
#define HTML_FONT_TB_STR_SUB		"html_font_tb_sub"
#define HTML_FONT_TB_STR_BIG		"html_font_tb_big"
#define HTML_FONT_TB_STR_SMLL		"html_font_tb_smll"
#define HTML_FORM_STR_BUTTON		"html_form_tb_button"
#define HTML_FORM_STR_CHECK		"html_form_tb_check"
#define HTML_FORM_STR_IMAGE		"html_form_tb_image"
#define HTML_FORM_STR_NEW		"html_form_tb_new"
#define HTML_FORM_STR_OPT		"html_form_tb_opt"
#define HTML_FORM_STR_PASS		"html_form_tb_pass"
#define HTML_FORM_STR_RADIO		"html_form_tb_radio"
#define HTML_FORM_STR_RESET		"html_form_tb_reset"
#define HTML_FORM_STR_SEL		"html_form_tb_sel"
#define HTML_FORM_STR_SUBMIT		"html_form_tb_submit"
#define HTML_FORM_STR_TAREA		"html_form_tb_tarea"
#define HTML_FORM_STR_TFIELD		"html_form_tb_tfield"
#define HTML_FRAME_STR_BASE		"html_frame_tb_base"
#define HTML_FRAME_STR_NEW		"html_frame_tb_new"
#define HTML_FRAME_STR_NEW2		"html_frame_tb_new2"
#define HTML_FRAME_STR_NO		"html_frame_tb_no"
#define HTML_FRAME_STR_SET		"html_frame_tb_set"
#define HTML_FRAME_STR_SET2		"html_frame_tb_set2"
#define HTML_FRAME_STR_WIZ		"html_frame_tb_wiz"
#define HTML_LIST_TB_STR_ORDR		"html_list_tb_ordr"
#define HTML_LIST_TB_STR_UORD		"html_list_tb_uord"
#define HTML_LIST_TB_STR_LITM		"html_list_tb_litm"
#define HTML_LIST_TB_STR_DLIST		"html_list_tb_dlist"
#define HTML_LIST_TB_STR_DTERM		"html_list_tb_dterm"
#define HTML_LIST_TB_STR_DEF		"html_list_tb_def"
#define HTML_LIST_TB_STR_MENU		"html_list_tb_menu"
#define HTML_TBL_TB_STR_DATA		"html_tbl_tb_data"
#define HTML_TBL_TB_STR_DATA2		"html_tbl_tb_data2"
#define HTML_TBL_TB_STR_HDR		"html_tbl_tb_hdr"
#define HTML_TBL_TB_STR_HDR2		"html_tbl_tb_hdr2"
#define HTML_TBL_TB_STR_NEW		"html_tbl_tb_new"
#define HTML_TBL_TB_STR_NEW2		"html_tbl_tb_new2"
#define HTML_TBL_TB_STR_ROW		"html_tbl_tb_row"
#define HTML_TBL_TB_STR_ROW2		"html_tbl_tb_row2"
#define HTML_TBL_TB_STR_WIZ		"html_tbl_tb_wiz"
#endif	/* USE_HTMLTAGS */

typedef struct {
	/* bit flag options for various categories */
	long		options1;	/* see above for descriptions */
#ifdef USE_TOOLBARS
	long		main_tb_opt;	/* options for main toolbar */
	long		html_tb_opt1;	/* options for main html toolbar */
	long		html_tb_opt2;	/* options for main html toolbar */
	long		html_font_tb_opt1;	/* options for html font tb */
	long		html_list_tb_opt1;	/* options for html list tb */
	long		html_tbl_tb_opt1;	/* options for html table tb */
	long		html_form_tb_opt1;	/* options for html font tb */
	long		html_frame_tb_opt1;	/* options for html frame tb */
#endif	/* USE_TOOLBARS */

	/* non user configurable */
	char *		appdir;		/* $HOME/PREFS_DIR/ */
	char *		gladerc;	/* $(DATADIR)/gnotepad+.glade */
#ifdef WANT_SESSION
	char *		sessionrc;	/* files open when saving session */
#endif

	/* appearance settings (most are bit-flag settings) */
	GtkPositionType	tabpos;		/* doc tab position */
	guint		tab_stop;	/* tab stop value (default = 8) */

	/* document settings */
	guint		autosave;	/* autosave minutes (0 = disables) */
#ifdef USE_RANDOMTIPS
	guint		random_tips;	/* random tips sec. (0 = disables) */
#endif
#ifdef USE_RECENT
	ubyte		maxrecent;	/* max num of recently opened docs */
#endif	/* USE_RECENT */
#if defined(USE_UNDOREDO) && defined(GTK_HAVE_FEATURES_1_1_0)
	int		maxundo;	/* max undo.  -1 is unlimited */
#endif
	char *		backupdir;	/* backup directory (default = ./) */
	char *		backupsuffix;	/* backup file's suffix (def = ~) */

	/* window settings */
	int		win_height;	/* window height */
	int		win_width;	/* window width */
	int		win_xpos;	/* window xposition */
	int		win_ypos;	/* window yposition */

	/* fonts and colors */
	GdkColor	text_fg_color;	/* GDK-styled text fg color */
	char *		text_fg_str;	/* fg color (rgb string) */
	GdkColor	text_bg_color;	/* GDK-styled text bg color */
	char *		text_bg_str;	/* bg color (rgb string) */
	GdkFont *	text_font;	/* GDK-styled text font */
	char *		text_font_str;	/* text font string */
	GdkColor	text_hlfg_color;/* GDK-styled text highlight fg color */
	char *		text_hlfg_str;	/* highlight fg color (rgb string) */
	GdkColor	text_hlbg_color;/* GDK-styled text highlight bg color */
	char *		text_hlbg_str;	/* highlight bg color (rgb string) */

	/* misc */
	size_t		read_size;	/* size of read buffer */
	char *		printcmd;	/* print cmd. 'lpr' */
	char *		tmpdir;		/* temp directory. '/var/tmp' */
#ifdef WANT_MSGBOX
	guint		msgbox_max_msg;	/* max num of msgs in msg box */
	guint		msgbox_per_del;	/* % of msgs to delete in msg box */
#endif  /* #ifdef WANT_MSGBOX */
#ifdef USE_SHELL_INSERT
	char *		shell;		/* user shell (e.g., /bin/bash) */
#endif	/* USE_SHELL_INSERT */
#ifdef USE_SOURCE_CTRL
	char *		scc[SCC_NUM_TYPES][SCC_NUM_CMDS];
	scc_type_t	scc_selected;	/* which scc the user is using */
#endif	/* USE_SOURCE_CTRL */
#if defined(USE_GTKXMHTML) || defined(USE_GTKHTML)
	int		html_view_w;
	int		html_view_h;
#endif
#ifdef USE_WINLIST
	int		winlist_w;
	int		winlist_h;
#endif
#ifdef WANT_PROJECT
	int		prjlist_w;
	int		prjlist_h;
#endif
#ifdef USE_HTMLTAGS
	int		tagchooser_w;
	int		tagchooser_h;
#endif
} app_prefs_t;

extern app_prefs_t prefs;


extern void	prefs_init(void);
extern void	prefs_save(void);
extern void	prefs_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	prefs_bool_by_name(char *prefname);
extern void	prefs_text_color_update(void);
#ifdef GTK_HAVE_FEATURES_1_1_0
extern void	prefs_update_text_widget_style(GtkWidget *wgt);
#else
# define	prefs_update_text_widget_style(wgt)
#endif


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PREFS_H__ */
