<?xml version="1.0" encoding="UTF-8"?>

<!--  simple XSL transformation to create a docbook section  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                exclude-result-prefixes="dc">
  <xsl:include href="authors_text.xsl" />

  <xsl:output method="xml" indent="yes" />

  <xsl:template match="/dc:gimp-authors">
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
    <!DOCTYPE sect1 PUBLIC "-//OASIS//DTD DocBook XML V4.3//EN"
                "http://www.docbook.org/xml/4.3/docbookx.dtd">
    <!-- do not edit this file directly -->
    <!-- it was generated automatically from authors.xml 
         in the root of gimp-help-2 -->
      ]]>
    </xsl:text>
    <sect1 id="gimp-team" lang="en;es;cs;de;fr;it;ko;nl;no">
      <title>
        <phrase lang="en">GIMP User Manual Authors and Contributors</phrase>
        <phrase lang="cs">
          Autoři a přispěvatelé k uživatelské příručce GIMPu
        </phrase>
        <phrase lang="de">
          Autoren und Mitwirkende des GIMP-Benutzerhandbuches
        </phrase>
        <phrase lang="es">
          Autores y contribuyentes al manual de usuario del GIMP
        </phrase>
        <phrase lang="fr">
          Auteurs et contributeurs du Guide de l'utilisateur Gimp
        </phrase>
        <phrase lang="it">
          Autori e collaboratori del manuale utente di GIMP
        </phrase>
        <phrase lang="ko">김프 사용자 설명서 저자 및 기고자</phrase>
        <phrase lang="nl">
          Schrijvers en medewerkers aan de GIMP Handleiding
        </phrase>
        <phrase lang="no">
          Personane bak <acronym>GIMP</acronym>-handboka
        </phrase>
      </title>
    
      <variablelist>
        <varlistentry>
          <term lang="en">Content Writers</term>
          <term lang="cs">Autoři obsahu</term>
          <term lang="de">Autoren und Mitwirkende</term>
          <term lang="es">Escritores del contenido</term>
          <term lang="fr">Rédacteurs du contenu</term>
          <term lang="it">Autori</term>
          <term lang="ko">본문 저자</term>
          <term lang="nl">Schrijvers en vertalers</term>
          <term lang="no">Forfattarane</term>
          <listitem>
            <para>
              <itemizedlist>
                <xsl:apply-templates select="//dc:creator" />
              </itemizedlist>
            </para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term lang="en">Proof Reading</term>
          <term lang="cs">Korektury</term>
          <term lang="de">Korrekturleser</term>
          <term lang="fr">Relectures</term>
          <term lang="it">Correzione e revisione</term>
          <term lang="ko">교정</term>
          <term lang="nl">Proef lezers</term>
          <term lang="no">Korrekturlesing</term>
          <listitem>
            <para>
              <itemizedlist>
                <xsl:apply-templates select="//dc:contributor[contains(@role, 'documenter')]" />
              </itemizedlist>
            </para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term lang="en">Graphics, Stylesheets</term>
          <term lang="cs">Grafika a styly</term>
          <term lang="de">Grafik, Stylesheets</term>
          <term lang="es">Gráficos, hojas de estilo</term>
          <term lang="fr">Graphismes, Feuilles de Style</term>
          <term lang="it">Grafica e fogli di stile</term>
          <term lang="ko">그래픽스, 스타일쉬트</term>
          <term lang="nl">Afbeeldingen en Stijlbladen</term>
          <term lang="no">Grafikk og stilark</term>

          <listitem>
            <para>
              <itemizedlist>
                <xsl:apply-templates select="//dc:contributor[contains(@role, 'artist')]" />
              </itemizedlist>
            </para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term lang="en">Build System, Technical Contributions</term>
          <term lang="cs">Technické řešení</term>
          <term lang="de">Technische Unterstützung</term>
          <term lang="es">Contribuciones técnicas</term>
          <term lang="fr">Contributions techniques</term>
          <term lang="it">Contributi tecnici</term>
          <term lang="ko">시스템 구축, 기술 지원</term>
          <term lang="nl">Technische Ondersteuning</term>
          <term lang="no">Teknisk støtte</term>

          <listitem>
            <para>
              <itemizedlist>
                <xsl:apply-templates select="//dc:contributor[contains(@role, 'technican')]" />
              </itemizedlist>
            </para>
          </listitem>
        </varlistentry>
      </variablelist>
    </sect1> 
  </xsl:template>

  <!-- two simple transformations -->
  <xsl:template match="//dc:creator | //dc:contributor">
    <xsl:param name="print_language">1</xsl:param>
    <listitem>
      <para>
        <xsl:apply-templates match="." />
        <xsl:if test="@lang != '' and $print_language != 0">
          <xsl:text> (</xsl:text>
          <xsl:call-template name="lang.split">
            <xsl:with-param name="lang" select="@lang" />
          </xsl:call-template>
          <xsl:text>)</xsl:text>
        </xsl:if>
      </para>
    </listitem>
  </xsl:template>
</xsl:stylesheet>
