/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  socket.cc - GtkSocket C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "socket.hh"
#include "private/socketclass.hh"
#include "private/marshal.hh"
#include "../gdk/window.hh"

using namespace GFC;

/*  Gtk::Socket
 */

Gtk::Socket::Socket(GtkSocket *socket, bool owns_reference)
: Container((GtkContainer*)socket, owns_reference)
{
}

Gtk::Socket::Socket()
: Container((GtkContainer*)SocketClass::create())
{
}

Gtk::Socket::~Socket()
{
}

Gdk::Window*
Gtk::Socket::plug_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_socket()->plug_window);
}

Gtk::Widget*
Gtk::Socket::plug_widget() const
{
	return G::Object::wrap<Widget>(gtk_socket()->plug_widget);
}

/*  Gtk::Socket signals
 */

const Gtk::Socket::PlugAddedSignalType Gtk::Socket::plug_added_signal("plug_added", (GCallback)&G::Marshal::void_callback);

const Gtk::Socket::PlugRemovedSignalType Gtk::Socket::plug_removed_signal("plug_removed", (GCallback)&Marshal::bool_callback);

