/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  rangesignals.cc - Gtk::Range virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "range.hh"
#include "rangesignals.hh"
#include "private/rangeclass.hh"

using namespace GFC;

/*  Gtk::RangeSignals
 */

Gtk::RangeSignals::RangeSignals(Range *range)
: WidgetSignals(range)
{
	Gtk::RangeClass::init(GTK_RANGE_GET_CLASS(range->gtk_range()));
}

Gtk::RangeSignals::~RangeSignals()
{
}

void
Gtk::RangeSignals::on_value_changed()
{
	GtkRangeClass *g_class = RangeClass::get_parent_class(instance_);
	if (g_class->value_changed)
		g_class->value_changed((GtkRange*)instance_);
}

void
Gtk::RangeSignals::on_adjust_bounds(double new_value)
{
	GtkRangeClass *g_class = RangeClass::get_parent_class(instance_);
	if (g_class->adjust_bounds)
		g_class->adjust_bounds((GtkRange*)instance_, new_value);
}

/*  Gtk::RangeClass
 */

void
Gtk::RangeClass::init(GtkRangeClass *g_class)
{
	g_class->value_changed = &value_changed_proxy;
	g_class->adjust_bounds = &adjust_bounds_proxy;
}

GtkRangeClass*
Gtk::RangeClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_RANGE_GET_CLASS(instance));
	return static_cast<GtkRangeClass*>(ptr);
}

GType
Gtk::RangeClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RANGE);
	}
	return type;
}

void*
Gtk::RangeClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::RangeClass::value_changed_proxy(GtkRange *range)
{
	void *ptr = g_object_get_qdata((GObject*)range, G::ObjectSignals::quark());
	if (ptr)
		static_cast<RangeSignals*>(ptr)->on_value_changed();
	else
	{
		GtkRangeClass *g_class = RangeClass::get_parent_class(range);
		if (g_class->value_changed)
			g_class->value_changed(range);
	}
}

void
Gtk::RangeClass::adjust_bounds_proxy(GtkRange *range, gdouble new_value)
{
	void *ptr = g_object_get_qdata((GObject*)range, G::ObjectSignals::quark());
	if (ptr)
		static_cast<RangeSignals*>(ptr)->on_adjust_bounds(new_value);
	else
	{
		GtkRangeClass *g_class = RangeClass::get_parent_class(range);
		if (g_class->adjust_bounds)
			g_class->adjust_bounds(range, new_value);
	}
}

