/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  radiobutton.inl - Gtk::RadioButton inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkRadioButton*
GFC::Gtk::RadioButton::gtk_radio_button() const
{
	return reinterpret_cast<GtkRadioButton*>(instance_);
}

inline GFC::Gtk::RadioButton::operator GtkRadioButton* () const
{
	return this ? gtk_radio_button() : 0;
}

inline GFC::Gtk::RadioButton::Group*
GFC::Gtk::RadioButton::get_group() const
{
	return gtk_radio_button_group(gtk_radio_button());
}

inline void
GFC::Gtk::RadioButton::set_group(Group *group)
{
	gtk_radio_button_set_group(gtk_radio_button(), group);
}

inline const GFC::Gtk::RadioButton::GroupChangedSignalProxy 
GFC::Gtk::RadioButton::sig_group_changed()
{
	return GroupChangedSignalProxy(this, &group_changed_signal);
}

