/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  celleditablesignals.cc - Gtk::CellEditable virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "celleditable.hh"
#include "celleditablesignals.hh"
#include "private/celleditableiface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Gtk::CellEditableSignals
 */

Gtk::CellEditableSignals::CellEditableSignals(CellEditable *cell_editable)
{
	Gtk::CellEditableIface::init(GTK_CELL_EDITABLE_GET_IFACE(cell_editable->gtk_cell_editable()));
}
	
Gtk::CellEditableSignals::~CellEditableSignals()
{
}
	
void
Gtk::CellEditableSignals::on_editing_done()
{
	GtkCellEditableIface *g_iface = CellEditableIface::get_parent_iface(instance_);
	if (g_iface->editing_done)
		g_iface->editing_done((GtkCellEditable*)instance_);
}

void
Gtk::CellEditableSignals::on_remove_widget()
{
	GtkCellEditableIface *g_iface = CellEditableIface::get_parent_iface(instance_);
	if (g_iface->remove_widget)
		g_iface->remove_widget((GtkCellEditable*)instance_);
}

/*  Gtk::CellEditableIface
 */

void
Gtk::CellEditableIface::init(GtkCellEditableIface *g_iface)
{
	g_iface->editing_done = &editing_done_proxy;
	g_iface->remove_widget = &remove_widget_proxy;
}

GtkCellEditableIface*
Gtk::CellEditableIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(GTK_CELL_EDITABLE_GET_IFACE(instance));
	return static_cast<GtkCellEditableIface*>(ptr);
}

void
Gtk::CellEditableIface::editing_done_proxy(GtkCellEditable *cell_editable)
{	
	void *ptr = g_object_get_qdata((GObject*)cell_editable, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<CellEditableSignals*>(object)->on_editing_done();
	}
	else
	{
		GtkCellEditableIface *g_iface = CellEditableIface::get_parent_iface(cell_editable);
		if (g_iface->editing_done)
			g_iface->editing_done(cell_editable);
	}
}

void
Gtk::CellEditableIface::remove_widget_proxy(GtkCellEditable *cell_editable)
{
	void *ptr = g_object_get_qdata((GObject*)cell_editable, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<CellEditableSignals*>(object)->on_remove_widget();
	}
	else
	{
		GtkCellEditableIface *g_iface = CellEditableIface::get_parent_iface(cell_editable);
		if (g_iface->remove_widget)
			g_iface->remove_widget(cell_editable);
	}
}

