/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/buttonsignals.hh
/// @brief Gtk::Button virtual signal handlers.
///
/// Provides Gtk::ButtonSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::Button objects.

#ifndef GFC_GTK_BUTTON_SIGNALS_HH
#define GFC_GTK_BUTTON_SIGNALS_HH

#ifndef GFC_GTK_CONTAINER_SIGNALS_HH
#include <gfc/gtk/containersignals.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class ButtonSignals buttonsignals.hh gfc/gtk/buttonsignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::Button.

class ButtonSignals : public ContainerSignals
{
protected:
/// @name Constructors
/// @{

	ButtonSignals(Button *button);
	///< Constructs a new ButtonSignals object.
	///< @param button A Button object inheriting the ButtonSignals implementation.

	virtual ~ButtonSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_pressed();
	///< Called when the button is initially pressed.

	virtual void on_released();
	///< Called when a button which is pressed is released, no matter where the mouse cursor is.

	virtual void on_clicked();
	///< Called when a button clicked on by the mouse and the cursor stays on the button. If the
	///< cursor is not on the button when the mouse button is released, the signal is not emitted.

	virtual void on_enter();
	///< Called when the mouse cursor enters the region of the button.

	virtual void on_leave();
	///< Called when the mouse cursor leaves the region of the button.

	virtual void on_activate();
	///< Called when the button is activated.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_BUTTON_SIGNALS_HH

