/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  text.inl - Atk::Text inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Atk::Attribute
 */

inline AtkAttribute*
GFC::Atk::Attribute::atk_attribute() const
{
	return const_cast<AtkAttribute*>(&attrib_);
}

inline GFC::Atk::TextAttribute
GFC::Atk::Attribute::attr() const
{
	return (TextAttribute)atk_text_attribute_for_name(attrib_.name);
}

/*  Atk::TextRectangle
 */

inline AtkTextRectangle*
GFC::Atk::TextRectangle::atk_text_rectangle() const
{
	return const_cast<AtkTextRectangle*>(&rectangle_);
}

inline GFC::Atk::TextRectangle::operator AtkTextRectangle* () const
{
	return this ? const_cast<AtkTextRectangle*>(&rectangle_) : 0;
}

inline int
GFC::Atk::TextRectangle::x() const
{
	return rectangle_.x;
}

inline int
GFC::Atk::TextRectangle::y() const
{
	return rectangle_.y;
}

inline int
GFC::Atk::TextRectangle::width() const
{
	return rectangle_.width;
}

inline int
GFC::Atk::TextRectangle::height() const
{
	return rectangle_.height;
}

/*  Atk::TextRange
 */

inline AtkTextRange*
GFC::Atk::TextRange::atk_text_rectangle() const
{
	return const_cast<AtkTextRange*>(&range_);
}

inline int
GFC::Atk::TextRange::start_offset() const
{
	return range_.start_offset;
}

inline int
GFC::Atk::TextRange::end_offset() const
{
	return range_.end_offset;
}

inline const char*
GFC::Atk::TextRange::content() const
{
	return range_.content;
}

/*  Atk::Text
 */

inline AtkText*
GFC::Atk::Text::atk_text() const
{
	return reinterpret_cast<AtkText*>(instance_);
}

inline GFC::Atk::Text::operator AtkText* () const
{
	return this ? atk_text() : 0;
}

inline int
GFC::Atk::Text::get_caret_offset() const
{
	return atk_text_get_caret_offset(atk_text());
}

inline void
GFC::Atk::Text::get_character_extents(int offset, int *x, int *y, int *width, int *height, CoordType coords) const
{
	atk_text_get_character_extents(atk_text(), offset, x, y, width, height, (AtkCoordType)coords);
}

inline int
GFC::Atk::Text::get_character_count() const
{
	return atk_text_get_character_count(atk_text());
}

inline int
GFC::Atk::Text::get_offset_at_point(int x, int y, CoordType coords) const
{
	return atk_text_get_offset_at_point(atk_text(), x, y, (AtkCoordType)coords);
}

inline int
GFC::Atk::Text::get_n_selections() const
{
	return atk_text_get_n_selections(atk_text());
}

inline bool
GFC::Atk::Text::add_selection(int start_offset, int end_offset)
{
	return atk_text_add_selection(atk_text(), start_offset, end_offset);
}

inline bool
GFC::Atk::Text::remove_selection(int selection_num)
{
	return atk_text_remove_selection(atk_text(), selection_num);
}

inline bool
GFC::Atk::Text::set_selection(int selection_num, int start_offset, int end_offset)
{
	return atk_text_set_selection(atk_text(), selection_num, start_offset, end_offset);
}

inline bool
GFC::Atk::Text::set_caret_offset(int offset)
{
	return atk_text_set_caret_offset(atk_text(), offset);
}

inline const GFC::Atk::Text::TextChangedSignalProxy
GFC::Atk::Text::sig_text_changed()
{
	return TextChangedSignalProxy(this, &text_changed_signal);
}

inline const GFC::Atk::Text::TextCaretMovedSignalProxy
GFC::Atk::Text::sig_text_caret_moved()
{
	return TextCaretMovedSignalProxy(this, &text_caret_moved_signal);
}

inline const GFC::Atk::Text::TextSelectionChangedSignalProxy
GFC::Atk::Text::sig_text_selection_changed()
{
	return TextSelectionChangedSignalProxy(this, &text_selection_changed_signal);
}

inline const GFC::Atk::Text::TextAttributesChangedSignalProxy
GFC::Atk::Text::sig_text_attributes_changed()
{
	return TextAttributesChangedSignalProxy(this, &text_attributes_changed_signal);
}

