/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/atk/atk.hh
/// @brief Main Atk header file
///
/// This header file includes all the Atk header files. You can safely include
/// this header file only, with minimal extra overhead, because each header file
/// uses include guards to prevent multiple inclusions.

#ifndef GFC_ATK_HH
#define GFC_ATK_HH

#include <gfc/atk/component.hh>
#include <gfc/atk/document.hh>
#include <gfc/atk/editabletext.hh>
#include <gfc/atk/gobjectaccessible.hh>
#include <gfc/atk/hyperlink.hh>
#include <gfc/atk/hypertext.hh>
#include <gfc/atk/image.hh>
#include <gfc/atk/implementor.hh>
#include <gfc/atk/object.hh>
#include <gfc/atk/objectfactory.hh>
#include <gfc/atk/registry.hh>
#include <gfc/atk/relation.hh>
#include <gfc/atk/selection.hh>
#include <gfc/atk/stateset.hh>
#include <gfc/atk/streamablecontent.hh>
#include <gfc/atk/table.hh>
#include <gfc/atk/text.hh>
#include <gfc/atk/value.hh>

#endif // GFC_ATK_HH


