#include "rulers.hh"
#include <gfc/gtk/box.hh>
#include <gfc/gtk/drawingarea.hh>
#include <gfc/gtk/table.hh>
#include <gfc/gtk/private/widgetclass.hh>

GtkWidgetClass*
get_parent_class(void *instance)
{
//	void *ptr = g_type_class_peek_parent(GTK_WIDGET_GET_CLASS(instance));
	void *ptr = GTK_WIDGET_GET_CLASS(instance);
	return static_cast<GtkWidgetClass*>(ptr);
}

RulerWindow::RulerWindow()
{
	set_border_width(10);

	// Create a table for placing the ruler and the drawing area
	Gtk::Table *table = new Gtk::Table(3, 2);
	add(*table);

	Gtk::DrawingArea *area = new Gtk::DrawingArea(600, 400);
	table->attach(*area, 1, 2, 1, 2, Gtk::EXPAND | Gtk::FILL, Gtk::FILL);
	area->set_events(GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK);

	// The horizontal ruler goes on top. As the mouse moves across the drawing area,
	// a motion_notify_event is passed to the appropriate event handler for the ruler.
	Gtk::HRuler *hruler = new Gtk::HRuler;
	hruler->set_metric(Gtk::PIXELS);
	hruler->set_range(7, 13, 0, 20);
	GCallback callback = GCallback(get_parent_class(hruler->gtk_widget())->motion_notify_event);
	g_signal_connect_swapped(area->g_object(), "motion_notify_event", callback, hruler->gtk_widget());
	table->attach(*hruler, 1, 2, 0, 1, Gtk::EXPAND | Gtk::SHRINK | Gtk::FILL, Gtk::FILL);

	// The vertical ruler goes on the left. As the mouse moves across the drawing area,
	// a motion_notify_event is passed to the appropriate event handler for the ruler.
	Gtk::VRuler *vruler = new Gtk::VRuler;
	vruler->set_metric(Gtk::PIXELS);
	vruler->set_range(0, 400, 10, 400);
	callback = GCallback(get_parent_class(vruler->gtk_widget())->motion_notify_event);
	g_signal_connect_swapped(area->g_object(), "motion_notify_event", callback, vruler->gtk_widget());
	table->attach(*vruler, 0, 1, 1, 2, Gtk::FILL, Gtk::EXPAND | Gtk::SHRINK | Gtk::FILL);

	// Now show everything
	show_all();
}

RulerWindow::~RulerWindow()
{
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	RulerWindow window;
	window.sig_destroy().connect(sigc::ptr_fun(&GFC::Main::quit));

	run();
	return 0;
}

