% FUNCTION I = gf_fem_get(F, ...)
%     General function for querying information about FEM objects.
% 
%   * n = gf_fem_get(fe,'nbdof'[, int cv])
%   Return the number of dof for the Fem.  Some specific Fem (for example
%   'interpolated_fem') may require a convex number `cv` to give their result. In
%   most of the case, you can omit this convex number.
% 
%   * d = gf_fem_get(fe,'dim')
%   Return the dimension (dimension of the reference convex) of the Fem.
% 
%   * td = gf_fem_get(fe,'target_dim')
%   Return the dimension of the target space.  The target space dimension is
%   usually 1, except for vector Fem (none of them has been implemented in
%   getfem++ for now).
% 
%   * P = gf_fem_get(fe,'pts'[, int cv])
%   Get the location of the dof on the reference element.  Some specific Fem may
%   require a convex number `cv` to give their result (for example
%   'interpolated_fem'). In most of the case, you can omit this convex number.
% 
%   * b = gf_fem_get(fe,'is_equivalent')
%   Return 0 if the Fem is not equivalent.  Equivalent Fem are evaluated on the
%   reference convex. This is the case of most classical Fem's.
% 
%   * b = gf_fem_get(fe,'is_lagrange')
%   Return 0 if the Fem is not of Lagrange type.
% 
%   * b = gf_fem_get(fe,'is_polynomial')
%   Return 0 if the basis functions are not polynomials.
% 
%   * d = gf_fem_get(fe,'estimated_degree')
%   Return an estimation of the polynomial degree of the Fem.  This is an
%   estimation for fem which are not polynomials.
% 
%   * E = gf_fem_get(fe,'base_value',mat p)
%   Evaluate all basis functions of the FEM at point `p`.  `p` is supposed to be
%   in the reference convex!
% 
%   * ED = gf_fem_get(fe,'grad_base_value',mat p)
%   Evaluate the gradient of all base functions of the Fem at point `p`.  `p` is
%   supposed to be in the reference convex!
% 
%   * EH = gf_fem_get(fe,'hess_base_value',mat p)
%   Evaluate the Hessian of all base functions of the Fem at point `p`.  `p` is
%   supposed to be in the reference convex!.
% 
%   * gf_fem_get(fe,'poly_str')
%   Return the polynomial expressions of its basis functions in the reference
%   convex.  The result is expressed as a cell array of strings. Of course this
%   will fail on non-polynomial Fem's.
% 
%   * string = gf_fem_get(fe,'char')
%   Ouput a (unique) string representation of the Fem.  This can be used to
%   perform comparisons between two different Fem objects.
% 
function [varargout]=gf_fem_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('fem_get',varargin{:});
  else
    gf_matlab('fem_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
