//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/

/******************************************************************
      Stuff for connecting groups
******************************************************************/
// note that libs cannot be dragged onto groups yet.

function ungroup(thing)
	str thing

	str nm = {getpath {el {thing} } -tail}
	str newicon

	if ({exists /kinetics/{nm}})
		do_warning 0 "Warning: cannot ungroup "{thing}": name conflict"
		return(0)
	end
	setfield {thing} xtree_textfg_req {getfield /kinetics xtree_fg_req}
	move {thing} /kinetics/{nm}
	call /edit/draw/tree RESET
	return(1)
end

// This is called by the group when something is dropped onto it
function thing_to_group_add(thing,group)
	str thing,group

	str srcpa, newicon

	// Check that the thing can be put onto a group
	if ({strcmp {getfield {thing} "manageclass"} "group"} != 0)
		do_warning 0 "Warning: Element '"{src}"' cannot be moved onto a group"
		return
	end

	// Check that the src is not already grouped to self
	if ({strcmp {group} {el {thing}/.. }} == 0)
		// we might want to do an ungroup here
		ungroup {thing}
		return 
	end

	// Check that the src isnt named the same as an existing elm
	if ({exists {group}/{getpath {thing} -tail }})
		do_warning 0 "cannot move "{thing}" onto existing element of same name"
		return
	end


	// Set the new textcolor of the thing
	setfield {thing} xtree_textfg_req {getfield {group} xtree_fg_req }

	// Move the thing into the group
	move {thing} {group}

	// update the display
	call /edit/draw/tree RESET

	// we need to update the edit info here 
end


/******************************************************************
      Stuff for editing group
******************************************************************/

function do_update_groupinfo
	str group = {getfield /parmedit/group elmpath}

	setfield /parmedit/group/path value {getpath {group} -head}
	setfield /parmedit/group/name value {getpath {group} -tail}
	setfield /parmedit/group/notes initialtext {getfield {group} notes}
	setfield /parmedit/group/color value {getfield {group} xtree_fg_req}
	setfield /parmedit/group/expand state {getfield {group} expanded}
	setfield /parmedit/group/movekids state {getfield {group} movealone}
end

function make_xedit_group
	create xform /parmedit/group  [{EX},{EY},{EW},360]
	addfield /parmedit/group elmpath \
		-description "path of elm being edited"
	ce /parmedit/group
	create xdialog path -wgeom 60% -title "Parent"
	create xdialog name -xgeom 60% -wgeom 40% -ygeom 0 -title "Name" \
		-script "set_item_name <w> <v>"
	create xtoggle expand
		setfield expand \
		onlabel "Contracted : click to expand" \
		offlabel "Expanded : click to contract" \
		script "toggle_group_visibility <v>"
	create xtoggle movekids
		setfield movekids \
		onlabel "Move group alone" \
		offlabel "Move children of group along with it" \
		script "toggle_group_movekids <v>"
	create xbutton reinit \
		-label "Initialize all children to current amounts" \
		-script "do_reinit"

	create xdialog save_group -script "do_save_group <v>"
	create xdialog color -script "set_item_color <w> <v>"
	create xbutton savenotes -label NOTES [0,0:last,10%,130] \
		-script "save_item_notes <w>" -offbg gray
	create xtext notes [0:last,0:color,90%,130] -editable 1
	create xbutton UPDATE [0%,0:notes,50%,30] \
		-script do_update_groupinfo
	create xbutton HIDE [50%,0:notes,50%,30] \
		-script "save_item_notes <w>; xhide /parmedit/group"
	ce /
end

/* Stuff for group visibility
** This may become generic stuff */

function toggle_group_visibility(state)
	int state
	str group = {getfield /parmedit/group elmpath}

	call /edit/draw/tree TRUNCATE {group} {state}
	setfield {group} expanded {state}
end

function toggle_group_movekids(state)
	int state
	str group = {getfield /parmedit/group elmpath}

	setfield {group} movealone {state}
end

function edit_group(group)
	str group

	setfield /parmedit/group elmpath {group}
	do_update_groupinfo
	xshowontop /parmedit/group
end

function do_save_group(destfile)
	str destfile
	str group = {getfield /parmedit/group elmpath}
	// assume for now we do not have multiple nesting of groups
	// We save all the base-level elms on kinetics for now, so
	// as to easily manage interactions.
	save_sim {destfile} {group}
end

function do_reinit
	str group = {getfield /parmedit/group elmpath}
	str pool
	str enz

	foreach  pool ({el {group}/#[TYPE=kpool]})
		setfield {pool} CoInit {getfield {pool} Co}
		setfield {pool} nInit {getfield {pool} n} 
	end

	foreach  enz ({el {group}/#[]/#[TYPE=kenz]})
		setfield {enz} CoComplexInit {getfield {enz} CoComplex}
		setfield {enz} nComplexInit {getfield {enz} nComplex} 
	end
end

/******************************************************************
      Stuff for graphing groups
******************************************************************/

// This could be interesting. We might wish to have a field in the
// group editor which allows one to specify which of the groupies
// gets displayed. For now, display the faithful old x coord

/******************************************************************
      Stuff for initializing groups
******************************************************************/

function xgroupproto
	ce /control/lib/tree
	create xshape shape -autoindex \
		-drawmode DrawLines \
		-fg yellow \
		-coords [0,2,0][1,-1.7,0][-1.4,1.4,0][2,0,0][-2,0,0] \
			[1.4,1.4,0][-1,-1.7,0][0,2,0] \
		-linewidth 3 \
		-value "group" \
		-text "group" \
		-pixflags v \
		-pixflags c \
		-textcolor "black" \
		-script \
		"edit_group.D"
	
	copy {el ^} /edit/draw/tree -autoindex
	setfield ^ script "edit_group.D"
end

function kgroupproto
	create neutral /group
    addfield /group notes -description "string for group notes and refs"
    addfield /group editfunc -description "func for group edit"
    addfield /group xtree_fg_req -description "color for group icon"
    addfield /group xtree_textfg_req -description "text color for group icon"
    addfield /group plotfield -description "field to plot"
    addfield /group manageclass -description "Class that can manage it"
    addfield /group expanded -description "Flag for expansion of group"
    addfield /group movealone -description "Flag moving group without kids"

	addobject group /group \
        -author "Upi Bhalla Mt Sinai March 1994" \
        -description "group plus a notes field"
    setdefault group editfunc "edit_group"
    setdefault group xtree_fg_req "yellow"
    setdefault group xtree_textfg_req "black"
    setdefault group plotfield "x"
    setdefault group manageclass "group"
    setdefault group expanded 0
    setdefault group movealone 0
    ce /
end


function init_xgroup
    // set up the prototype group
    kgroupproto
	// change /kinetics to a group
	if ({exists /kinetics})
		delete /kinetics
	end
	create group /kinetics

	if (DO_X)
    	xgroupproto

		// set up the calls to handle dragging things into a group
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[]" \
			"/kinetics/##[TYPE=group]" all all none -1 0 \
	"echo.p dragging <S> onto group <D>; thing_to_group_add.p <S> <D>" \
			"" ""
	
		// make group editor
		make_xedit_group
	end
end

/******************************************************************/
