////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// zmoelnig@iem.kug.ac.at
//
// Implementation file
//
//    Copyright (c) 1997-1999 Mark Danks.
//    Copyright (c) Gnther Geiger.
//    Copyright (c) 2001-2003 IOhannes m zmoelnig. forum::fr::umlute. IEM
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "textextruded.h"

#ifdef FTGL
#include "FTGLExtrdFont.h"
#endif

CPPEXTERN_NEW_WITH_GIMME(textextruded)

/////////////////////////////////////////////////////////
//
// textextruded
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
#ifdef FTGL
textextruded :: textextruded(int argc, t_atom *argv)
  : TextBase(argc, argv) {
  fontNameMess(DEFAULT_FONT);
} 
textextruded :: ~textextruded() {
  if(m_font)delete m_font;m_font=NULL;
}
FTFont *textextruded :: makeFont(const char*fontfile){
  if(m_font)delete m_font; m_font=NULL;
  m_font =  new FTGLExtrdFont(fontfile);
  if (m_font->Error()){
    delete m_font;
    m_font = NULL;
  }
  return m_font;
}

/////////////////////////////////////////////////////////
// setPrecision
//
/////////////////////////////////////////////////////////
void textextruded :: setDepth(float prec)
{
  m_fontDepth = prec;
  if(!m_font)return;
  m_font->Depth((int)m_fontDepth);
  setFontSize();
  setModified();
}
#else

textextruded :: textextruded(int argc, t_atom *argv)
  : TextBase(argc, argv)
{
  error("FTGL-support is needed for extruded fonts!");
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
textextruded :: ~textextruded()
{}

/////////////////////////////////////////////////////////
// setPrecision
//
/////////////////////////////////////////////////////////
void textextruded :: setDepth(float prec)
{}
#endif /* !GLTT && !FTGL */

/////////////////////////////////////////////////////////
// static member function
//
/////////////////////////////////////////////////////////
void textextruded :: obj_setupCallback(t_class *classPtr)
{
  class_addmethod(classPtr, (t_method)&textextruded::depthMessCallback,
		  gensym("depth"), A_FLOAT, A_NULL);  
}
void textextruded :: depthMessCallback(void *data, t_floatarg depth)
{
  GetMyClass(data)->setDepth((float)depth);
}
