import socket
from string import *
from time import *

class ImondConnectionError(Exception):
	def __init__(self, message):
		self.err = message

class ImondConnection:

	def __init__(self, hostname = "fli4l", port = 5000, pw = ""):
		self._hostname = hostname
		self._port = port
		self._pw = pw

	def connect(self):
		self._s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		try:
			self._s.connect((self._hostname,self._port))
			answer = int(self._send_command("pass"))
			if (answer == 1 or answer == 3):
				answer = self._send_command("pass " + self._pw)  
			if (answer== "ERR"):
				raise ImondConnectionError("Missing or wrong password")
			self._pppoe = self._send_command("pppoe")
			self._imond_version = split(self._send_command("version"))[0]
		except:
			self._s = None
			raise ImondConnectionError("Connection failed")

	def connected(self):
			return (self._s != None)

	def disconnect(self):
		if (self.connected() == False):
			return
		self._send_command("quit")
		self._s.close()
		self._connected = False

	# host specific data
	def get_hostname(self):
		return self._send_command("hostname")

	def get_version(self):
		return self._send_command("version")

	def get_fli4l_version(self):
		answer = self._send_command("version")
		if (answer != None): return split(answer)[1]
		else: return None

	def get_imond_version(self):
		answer = self._send_command("version")
		if (answer != None): return int(split(answer)[0])
		else: return None

	def get_uptime(self):
		answer = self._send_command("uptime")
		if (answer != None): return int(answer)
		else: return None

	def get_date(self):
		return self._send_command("date");

	def get_cpu(self):
		return self._send_command("cpu")

	# circuit data
	def get_phone(self, device = "pppoe"):
		return self._send_command("phone " + device)

	def get_status(self, device = "pppoe"):
		return self._send_command("status " + device)

	def get_ip(self, device = "pppoe"):
		return self._send_command("ip " + device)

	def get_inout(self, device = "pppoe"):
		return self._send_command("inout " + device)

	def get_rate(self, device = "pppoe"):
		answer = split(self._send_command("rate " + device))
		if (answer[0] == "ERR"):
			return None
		answer[0] = int(answer[0])
		answer[1] = int(answer[1])
		return answer

	def get_quantity(self, device = "pppoe"):
		answer = self._send_command("quantity " + device)
		if (answer == None):
			return None
		answer = split(answer)
		for i in range(len(answer)):
			answer[i] = int(answer[i])
		return answer

	def get_online_time(self, device = "pppoe"):
		return self._send_command("online-time " + device)

	def get_time(self, device = "pppoe"):
		return self._send_command("time " + device)

	def get_charge_time(self, device = "pppoe"):
		return self._send_command("chargetime " + device)

	def get_charge(self, device = "pppoe"):
		return self._send_command("charge " + device)

	# lowlevel intercom
	def _send_command(self, str):
		if (self.connected() != True):
			return None
		if (str == "" or str == None):
			return None
		self._s.send(str+"\r\n")
		answer = strip(self._s.recv(1024))
		if (answer != "ERR"):
			answer = replace(answer, "OK ", "") # throw away trailing "OK "
		return answer
