#
# Rhythmlet - gDesklets sensor for Rhythmbox
# Copyright (c) 2004 Alex Revo
# ----------------------------------------------------------------------
#  Rhythmbox.py - Interface to Rhythmbox
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
########################################################################


# Import the required (system) modules.
import os
import types
#  * Bonobo stuff:
import CORBA
import pygtk
pygtk.require('2.0')
import bonobo

# Import Rhythmlet-specific modules.
import RLBase



class Rhythmbox(RLBase.RLBase):
#-----------------------------------------------------------------------
	def __init__(self, *args):
	#-------------------------------------------------------------------
		"""Rhythmbox class constructor"""

		# Initialise base class.
		RLBase.RLBase.__init__(self)

		self.dPrint("Rhythmbox class instantiated.")

		# Initialise variables.
		self._rhythmbox = types.NoneType
		self._rbProps	= types.NoneType
		self._rbSong	= types.NoneType

		# Refresh data immediately.
		self.refresh()
	#-------------------------------------------------------------------


	def refresh(self):
	#-------------------------------------------------------------------
		"""Update information from Rhythmbox."""

		try:
			if (self.isActive()):
				self._rhythmbox = bonobo.activation.activate_from_id("OAFIID:GNOME_Rhythmbox", 0, None)

				if (type(self._rhythmbox) != types.NoneType):
					self._rbProps = self._rhythmbox.getPlayerProperties()

					if (type(self._rbProps) != types.NoneType):
						self._rbSong = self._rbProps.getValue("song").value()
						return(1)
					# end if
				# end if
			# end if
		except Exception, error:
			self.handleException("Rhythmbox::refesh()", error)
			pass

		return(0)
	#-------------------------------------------------------------------


	def isActive(self):
	#-------------------------------------------------------------------
		"""Return 1 if Rhythmbox is active, 0 otherwise."""

		try:
			if ((bonobo.activation.query("(repo_ids.has('IDL:GNOME/Rhythmbox:1.0')) AND (_active == TRUE)"))):
				return(1)
			# end if
		except Exception, error:
			self.handleException("Rhythmbox::isActive()", error)
			pass
		# end try

		return(0)
	#-------------------------------------------------------------------


	def hasSongInfo(self):
	#-------------------------------------------------------------------
		"""Return 1 if Rhythmbox has SongInfo struct available, 0 otherwise."""

		try:
			if (self.isActive()):
				if (type(self._rbSong) != types.NoneType):
					return(1)
				# end if
			# end if
		except Exception, error:
			self.handleException("Rhythmbox::hasSongInfo()", error)
			pass
		# end try

		return(0)
	#-------------------------------------------------------------------


	def unfuckBonobo(self):
	#-------------------------------------------------------------------
		os.system("bonobo-activation-run-query \"(repo_ids.has('IDL:GNOME/Rhythmbox:1.0')) AND (_active == TRUE)\" >/dev/null 2>&1")
	#-------------------------------------------------------------------


	#
	# RHYTHMBOX ACTIONS:
	#===================================================================
	def handleFile(self, file):
	#-------------------------------------------------------------------
		if (not self.isActive()):
			return(0)

		try:
			self._rhythmbox.handleFile(file)
		except Exception, error:
			self.handleException("Rhythmbox::handleFile()", error)
	#-------------------------------------------------------------------

	def nextTrack(self):
	#-------------------------------------------------------------------
		if (not self.isActive()):
			return(0)

		try:
			self._rhythmbox.next()
		except Exception, error:
			self.handleException("Rhythmbox::nextTrack()", error)
	#-------------------------------------------------------------------

	def playPause(self):
	#-------------------------------------------------------------------
		if (not self.isActive()):
			return(0)

		try:
			self._rhythmbox.playPause()
		except Exception, error:
			self.handleException("Rhythmbox::playPause()", error)
	#-------------------------------------------------------------------

	def previousTrack(self):
	#-------------------------------------------------------------------
		if (not self.isActive()):
			return(0)

		try:
			self._rhythmbox.previous()
		except Exception, error:
			self.handleException("Rhythmbox::previousTrack()", error)
	#-------------------------------------------------------------------
	#===================================================================


	#
	# SPECIAL METHODS:
	#===================================================================
	def __getitem__(self, key):
	#-------------------------------------------------------------------
		"""Return data relating to Rhythmbox."""

		#
		# TODO: make failure return value 0 if result should be int,
		#   "" if result is expected as string.
		#

		# Return immediately if Rhythmbox is not running.
		if (not self.isActive()):
			return("")

		# (see corba/Rhythmbox.idl from Rhythmbox source directory)

		if (self.hasSongInfo()):
			# Rhythmbox:
			if (key == "playingTime"):	return(self._rhythmbox.getPlayingTime())

			# Rhythmbox::SongInfo:
			if (key == "title"):		return(self._rbSong.title)
			if (key == "artist"):		return(self._rbSong.artist)
			if (key == "genre"):		return(self._rbSong.genre)
			if (key == "album"):		return(self._rbSong.album)
			if (key == "path"):			return(self._rbSong.path)
			if (key == "track_number"):	return(self._rbSong.track_number)
			if (key == "duration"):		return(self._rbSong.duration)
			if (key == "bitrate"):		return(self._rbSong.bitrate)
			if (key == "filesize"):		return(self._rbSong.filesize)
			if (key == "rating"):		return(self._rbSong.rating)
			if (key == "play_count"):	return(self._rbSong.play_count)
			if (key == "last_played"):	return(self._rbSong.last_played)
		# end if

		# Rhythmbox::getPlayerProperties:
		if (key == "repeat"):		return(self._rbProps.getValue("repeat").value())
		if (key == "shuffle"):		return(self._rbProps.getValue("shuffle").value())
		if (key == "play-order"):	return(self._rbProps.getValue("play-order").value())
		if (key == "playing"):		return(self._rbProps.getValue("playing").value())

		# everything else, return "".
		return("")
	#-------------------------------------------------------------------


	def __setitem__(self, key, item):
	#-------------------------------------------------------------------
		"""Set data relating to Rhythmbox."""

		# Return immediately if Rhythmbox is not running.
		if (not self.isActive()):
			return(0)

		# (see corba/Rhythmbox.idl from Rhythmbox source directory)

		if (self.hasSongInfo()):
			if (key == "playingTime"):
				try:
					self._rhythmbox.setPlayingTime(item)
					return(item)
				except Exception, error:
					self.handleException("Rhythmbox::__setitem__(playingTime)", error)
				# end try
			# end if

			if (key == "rating"):
				try:
					if (item > 5):
						item = 5
					if (item < 0):
						item = 0

					self._rhythmbox.setRating(item)
				except Exception, error:
					self.handleException("Rhythmbox::__setitem__(rating)", error)
				# end try
			# end if
		# end if

		if (key == "repeat"):
			try:
				if (item):
					newval = CORBA.Any(CORBA.TypeCode("IDL:omg.org/CORBA/boolean:1.0"), CORBA.TRUE)
				else:
					newval = CORBA.Any(CORBA.TypeCode("IDL:omg.org/CORBA/boolean:1.0"), CORBA.FALSE)
				# end if

				self._rbProps.setValue("repeat", newval)
				return(self._rbProps.getValue("repeat").value())
			except Exception, error:
				self.handleException("Rhythmbox::__setitem__(repeat)", error)
			# end try
		# end if

		if (key == "shuffle"):
			try:
				if (item):
					newval = CORBA.Any(CORBA.TypeCode("IDL:omg.org/CORBA/boolean:1.0"), CORBA.TRUE)
				else:
					newval = CORBA.Any(CORBA.TypeCode("IDL:omg.org/CORBA/boolean:1.0"), CORBA.FALSE)
				# end if

				self._rbProps.setValue("shuffle", newval)
				return(self._rbProps.getValue("shuffle").value())
			except Exception, error:
				self.handleException("Rhythmbox::__setitem__(shuffle)", error)
			# end try
		# end if
	#-------------------------------------------------------------------
	#===================================================================
#-----------------------------------------------------------------------
