## mysql
# A_GalleryAccessMap_1.0
ALTER TABLE DB_TABLE_PREFIXAccessMap
  DROP INDEX DB_COLUMN_PREFIXaccessListId,
  ADD COLUMN DB_COLUMN_PREFIXuserOrGroupId int(11) NOT NULL DEFAULT '0';

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryAccessMap_1.1
ALTER TABLE DB_TABLE_PREFIXAccessMap
  DROP COLUMN DB_COLUMN_PREFIXuserId,
  DROP COLUMN DB_COLUMN_PREFIXgroupId,
  ADD PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId),
  ADD INDEX DB_TABLE_PREFIXAccessMap_48775(DB_COLUMN_PREFIXuserOrGroupId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryAccessMap_1.2
ALTER TABLE DB_TABLE_PREFIXAccessMap
  ADD INDEX DB_TABLE_PREFIXAccessMap_83732(DB_COLUMN_PREFIXaccessListId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryAlbumItem_1.0
ALTER TABLE DB_TABLE_PREFIXAlbumItem
  DROP COLUMN DB_COLUMN_PREFIXlayout;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AlbumItem' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryDerivative_1.0
ALTER TABLE DB_TABLE_PREFIXDerivative
  ADD COLUMN DB_COLUMN_PREFIXisBroken int(1);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Derivative' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.0
ALTER TABLE DB_TABLE_PREFIXEntity
  ADD COLUMN DB_COLUMN_PREFIXonLoadHandlers varchar(128);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.1
ALTER TABLE DB_TABLE_PREFIXEntity
  ADD INDEX DB_TABLE_PREFIXEntity_44738(DB_COLUMN_PREFIXlinkId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryGroup_1.0
ALTER TABLE DB_TABLE_PREFIXGroup
  MODIFY COLUMN DB_COLUMN_PREFIXgroupName varchar(128);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Group' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryItem_1.0
ALTER TABLE DB_TABLE_PREFIXItem
  ADD COLUMN DB_COLUMN_PREFIXoriginationTimestamp int(11);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Item' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginMap
  MODIFY COLUMN DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,
  MODIFY COLUMN DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap
  MODIFY COLUMN DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,
  MODIFY COLUMN DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.1
UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryPluginParameterMap_1.2
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap
  MODIFY COLUMN DB_COLUMN_PREFIXparameterValue text NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryUser_1.0
ALTER TABLE DB_TABLE_PREFIXUser
  MODIFY COLUMN DB_COLUMN_PREFIXemail varchar(255);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='User' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# ExternalIdMap
CREATE TABLE DB_TABLE_PREFIXExternalIdMap(
 DB_COLUMN_PREFIXexternalId varchar(128) NOT NULL,
 DB_COLUMN_PREFIXentityType varchar(32) NOT NULL,
 DB_COLUMN_PREFIXentityId int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXexternalId, DB_COLUMN_PREFIXentityType)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ExternalIdMap', 1, 0);

# GalleryAccessMap
CREATE TABLE DB_TABLE_PREFIXAccessMap(
 DB_COLUMN_PREFIXaccessListId int(11) NOT NULL,
 DB_COLUMN_PREFIXuserOrGroupId int(11) NOT NULL,
 DB_COLUMN_PREFIXpermission int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId),
 INDEX DB_TABLE_PREFIXAccessMap_83732(DB_COLUMN_PREFIXaccessListId),
 INDEX DB_TABLE_PREFIXAccessMap_48775(DB_COLUMN_PREFIXuserOrGroupId),
 INDEX DB_TABLE_PREFIXAccessMap_18058(DB_COLUMN_PREFIXpermission)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessMap', 1, 3);

# GalleryAccessSubscriberMap
CREATE TABLE DB_TABLE_PREFIXAccessSubscriberMap(
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXaccessListId int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXitemId),
 INDEX DB_TABLE_PREFIXAccessSubscriberMap_83732(DB_COLUMN_PREFIXaccessListId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessSubscriberMap', 1, 0);

# GalleryAlbumItem
CREATE TABLE DB_TABLE_PREFIXAlbumItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXtheme varchar(32),
 DB_COLUMN_PREFIXorderBy varchar(128),
 DB_COLUMN_PREFIXorderDirection varchar(32),
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AlbumItem', 1, 1);

# GalleryAnimationItem
CREATE TABLE DB_TABLE_PREFIXAnimationItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXwidth int(11),
 DB_COLUMN_PREFIXheight int(11),
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AnimationItem', 1, 0);

# GalleryCacheMap
CREATE TABLE DB_TABLE_PREFIXCacheMap(
 DB_COLUMN_PREFIXkey varchar(32) NOT NULL,
 DB_COLUMN_PREFIXvalue longtext,
 DB_COLUMN_PREFIXuserId int(11) NOT NULL,
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXtype varchar(32) NOT NULL,
 DB_COLUMN_PREFIXtimestamp int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXkey, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXtype),
 INDEX DB_TABLE_PREFIXCacheMap_69068(DB_COLUMN_PREFIXuserId),
 INDEX DB_TABLE_PREFIXCacheMap_75985(DB_COLUMN_PREFIXitemId),
 INDEX DB_TABLE_PREFIXCacheMap_81545(DB_COLUMN_PREFIXtype),
 INDEX DB_TABLE_PREFIXCacheMap_24286(DB_COLUMN_PREFIXtimestamp)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('CacheMap', 1, 0);

# GalleryChildEntity
CREATE TABLE DB_TABLE_PREFIXChildEntity(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXparentId int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 INDEX DB_TABLE_PREFIXChildEntity_52718(DB_COLUMN_PREFIXparentId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ChildEntity', 1, 0);

# GalleryDataItem
CREATE TABLE DB_TABLE_PREFIXDataItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXmimeType varchar(128),
 DB_COLUMN_PREFIXsize int(11),
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DataItem', 1, 0);

# GalleryDerivative
CREATE TABLE DB_TABLE_PREFIXDerivative(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXderivativeSourceId int(11) NOT NULL,
 DB_COLUMN_PREFIXderivativeOperations varchar(255),
 DB_COLUMN_PREFIXderivativeOrder int(11) NOT NULL,
 DB_COLUMN_PREFIXderivativeSize int(11),
 DB_COLUMN_PREFIXderivativeType int(11) NOT NULL,
 DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,
 DB_COLUMN_PREFIXpostFilterOperations varchar(255),
 DB_COLUMN_PREFIXisBroken int(1),
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 INDEX DB_TABLE_PREFIXDerivative_85338(DB_COLUMN_PREFIXderivativeSourceId),
 INDEX DB_TABLE_PREFIXDerivative_25243(DB_COLUMN_PREFIXderivativeOrder),
 INDEX DB_TABLE_PREFIXDerivative_97216(DB_COLUMN_PREFIXderivativeType)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Derivative', 1, 1);

# GalleryDerivativeImage
CREATE TABLE DB_TABLE_PREFIXDerivativeImage(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXwidth int(11),
 DB_COLUMN_PREFIXheight int(11),
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativeImage', 1, 0);

# GalleryDerivativePreferencesMap
CREATE TABLE DB_TABLE_PREFIXDerivativePrefsMap(
 DB_COLUMN_PREFIXitemId int(11),
 DB_COLUMN_PREFIXorder int(11),
 DB_COLUMN_PREFIXderivativeType int(11),
 DB_COLUMN_PREFIXderivativeOperations varchar(255),
 INDEX DB_TABLE_PREFIXDerivativePrefsMap_75985(DB_COLUMN_PREFIXitemId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativePrefsMap', 1, 0);

# GalleryDescendentCountsMap
CREATE TABLE DB_TABLE_PREFIXDescendentCountsMap(
 DB_COLUMN_PREFIXuserId int(11) NOT NULL,
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXdescendentCount int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DescendentCountsMap', 1, 0);

# GalleryEntity
CREATE TABLE DB_TABLE_PREFIXEntity(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp int(11) NOT NULL,
 DB_COLUMN_PREFIXisLinkable int(1) NOT NULL,
 DB_COLUMN_PREFIXlinkId int(11),
 DB_COLUMN_PREFIXmodificationTimestamp int(11) NOT NULL,
 DB_COLUMN_PREFIXserialNumber int(11) NOT NULL,
 DB_COLUMN_PREFIXentityType varchar(32) NOT NULL,
 DB_COLUMN_PREFIXonLoadHandlers varchar(128),
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 INDEX DB_TABLE_PREFIXEntity_76255(DB_COLUMN_PREFIXcreationTimestamp),
 INDEX DB_TABLE_PREFIXEntity_35978(DB_COLUMN_PREFIXisLinkable),
 INDEX DB_TABLE_PREFIXEntity_44738(DB_COLUMN_PREFIXlinkId),
 INDEX DB_TABLE_PREFIXEntity_63025(DB_COLUMN_PREFIXmodificationTimestamp),
 INDEX DB_TABLE_PREFIXEntity_60702(DB_COLUMN_PREFIXserialNumber)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Entity', 1, 2);

# GalleryFactoryMap
CREATE TABLE DB_TABLE_PREFIXFactoryMap(
 DB_COLUMN_PREFIXclassType varchar(128),
 DB_COLUMN_PREFIXclassName varchar(128),
 DB_COLUMN_PREFIXimplId varchar(128),
 DB_COLUMN_PREFIXimplPath varchar(128),
 DB_COLUMN_PREFIXimplModuleId varchar(128),
 DB_COLUMN_PREFIXhints varchar(255),
 DB_COLUMN_PREFIXorderWeight varchar(255)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FactoryMap', 1, 0);

# GalleryFileSystemEntity
CREATE TABLE DB_TABLE_PREFIXFileSystemEntity(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXpathComponent varchar(128),
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 INDEX DB_TABLE_PREFIXFileSystemEntity_3406(DB_COLUMN_PREFIXpathComponent)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FileSystemEntity', 1, 0);

# GalleryGroup
CREATE TABLE DB_TABLE_PREFIXGroup(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXgroupType int(11) NOT NULL,
 DB_COLUMN_PREFIXgroupName varchar(128),
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 UNIQUE (DB_COLUMN_PREFIXgroupName)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Group', 1, 1);

# GalleryItem
CREATE TABLE DB_TABLE_PREFIXItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXcanContainChildren int(1) NOT NULL,
 DB_COLUMN_PREFIXdescription text,
 DB_COLUMN_PREFIXkeywords varchar(255),
 DB_COLUMN_PREFIXownerId int(11) NOT NULL,
 DB_COLUMN_PREFIXsummary varchar(255),
 DB_COLUMN_PREFIXtitle varchar(128),
 DB_COLUMN_PREFIXviewedSinceTimestamp int(11) NOT NULL,
 DB_COLUMN_PREFIXoriginationTimestamp int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 INDEX DB_TABLE_PREFIXItem_99070(DB_COLUMN_PREFIXkeywords),
 INDEX DB_TABLE_PREFIXItem_21573(DB_COLUMN_PREFIXownerId),
 INDEX DB_TABLE_PREFIXItem_54147(DB_COLUMN_PREFIXsummary),
 INDEX DB_TABLE_PREFIXItem_90059(DB_COLUMN_PREFIXtitle)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Item', 1, 1);

# GalleryItemAttributesMap
CREATE TABLE DB_TABLE_PREFIXItemAttributesMap(
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXviewCount int(11),
 DB_COLUMN_PREFIXorderWeight int(11),
 DB_COLUMN_PREFIXparentSequence varchar(255) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXitemId),
 INDEX DB_TABLE_PREFIXItemAttributesMap_95270(DB_COLUMN_PREFIXparentSequence)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ItemAttributesMap', 1, 0);

# GalleryMaintenanceMap
CREATE TABLE DB_TABLE_PREFIXMaintenanceMap(
 DB_COLUMN_PREFIXrunId int(11) NOT NULL,
 DB_COLUMN_PREFIXtaskId varchar(128) NOT NULL,
 DB_COLUMN_PREFIXtimestamp int(11),
 DB_COLUMN_PREFIXsuccess int(1),
 DB_COLUMN_PREFIXdetails text,
 PRIMARY KEY(DB_COLUMN_PREFIXrunId),
 INDEX DB_TABLE_PREFIXMaintenanceMap_21687(DB_COLUMN_PREFIXtaskId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MaintenanceMap', 1, 0);

# GalleryMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXMimeTypeMap(
 DB_COLUMN_PREFIXextension varchar(32) NOT NULL,
 DB_COLUMN_PREFIXmimeType varchar(32) NOT NULL,
 DB_COLUMN_PREFIXviewable int(1),
 PRIMARY KEY(DB_COLUMN_PREFIXextension)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MimeTypeMap', 1, 0);

# GalleryMovieItem
CREATE TABLE DB_TABLE_PREFIXMovieItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXwidth int(11),
 DB_COLUMN_PREFIXheight int(11),
 DB_COLUMN_PREFIXduration int(11),
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MovieItem', 1, 0);

# GalleryPermissionSetMap
CREATE TABLE DB_TABLE_PREFIXPermissionSetMap(
 DB_COLUMN_PREFIXmodule varchar(128) NOT NULL,
 DB_COLUMN_PREFIXpermission varchar(128) NOT NULL,
 DB_COLUMN_PREFIXdescription varchar(255),
 DB_COLUMN_PREFIXbits int(11) NOT NULL,
 DB_COLUMN_PREFIXflags int(11) NOT NULL,
 UNIQUE (DB_COLUMN_PREFIXpermission)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PermissionSetMap', 1, 0);

# GalleryPhotoItem
CREATE TABLE DB_TABLE_PREFIXPhotoItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXwidth int(11),
 DB_COLUMN_PREFIXheight int(11),
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PhotoItem', 1, 0);

# GalleryPluginMap
CREATE TABLE DB_TABLE_PREFIXPluginMap(
 DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,
 DB_COLUMN_PREFIXactive int(1) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginMap', 1, 1);

# GalleryPluginPackageMap
CREATE TABLE DB_TABLE_PREFIXPluginPackageMap(
 DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,
 DB_COLUMN_PREFIXpackageName varchar(32) NOT NULL,
 DB_COLUMN_PREFIXpackageVersion varchar(32) NOT NULL,
 DB_COLUMN_PREFIXpackageBuild varchar(32) NOT NULL,
 INDEX DB_TABLE_PREFIXPluginPackageMap_80596(DB_COLUMN_PREFIXpluginType)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginPackageMap', 1, 0);

# GalleryPluginParameterMap
CREATE TABLE DB_TABLE_PREFIXPluginParameterMap(
 DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXparameterName varchar(128) NOT NULL,
 DB_COLUMN_PREFIXparameterValue text NOT NULL,
 UNIQUE (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXparameterName),
 INDEX DB_TABLE_PREFIXPluginParameterMap_80596(DB_COLUMN_PREFIXpluginType),
 INDEX DB_TABLE_PREFIXPluginParameterMap_12808(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginParameterMap', 1, 3);

# GalleryRecoverPasswordMap
CREATE TABLE DB_TABLE_PREFIXRecoverPasswordMap(
 DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,
 DB_COLUMN_PREFIXauthString varchar(32) NOT NULL,
 DB_COLUMN_PREFIXrequestExpires int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXuserName)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RecoverPasswordMap', 1, 1);

# GallerySessionMap
CREATE TABLE DB_TABLE_PREFIXSessionMap(
 DB_COLUMN_PREFIXid varchar(32) NOT NULL,
 DB_COLUMN_PREFIXuserId int(11) NOT NULL,
 DB_COLUMN_PREFIXremoteIdentifier varchar(128) NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp int(11) NOT NULL,
 DB_COLUMN_PREFIXmodificationTimestamp int(11) NOT NULL,
 DB_COLUMN_PREFIXdata text,
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 INDEX DB_TABLE_PREFIXSessionMap_53500(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXcreationTimestamp, DB_COLUMN_PREFIXmodificationTimestamp)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('SessionMap', 1, 0);

# GalleryToolkitOperationMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMap(
 DB_COLUMN_PREFIXname varchar(128) NOT NULL,
 DB_COLUMN_PREFIXparametersCrc varchar(32) NOT NULL,
 DB_COLUMN_PREFIXoutputMimeType varchar(128),
 DB_COLUMN_PREFIXdescription varchar(255),
 PRIMARY KEY(DB_COLUMN_PREFIXname)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMap', 1, 0);

# GalleryToolkitOperationMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMimeTypeMap(
 DB_COLUMN_PREFIXoperationName varchar(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId varchar(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,
 DB_COLUMN_PREFIXpriority int(11) NOT NULL,
 INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_2014(DB_COLUMN_PREFIXoperationName),
 INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_79463(DB_COLUMN_PREFIXmimeType)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMimeTypeMap', 1, 0);

# GalleryToolkitOperationParameterMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnParameterMap(
 DB_COLUMN_PREFIXoperationName varchar(128) NOT NULL,
 DB_COLUMN_PREFIXposition int(11) NOT NULL,
 DB_COLUMN_PREFIXtype varchar(128) NOT NULL,
 DB_COLUMN_PREFIXdescription varchar(255),
 INDEX DB_TABLE_PREFIXTkOperatnParameterMap_2014(DB_COLUMN_PREFIXoperationName)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnParameterMap', 1, 0);

# GalleryToolkitPropertyMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMap(
 DB_COLUMN_PREFIXname varchar(128) NOT NULL,
 DB_COLUMN_PREFIXtype varchar(128) NOT NULL,
 DB_COLUMN_PREFIXdescription varchar(128) NOT NULL
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMap', 1, 0);

# GalleryToolkitPropertyMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMimeTypeMap(
 DB_COLUMN_PREFIXpropertyName varchar(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId varchar(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,
 INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_52881(DB_COLUMN_PREFIXpropertyName),
 INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_79463(DB_COLUMN_PREFIXmimeType)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMimeTypeMap', 1, 0);

# GalleryUnknownItem
CREATE TABLE DB_TABLE_PREFIXUnknownItem(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXid)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UnknownItem', 1, 0);

# GalleryUser
CREATE TABLE DB_TABLE_PREFIXUser(
 DB_COLUMN_PREFIXid int(11) NOT NULL,
 DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,
 DB_COLUMN_PREFIXfullName varchar(128),
 DB_COLUMN_PREFIXhashedPassword varchar(128),
 DB_COLUMN_PREFIXemail varchar(255),
 DB_COLUMN_PREFIXlanguage varchar(128),
 PRIMARY KEY(DB_COLUMN_PREFIXid),
 UNIQUE (DB_COLUMN_PREFIXuserName)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('User', 1, 1);

# GalleryUserGroupMap
CREATE TABLE DB_TABLE_PREFIXUserGroupMap(
 DB_COLUMN_PREFIXuserId int(11) NOT NULL,
 DB_COLUMN_PREFIXgroupId int(11) NOT NULL,
 INDEX DB_TABLE_PREFIXUserGroupMap_69068(DB_COLUMN_PREFIXuserId),
 INDEX DB_TABLE_PREFIXUserGroupMap_89328(DB_COLUMN_PREFIXgroupId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UserGroupMap', 1, 0);

# Lock
CREATE TABLE DB_TABLE_PREFIXLock(
 DB_COLUMN_PREFIXlockId int(11),
 DB_COLUMN_PREFIXreadEntityId int(11),
 DB_COLUMN_PREFIXwriteEntityId int(11),
 DB_COLUMN_PREFIXfreshUntil int(11),
 DB_COLUMN_PREFIXrequest int(11),
 INDEX DB_TABLE_PREFIXLock_11039(DB_COLUMN_PREFIXlockId)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Lock', 1, 0);

# R_GalleryCache_1.0
DROP TABLE DB_TABLE_PREFIXCache;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='Cache';

# R_GalleryItemPropertiesMap_1.0
DROP TABLE DB_TABLE_PREFIXItemPropertiesMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='ItemPropertiesMap';

# R_GalleryPermissionMap_1.0
DROP TABLE DB_TABLE_PREFIXPermissionMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='PermissionMap';

# Schema
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname varchar(128) NOT NULL,
 DB_COLUMN_PREFIXmajor int(11) NOT NULL,
 DB_COLUMN_PREFIXminor int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXname)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_1
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname varchar(128) NOT NULL,
 DB_COLUMN_PREFIXmajor int(11) NOT NULL,
 DB_COLUMN_PREFIXminor int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXname)
) TYPE=DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_2
ALTER TABLE DB_TABLE_PREFIXSchema
  ADD COLUMN DB_COLUMN_PREFIXtestCol varchar(128),
  ADD INDEX DB_TABLE_PREFIXSchema_18169(DB_COLUMN_PREFIXtestCol);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# T_InstallerTest_3
ALTER TABLE DB_TABLE_PREFIXSchema
  DROP INDEX DB_TABLE_PREFIXSchema_18169;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# T_InstallerTest_4
DROP TABLE DB_TABLE_PREFIXSchema;

## postgres
# A_GalleryAccessMap_1.0
DROP INDEX DB_TABLE_PREFIXAccessMap_33666;

ALTER TABLE DB_TABLE_PREFIXAccessMap ADD COLUMN DB_COLUMN_PREFIXuserOrGroupId INTEGER;

ALTER TABLE DB_TABLE_PREFIXAccessMap ALTER COLUMN DB_COLUMN_PREFIXuserOrGroupId SET DEFAULT '0';

UPDATE DB_TABLE_PREFIXAccessMap SET DB_COLUMN_PREFIXuserOrGroupId = '0';

ALTER TABLE DB_TABLE_PREFIXAccessMap ALTER DB_COLUMN_PREFIXuserOrGroupId SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryAccessMap_1.1
ALTER TABLE DB_TABLE_PREFIXAccessMap DROP COLUMN DB_COLUMN_PREFIXuserId;

ALTER TABLE DB_TABLE_PREFIXAccessMap DROP COLUMN DB_COLUMN_PREFIXgroupId;

ALTER TABLE DB_TABLE_PREFIXAccessMap ADD PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_48775 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXuserOrGroupId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryAccessMap_1.2
CREATE INDEX DB_TABLE_PREFIXAccessMap_83732 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXaccessListId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryAlbumItem_1.0
ALTER TABLE DB_TABLE_PREFIXAlbumItem DROP COLUMN DB_COLUMN_PREFIXlayout;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AlbumItem' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryDerivative_1.0
ALTER TABLE DB_TABLE_PREFIXDerivative ADD COLUMN DB_COLUMN_PREFIXisBroken SMALLINT;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Derivative' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.0
ALTER TABLE DB_TABLE_PREFIXEntity ADD COLUMN DB_COLUMN_PREFIXonLoadHandlers VARCHAR(128);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.1
CREATE INDEX DB_TABLE_PREFIXEntity_44738 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXlinkId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryGroup_1.0
ALTER TABLE DB_TABLE_PREFIXGroup ADD COLUMN DB_COLUMN_PREFIXgroupNameTemp VARCHAR(128);

UPDATE DB_TABLE_PREFIXGroup SET DB_COLUMN_PREFIXgroupNameTemp = CAST(DB_COLUMN_PREFIXgroupName AS VARCHAR(128));

ALTER TABLE DB_TABLE_PREFIXGroup DROP DB_COLUMN_PREFIXgroupName;

ALTER TABLE DB_TABLE_PREFIXGroup RENAME DB_COLUMN_PREFIXgroupNameTemp to DB_COLUMN_PREFIXgroupName;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Group' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryItem_1.0
ALTER TABLE DB_TABLE_PREFIXItem ADD COLUMN DB_COLUMN_PREFIXoriginationTimestamp INTEGER;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Item' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginMap ADD COLUMN DB_COLUMN_PREFIXpluginTypeTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginMap SET DB_COLUMN_PREFIXpluginTypeTemp = CAST(DB_COLUMN_PREFIXpluginType AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginMap DROP DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginMap RENAME DB_COLUMN_PREFIXpluginTypeTemp to DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginMap ALTER DB_COLUMN_PREFIXpluginType SET NOT NULL;

ALTER TABLE DB_TABLE_PREFIXPluginMap ADD COLUMN DB_COLUMN_PREFIXpluginIdTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginMap SET DB_COLUMN_PREFIXpluginIdTemp = CAST(DB_COLUMN_PREFIXpluginId AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginMap DROP DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginMap RENAME DB_COLUMN_PREFIXpluginIdTemp to DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginMap ALTER DB_COLUMN_PREFIXpluginId SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD COLUMN DB_COLUMN_PREFIXpluginTypeTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXpluginTypeTemp = CAST(DB_COLUMN_PREFIXpluginType AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME DB_COLUMN_PREFIXpluginTypeTemp to DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ALTER DB_COLUMN_PREFIXpluginType SET NOT NULL;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD COLUMN DB_COLUMN_PREFIXpluginIdTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXpluginIdTemp = CAST(DB_COLUMN_PREFIXpluginId AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME DB_COLUMN_PREFIXpluginIdTemp to DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ALTER DB_COLUMN_PREFIXpluginId SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.1
UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryPluginParameterMap_1.2
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD COLUMN DB_COLUMN_PREFIXparameterValueTemp text;

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXparameterValueTemp = CAST(DB_COLUMN_PREFIXparameterValue AS text);

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP DB_COLUMN_PREFIXparameterValue;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME DB_COLUMN_PREFIXparameterValueTemp to DB_COLUMN_PREFIXparameterValue;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ALTER DB_COLUMN_PREFIXparameterValue SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryUser_1.0
ALTER TABLE DB_TABLE_PREFIXUser ADD COLUMN DB_COLUMN_PREFIXemailTemp VARCHAR(255);

UPDATE DB_TABLE_PREFIXUser SET DB_COLUMN_PREFIXemailTemp = CAST(DB_COLUMN_PREFIXemail AS VARCHAR(255));

ALTER TABLE DB_TABLE_PREFIXUser DROP DB_COLUMN_PREFIXemail;

ALTER TABLE DB_TABLE_PREFIXUser RENAME DB_COLUMN_PREFIXemailTemp to DB_COLUMN_PREFIXemail;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='User' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# ExternalIdMap
CREATE TABLE DB_TABLE_PREFIXExternalIdMap(
 DB_COLUMN_PREFIXexternalId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXentityType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXentityId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXExternalIdMap ADD PRIMARY KEY (DB_COLUMN_PREFIXexternalId, DB_COLUMN_PREFIXentityType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ExternalIdMap', 1, 0);

# GalleryAccessMap
CREATE TABLE DB_TABLE_PREFIXAccessMap(
 DB_COLUMN_PREFIXaccessListId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserOrGroupId INTEGER NOT NULL,
 DB_COLUMN_PREFIXpermission BIT(32) NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXAccessMap ADD PRIMARY KEY (DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_83732 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXaccessListId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_48775 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_18058 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXpermission);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessMap', 1, 3);

# GalleryAccessSubscriberMap
CREATE TABLE DB_TABLE_PREFIXAccessSubscriberMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaccessListId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXAccessSubscriberMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXAccessSubscriberMap_83732 ON DB_TABLE_PREFIXAccessSubscriberMap(DB_COLUMN_PREFIXaccessListId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessSubscriberMap', 1, 0);

# GalleryAlbumItem
CREATE TABLE DB_TABLE_PREFIXAlbumItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXtheme VARCHAR(32),
 DB_COLUMN_PREFIXorderBy VARCHAR(128),
 DB_COLUMN_PREFIXorderDirection VARCHAR(32)
);

ALTER TABLE DB_TABLE_PREFIXAlbumItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AlbumItem', 1, 1);

# GalleryAnimationItem
CREATE TABLE DB_TABLE_PREFIXAnimationItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXAnimationItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AnimationItem', 1, 0);

# GalleryCacheMap
CREATE TABLE DB_TABLE_PREFIXCacheMap(
 DB_COLUMN_PREFIXkey VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXvalue text,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXtimestamp INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXCacheMap ADD PRIMARY KEY (DB_COLUMN_PREFIXkey, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXtype);

CREATE INDEX DB_TABLE_PREFIXCacheMap_69068 ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXCacheMap_75985 ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXCacheMap_81545 ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXtype);

CREATE INDEX DB_TABLE_PREFIXCacheMap_24286 ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXtimestamp);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('CacheMap', 1, 0);

# GalleryChildEntity
CREATE TABLE DB_TABLE_PREFIXChildEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXparentId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXChildEntity ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXChildEntity_52718 ON DB_TABLE_PREFIXChildEntity(DB_COLUMN_PREFIXparentId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ChildEntity', 1, 0);

# GalleryDataItem
CREATE TABLE DB_TABLE_PREFIXDataItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128),
 DB_COLUMN_PREFIXsize INTEGER
);

ALTER TABLE DB_TABLE_PREFIXDataItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DataItem', 1, 0);

# GalleryDerivative
CREATE TABLE DB_TABLE_PREFIXDerivative(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeSourceId INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeOperations VARCHAR(255),
 DB_COLUMN_PREFIXderivativeOrder INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeSize INTEGER,
 DB_COLUMN_PREFIXderivativeType INTEGER NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXpostFilterOperations VARCHAR(255),
 DB_COLUMN_PREFIXisBroken SMALLINT
);

ALTER TABLE DB_TABLE_PREFIXDerivative ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXDerivative_85338 ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeSourceId);

CREATE INDEX DB_TABLE_PREFIXDerivative_25243 ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeOrder);

CREATE INDEX DB_TABLE_PREFIXDerivative_97216 ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Derivative', 1, 1);

# GalleryDerivativeImage
CREATE TABLE DB_TABLE_PREFIXDerivativeImage(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXDerivativeImage ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativeImage', 1, 0);

# GalleryDerivativePreferencesMap
CREATE TABLE DB_TABLE_PREFIXDerivativePrefsMap(
 DB_COLUMN_PREFIXitemId INTEGER,
 DB_COLUMN_PREFIXorder INTEGER,
 DB_COLUMN_PREFIXderivativeType INTEGER,
 DB_COLUMN_PREFIXderivativeOperations VARCHAR(255)
);

CREATE INDEX DB_TABLE_PREFIXDerivativePrefsMap_75985 ON DB_TABLE_PREFIXDerivativePrefsMap(DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativePrefsMap', 1, 0);

# GalleryDescendentCountsMap
CREATE TABLE DB_TABLE_PREFIXDescendentCountsMap(
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXdescendentCount INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXDescendentCountsMap ADD PRIMARY KEY (DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DescendentCountsMap', 1, 0);

# GalleryEntity
CREATE TABLE DB_TABLE_PREFIXEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXisLinkable SMALLINT NOT NULL,
 DB_COLUMN_PREFIXlinkId INTEGER,
 DB_COLUMN_PREFIXmodificationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXserialNumber INTEGER NOT NULL,
 DB_COLUMN_PREFIXentityType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXonLoadHandlers VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXEntity ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXEntity_76255 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXcreationTimestamp);

CREATE INDEX DB_TABLE_PREFIXEntity_35978 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXisLinkable);

CREATE INDEX DB_TABLE_PREFIXEntity_44738 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXlinkId);

CREATE INDEX DB_TABLE_PREFIXEntity_63025 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXmodificationTimestamp);

CREATE INDEX DB_TABLE_PREFIXEntity_60702 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXserialNumber);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Entity', 1, 2);

# GalleryFactoryMap
CREATE TABLE DB_TABLE_PREFIXFactoryMap(
 DB_COLUMN_PREFIXclassType VARCHAR(128),
 DB_COLUMN_PREFIXclassName VARCHAR(128),
 DB_COLUMN_PREFIXimplId VARCHAR(128),
 DB_COLUMN_PREFIXimplPath VARCHAR(128),
 DB_COLUMN_PREFIXimplModuleId VARCHAR(128),
 DB_COLUMN_PREFIXhints VARCHAR(255),
 DB_COLUMN_PREFIXorderWeight VARCHAR(255));

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FactoryMap', 1, 0);

# GalleryFileSystemEntity
CREATE TABLE DB_TABLE_PREFIXFileSystemEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXpathComponent VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXFileSystemEntity ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXFileSystemEntity_3406 ON DB_TABLE_PREFIXFileSystemEntity(DB_COLUMN_PREFIXpathComponent);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FileSystemEntity', 1, 0);

# GalleryGroup
CREATE TABLE DB_TABLE_PREFIXGroup(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupType INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupName VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXGroup ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE UNIQUE INDEX DB_TABLE_PREFIXGroup_19099 ON DB_TABLE_PREFIXGroup(DB_COLUMN_PREFIXgroupName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Group', 1, 1);

# GalleryItem
CREATE TABLE DB_TABLE_PREFIXItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXcanContainChildren SMALLINT NOT NULL,
 DB_COLUMN_PREFIXdescription text,
 DB_COLUMN_PREFIXkeywords VARCHAR(255),
 DB_COLUMN_PREFIXownerId INTEGER NOT NULL,
 DB_COLUMN_PREFIXsummary VARCHAR(255),
 DB_COLUMN_PREFIXtitle VARCHAR(128),
 DB_COLUMN_PREFIXviewedSinceTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXoriginationTimestamp INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXItem_99070 ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXkeywords);

CREATE INDEX DB_TABLE_PREFIXItem_21573 ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXownerId);

CREATE INDEX DB_TABLE_PREFIXItem_54147 ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXsummary);

CREATE INDEX DB_TABLE_PREFIXItem_90059 ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXtitle);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Item', 1, 1);

# GalleryItemAttributesMap
CREATE TABLE DB_TABLE_PREFIXItemAttributesMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXviewCount INTEGER,
 DB_COLUMN_PREFIXorderWeight INTEGER,
 DB_COLUMN_PREFIXparentSequence VARCHAR(255) NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXItemAttributesMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXItemAttributesMap_95270 ON DB_TABLE_PREFIXItemAttributesMap(DB_COLUMN_PREFIXparentSequence);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ItemAttributesMap', 1, 0);

# GalleryMaintenanceMap
CREATE TABLE DB_TABLE_PREFIXMaintenanceMap(
 DB_COLUMN_PREFIXrunId INTEGER NOT NULL,
 DB_COLUMN_PREFIXtaskId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtimestamp INTEGER,
 DB_COLUMN_PREFIXsuccess SMALLINT,
 DB_COLUMN_PREFIXdetails text
);

ALTER TABLE DB_TABLE_PREFIXMaintenanceMap ADD PRIMARY KEY (DB_COLUMN_PREFIXrunId);

CREATE INDEX DB_TABLE_PREFIXMaintenanceMap_21687 ON DB_TABLE_PREFIXMaintenanceMap(DB_COLUMN_PREFIXtaskId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MaintenanceMap', 1, 0);

# GalleryMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXMimeTypeMap(
 DB_COLUMN_PREFIXextension VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXviewable SMALLINT
);

ALTER TABLE DB_TABLE_PREFIXMimeTypeMap ADD PRIMARY KEY (DB_COLUMN_PREFIXextension);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MimeTypeMap', 1, 0);

# GalleryMovieItem
CREATE TABLE DB_TABLE_PREFIXMovieItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER,
 DB_COLUMN_PREFIXduration INTEGER
);

ALTER TABLE DB_TABLE_PREFIXMovieItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MovieItem', 1, 0);

# GalleryPermissionSetMap
CREATE TABLE DB_TABLE_PREFIXPermissionSetMap(
 DB_COLUMN_PREFIXmodule VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXpermission VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(255),
 DB_COLUMN_PREFIXbits BIT(32) NOT NULL,
 DB_COLUMN_PREFIXflags INTEGER NOT NULL
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXPermissionSetMap_18058 ON DB_TABLE_PREFIXPermissionSetMap(DB_COLUMN_PREFIXpermission);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PermissionSetMap', 1, 0);

# GalleryPhotoItem
CREATE TABLE DB_TABLE_PREFIXPhotoItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXPhotoItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PhotoItem', 1, 0);

# GalleryPluginMap
CREATE TABLE DB_TABLE_PREFIXPluginMap(
 DB_COLUMN_PREFIXpluginType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXactive SMALLINT NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXPluginMap ADD PRIMARY KEY (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginMap', 1, 1);

# GalleryPluginPackageMap
CREATE TABLE DB_TABLE_PREFIXPluginPackageMap(
 DB_COLUMN_PREFIXpluginType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpackageName VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpackageVersion VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpackageBuild VARCHAR(32) NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXPluginPackageMap_80596 ON DB_TABLE_PREFIXPluginPackageMap(DB_COLUMN_PREFIXpluginType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginPackageMap', 1, 0);

# GalleryPluginParameterMap
CREATE TABLE DB_TABLE_PREFIXPluginParameterMap(
 DB_COLUMN_PREFIXpluginType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXparameterName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXparameterValue text NOT NULL
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXPluginParameterMap_26955 ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXparameterName);

CREATE INDEX DB_TABLE_PREFIXPluginParameterMap_80596 ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType);

CREATE INDEX DB_TABLE_PREFIXPluginParameterMap_12808 ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginParameterMap', 1, 3);

# GalleryRecoverPasswordMap
CREATE TABLE DB_TABLE_PREFIXRecoverPasswordMap(
 DB_COLUMN_PREFIXuserName VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXauthString VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXrequestExpires INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRecoverPasswordMap ADD PRIMARY KEY (DB_COLUMN_PREFIXuserName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RecoverPasswordMap', 1, 1);

# GallerySessionMap
CREATE TABLE DB_TABLE_PREFIXSessionMap(
 DB_COLUMN_PREFIXid VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXremoteIdentifier VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXmodificationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXdata text
);

ALTER TABLE DB_TABLE_PREFIXSessionMap ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXSessionMap_53500 ON DB_TABLE_PREFIXSessionMap(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXcreationTimestamp, DB_COLUMN_PREFIXmodificationTimestamp);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('SessionMap', 1, 0);

# GalleryToolkitOperationMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMap(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXparametersCrc VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXoutputMimeType VARCHAR(128),
 DB_COLUMN_PREFIXdescription VARCHAR(255)
);

ALTER TABLE DB_TABLE_PREFIXTkOperatnMap ADD PRIMARY KEY (DB_COLUMN_PREFIXname);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMap', 1, 0);

# GalleryToolkitOperationMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMimeTypeMap(
 DB_COLUMN_PREFIXoperationName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXpriority INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_2014 ON DB_TABLE_PREFIXTkOperatnMimeTypeMap(DB_COLUMN_PREFIXoperationName);

CREATE INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_79463 ON DB_TABLE_PREFIXTkOperatnMimeTypeMap(DB_COLUMN_PREFIXmimeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMimeTypeMap', 1, 0);

# GalleryToolkitOperationParameterMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnParameterMap(
 DB_COLUMN_PREFIXoperationName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXposition INTEGER NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(255)
);

CREATE INDEX DB_TABLE_PREFIXTkOperatnParameterMap_2014 ON DB_TABLE_PREFIXTkOperatnParameterMap(DB_COLUMN_PREFIXoperationName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnParameterMap', 1, 0);

# GalleryToolkitPropertyMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMap(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(128) NOT NULL);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMap', 1, 0);

# GalleryToolkitPropertyMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMimeTypeMap(
 DB_COLUMN_PREFIXpropertyName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128) NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_52881 ON DB_TABLE_PREFIXTkPropertyMimeTypeMap(DB_COLUMN_PREFIXpropertyName);

CREATE INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_79463 ON DB_TABLE_PREFIXTkPropertyMimeTypeMap(DB_COLUMN_PREFIXmimeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMimeTypeMap', 1, 0);

# GalleryUnknownItem
CREATE TABLE DB_TABLE_PREFIXUnknownItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXUnknownItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UnknownItem', 1, 0);

# GalleryUser
CREATE TABLE DB_TABLE_PREFIXUser(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserName VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXfullName VARCHAR(128),
 DB_COLUMN_PREFIXhashedPassword VARCHAR(128),
 DB_COLUMN_PREFIXemail VARCHAR(255),
 DB_COLUMN_PREFIXlanguage VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXUser ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE UNIQUE INDEX DB_TABLE_PREFIXUser_16233 ON DB_TABLE_PREFIXUser(DB_COLUMN_PREFIXuserName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('User', 1, 1);

# GalleryUserGroupMap
CREATE TABLE DB_TABLE_PREFIXUserGroupMap(
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupId INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXUserGroupMap_69068 ON DB_TABLE_PREFIXUserGroupMap(DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXUserGroupMap_89328 ON DB_TABLE_PREFIXUserGroupMap(DB_COLUMN_PREFIXgroupId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UserGroupMap', 1, 0);

# Lock
CREATE TABLE DB_TABLE_PREFIXLock(
 DB_COLUMN_PREFIXlockId INTEGER,
 DB_COLUMN_PREFIXreadEntityId INTEGER,
 DB_COLUMN_PREFIXwriteEntityId INTEGER,
 DB_COLUMN_PREFIXfreshUntil INTEGER,
 DB_COLUMN_PREFIXrequest INTEGER
);

CREATE INDEX DB_TABLE_PREFIXLock_11039 ON DB_TABLE_PREFIXLock(DB_COLUMN_PREFIXlockId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Lock', 1, 0);

# R_GalleryCache_1.0
DROP TABLE DB_TABLE_PREFIXCache;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='Cache';

# R_GalleryItemPropertiesMap_1.0
DROP TABLE DB_TABLE_PREFIXItemPropertiesMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='ItemPropertiesMap';

# R_GalleryPermissionMap_1.0
DROP TABLE DB_TABLE_PREFIXPermissionMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='PermissionMap';

# Schema
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmajor INTEGER NOT NULL,
 DB_COLUMN_PREFIXminor INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXSchema ADD PRIMARY KEY (DB_COLUMN_PREFIXname);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_1
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmajor INTEGER NOT NULL,
 DB_COLUMN_PREFIXminor INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXSchema ADD PRIMARY KEY (DB_COLUMN_PREFIXname);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_2
ALTER TABLE DB_TABLE_PREFIXSchema ADD COLUMN DB_COLUMN_PREFIXtestCol VARCHAR(128);

CREATE INDEX DB_TABLE_PREFIXSchema_18169 ON DB_TABLE_PREFIXSchema(DB_COLUMN_PREFIXtestCol);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# T_InstallerTest_3
DROP INDEX DB_TABLE_PREFIXSchema_18169;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# T_InstallerTest_4
DROP TABLE DB_TABLE_PREFIXSchema;

## oracle
# A_GalleryAccessMap_1.0
ALTER TABLE DB_TABLE_PREFIXAccessMap
  DROP UNIQUE (DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXgroupId);

ALTER TABLE DB_TABLE_PREFIXAccessMap
  ADD (DB_COLUMN_PREFIXuserOrGroupId INTEGER DEFAULT '0' NOT NULL);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryAccessMap_1.1
ALTER TABLE DB_TABLE_PREFIXAccessMap
  DROP (DB_COLUMN_PREFIXuserId);

ALTER TABLE DB_TABLE_PREFIXAccessMap
  DROP (DB_COLUMN_PREFIXgroupId);

ALTER TABLE DB_TABLE_PREFIXAccessMap
  ADD PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_48775 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXuserOrGroupId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryAccessMap_1.2
CREATE INDEX DB_TABLE_PREFIXAccessMap_83732 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXaccessListId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryAlbumItem_1.0
ALTER TABLE DB_TABLE_PREFIXAlbumItem
  DROP (DB_COLUMN_PREFIXlayout);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AlbumItem' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryDerivative_1.0
ALTER TABLE DB_TABLE_PREFIXDerivative
  ADD (DB_COLUMN_PREFIXisBroken NUMBER(1));

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Derivative' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.0
ALTER TABLE DB_TABLE_PREFIXEntity
  ADD (DB_COLUMN_PREFIXonLoadHandlers VARCHAR2(128));

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.1
CREATE INDEX DB_TABLE_PREFIXEntity_44738 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXlinkId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryGroup_1.0
ALTER TABLE DB_TABLE_PREFIXGroup ADD (DB_COLUMN_PREFIXgroupNameTemp VARCHAR2(128));

UPDATE DB_TABLE_PREFIXGroup SET DB_COLUMN_PREFIXgroupNameTemp = DB_COLUMN_PREFIXgroupName;

ALTER TABLE DB_TABLE_PREFIXGroup DROP (DB_COLUMN_PREFIXgroupName);

ALTER TABLE DB_TABLE_PREFIXGroup RENAME COLUMN DB_COLUMN_PREFIXgroupNameTemp TO DB_COLUMN_PREFIXgroupName;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Group' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryItem_1.0
ALTER TABLE DB_TABLE_PREFIXItem
  ADD (DB_COLUMN_PREFIXoriginationTimestamp INTEGER);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Item' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginMap ADD (DB_COLUMN_PREFIXpluginTypeTemp VARCHAR2(32));

UPDATE DB_TABLE_PREFIXPluginMap SET DB_COLUMN_PREFIXpluginTypeTemp = DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginMap DROP (DB_COLUMN_PREFIXpluginType);

ALTER TABLE DB_TABLE_PREFIXPluginMap RENAME COLUMN DB_COLUMN_PREFIXpluginTypeTemp TO DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginMap MODIFY (DB_COLUMN_PREFIXpluginType NOT NULL);

ALTER TABLE DB_TABLE_PREFIXPluginMap ADD (DB_COLUMN_PREFIXpluginIdTemp VARCHAR2(32));

UPDATE DB_TABLE_PREFIXPluginMap SET DB_COLUMN_PREFIXpluginIdTemp = DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginMap DROP (DB_COLUMN_PREFIXpluginId);

ALTER TABLE DB_TABLE_PREFIXPluginMap RENAME COLUMN DB_COLUMN_PREFIXpluginIdTemp TO DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginMap MODIFY (DB_COLUMN_PREFIXpluginId NOT NULL);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD (DB_COLUMN_PREFIXpluginTypeTemp VARCHAR2(32));

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXpluginTypeTemp = DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP (DB_COLUMN_PREFIXpluginType);

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME COLUMN DB_COLUMN_PREFIXpluginTypeTemp TO DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap MODIFY (DB_COLUMN_PREFIXpluginType NOT NULL);

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD (DB_COLUMN_PREFIXpluginIdTemp VARCHAR2(32));

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXpluginIdTemp = DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP (DB_COLUMN_PREFIXpluginId);

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME COLUMN DB_COLUMN_PREFIXpluginIdTemp TO DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap MODIFY (DB_COLUMN_PREFIXpluginId NOT NULL);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.1
UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryPluginParameterMap_1.2
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD (DB_COLUMN_PREFIXparameterValueTemp VARCHAR2(4000));

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXparameterValueTemp = DB_COLUMN_PREFIXparameterValue;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP (DB_COLUMN_PREFIXparameterValue);

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME COLUMN DB_COLUMN_PREFIXparameterValueTemp TO DB_COLUMN_PREFIXparameterValue;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryUser_1.0
ALTER TABLE DB_TABLE_PREFIXUser ADD (DB_COLUMN_PREFIXemailTemp VARCHAR2(255));

UPDATE DB_TABLE_PREFIXUser SET DB_COLUMN_PREFIXemailTemp = DB_COLUMN_PREFIXemail;

ALTER TABLE DB_TABLE_PREFIXUser DROP (DB_COLUMN_PREFIXemail);

ALTER TABLE DB_TABLE_PREFIXUser RENAME COLUMN DB_COLUMN_PREFIXemailTemp TO DB_COLUMN_PREFIXemail;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='User' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# ExternalIdMap
CREATE TABLE DB_TABLE_PREFIXExternalIdMap(
 DB_COLUMN_PREFIXexternalId VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXentityType VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXentityId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXExternalIdMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXexternalId, DB_COLUMN_PREFIXentityType)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ExternalIdMap', 1, 0);

# GalleryAccessMap
CREATE TABLE DB_TABLE_PREFIXAccessMap(
 DB_COLUMN_PREFIXaccessListId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserOrGroupId INTEGER NOT NULL,
 DB_COLUMN_PREFIXpermission INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXAccessMap_83732
   ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXaccessListId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_48775
   ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAccessMap_18058
   ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXpermission);

ALTER TABLE DB_TABLE_PREFIXAccessMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessMap', 1, 3);

# GalleryAccessSubscriberMap
CREATE TABLE DB_TABLE_PREFIXAccessSubscriberMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaccessListId INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXAccessSubscriberMap_83732
   ON DB_TABLE_PREFIXAccessSubscriberMap(DB_COLUMN_PREFIXaccessListId);

ALTER TABLE DB_TABLE_PREFIXAccessSubscriberMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessSubscriberMap', 1, 0);

# GalleryAlbumItem
CREATE TABLE DB_TABLE_PREFIXAlbumItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXtheme VARCHAR2(32),
 DB_COLUMN_PREFIXorderBy VARCHAR2(128),
 DB_COLUMN_PREFIXorderDirection VARCHAR2(32)
);

ALTER TABLE DB_TABLE_PREFIXAlbumItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AlbumItem', 1, 1);

# GalleryAnimationItem
CREATE TABLE DB_TABLE_PREFIXAnimationItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXAnimationItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AnimationItem', 1, 0);

# GalleryCacheMap
CREATE TABLE DB_TABLE_PREFIXCacheMap(
 DB_COLUMN_PREFIXkey VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXvalue CLOB,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXtimestamp INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXCacheMap_69068
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXCacheMap_75985
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXCacheMap_81545
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXtype);

CREATE INDEX DB_TABLE_PREFIXCacheMap_24286
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXtimestamp);

ALTER TABLE DB_TABLE_PREFIXCacheMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXkey, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXtype)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('CacheMap', 1, 0);

# GalleryChildEntity
CREATE TABLE DB_TABLE_PREFIXChildEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXparentId INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXChildEntity_52718
   ON DB_TABLE_PREFIXChildEntity(DB_COLUMN_PREFIXparentId);

ALTER TABLE DB_TABLE_PREFIXChildEntity
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ChildEntity', 1, 0);

# GalleryDataItem
CREATE TABLE DB_TABLE_PREFIXDataItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR2(128),
 DB_COLUMN_PREFIXsize INTEGER
);

ALTER TABLE DB_TABLE_PREFIXDataItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DataItem', 1, 0);

# GalleryDerivative
CREATE TABLE DB_TABLE_PREFIXDerivative(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeSourceId INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeOperations VARCHAR2(255),
 DB_COLUMN_PREFIXderivativeOrder INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeSize INTEGER,
 DB_COLUMN_PREFIXderivativeType INTEGER NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXpostFilterOperations VARCHAR2(255),
 DB_COLUMN_PREFIXisBroken NUMBER(1)
);

CREATE INDEX DB_TABLE_PREFIXDerivative_85338
   ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeSourceId);

CREATE INDEX DB_TABLE_PREFIXDerivative_25243
   ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeOrder);

CREATE INDEX DB_TABLE_PREFIXDerivative_97216
   ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeType);

ALTER TABLE DB_TABLE_PREFIXDerivative
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Derivative', 1, 1);

# GalleryDerivativeImage
CREATE TABLE DB_TABLE_PREFIXDerivativeImage(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXDerivativeImage
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativeImage', 1, 0);

# GalleryDerivativePreferencesMap
CREATE TABLE DB_TABLE_PREFIXDerivativePrefsMap(
 DB_COLUMN_PREFIXitemId INTEGER,
 DB_COLUMN_PREFIXorder INTEGER,
 DB_COLUMN_PREFIXderivativeType INTEGER,
 DB_COLUMN_PREFIXderivativeOperations VARCHAR2(255)
);

CREATE INDEX DB_TABLE_PREFIXDerivativePrefsMap_75985
   ON DB_TABLE_PREFIXDerivativePrefsMap(DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativePrefsMap', 1, 0);

# GalleryDescendentCountsMap
CREATE TABLE DB_TABLE_PREFIXDescendentCountsMap(
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXdescendentCount INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXDescendentCountsMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DescendentCountsMap', 1, 0);

# GalleryEntity
CREATE TABLE DB_TABLE_PREFIXEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXisLinkable NUMBER(1) NOT NULL,
 DB_COLUMN_PREFIXlinkId INTEGER,
 DB_COLUMN_PREFIXmodificationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXserialNumber INTEGER NOT NULL,
 DB_COLUMN_PREFIXentityType VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXonLoadHandlers VARCHAR2(128)
);

CREATE INDEX DB_TABLE_PREFIXEntity_76255
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXcreationTimestamp);

CREATE INDEX DB_TABLE_PREFIXEntity_35978
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXisLinkable);

CREATE INDEX DB_TABLE_PREFIXEntity_44738
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXlinkId);

CREATE INDEX DB_TABLE_PREFIXEntity_63025
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXmodificationTimestamp);

CREATE INDEX DB_TABLE_PREFIXEntity_60702
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXserialNumber);

ALTER TABLE DB_TABLE_PREFIXEntity
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Entity', 1, 2);

# GalleryFactoryMap
CREATE TABLE DB_TABLE_PREFIXFactoryMap(
 DB_COLUMN_PREFIXclassType VARCHAR2(128),
 DB_COLUMN_PREFIXclassName VARCHAR2(128),
 DB_COLUMN_PREFIXimplId VARCHAR2(128),
 DB_COLUMN_PREFIXimplPath VARCHAR2(128),
 DB_COLUMN_PREFIXimplModuleId VARCHAR2(128),
 DB_COLUMN_PREFIXhints VARCHAR2(255),
 DB_COLUMN_PREFIXorderWeight VARCHAR2(255));

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FactoryMap', 1, 0);

# GalleryFileSystemEntity
CREATE TABLE DB_TABLE_PREFIXFileSystemEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXpathComponent VARCHAR2(128)
);

CREATE INDEX DB_TABLE_PREFIXFileSystemEntity_3406
   ON DB_TABLE_PREFIXFileSystemEntity(DB_COLUMN_PREFIXpathComponent);

ALTER TABLE DB_TABLE_PREFIXFileSystemEntity
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FileSystemEntity', 1, 0);

# GalleryGroup
CREATE TABLE DB_TABLE_PREFIXGroup(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupType INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupName VARCHAR2(128)
);

ALTER TABLE DB_TABLE_PREFIXGroup
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
 ADD UNIQUE (DB_COLUMN_PREFIXgroupName)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Group', 1, 1);

# GalleryItem
CREATE TABLE DB_TABLE_PREFIXItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXcanContainChildren NUMBER(1) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR2(4000),
 DB_COLUMN_PREFIXkeywords VARCHAR2(255),
 DB_COLUMN_PREFIXownerId INTEGER NOT NULL,
 DB_COLUMN_PREFIXsummary VARCHAR2(255),
 DB_COLUMN_PREFIXtitle VARCHAR2(128),
 DB_COLUMN_PREFIXviewedSinceTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXoriginationTimestamp INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXItem_99070
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXkeywords);

CREATE INDEX DB_TABLE_PREFIXItem_21573
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXownerId);

CREATE INDEX DB_TABLE_PREFIXItem_54147
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXsummary);

CREATE INDEX DB_TABLE_PREFIXItem_90059
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXtitle);

ALTER TABLE DB_TABLE_PREFIXItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Item', 1, 1);

# GalleryItemAttributesMap
CREATE TABLE DB_TABLE_PREFIXItemAttributesMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXviewCount INTEGER,
 DB_COLUMN_PREFIXorderWeight INTEGER,
 DB_COLUMN_PREFIXparentSequence VARCHAR2(255)
);

CREATE INDEX DB_TABLE_PREFIXItemAttributesMap_95270
   ON DB_TABLE_PREFIXItemAttributesMap(DB_COLUMN_PREFIXparentSequence);

ALTER TABLE DB_TABLE_PREFIXItemAttributesMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ItemAttributesMap', 1, 0);

# GalleryMaintenanceMap
CREATE TABLE DB_TABLE_PREFIXMaintenanceMap(
 DB_COLUMN_PREFIXrunId INTEGER NOT NULL,
 DB_COLUMN_PREFIXtaskId VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXtimestamp INTEGER,
 DB_COLUMN_PREFIXsuccess NUMBER(1),
 DB_COLUMN_PREFIXdetails VARCHAR2(4000)
);

CREATE INDEX DB_TABLE_PREFIXMaintenanceMap_21687
   ON DB_TABLE_PREFIXMaintenanceMap(DB_COLUMN_PREFIXtaskId);

ALTER TABLE DB_TABLE_PREFIXMaintenanceMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXrunId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MaintenanceMap', 1, 0);

# GalleryMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXMimeTypeMap(
 DB_COLUMN_PREFIXextension VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXviewable NUMBER(1)
);

ALTER TABLE DB_TABLE_PREFIXMimeTypeMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXextension)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MimeTypeMap', 1, 0);

# GalleryMovieItem
CREATE TABLE DB_TABLE_PREFIXMovieItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER,
 DB_COLUMN_PREFIXduration INTEGER
);

ALTER TABLE DB_TABLE_PREFIXMovieItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MovieItem', 1, 0);

# GalleryPermissionSetMap
CREATE TABLE DB_TABLE_PREFIXPermissionSetMap(
 DB_COLUMN_PREFIXmodule VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXpermission VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR2(255),
 DB_COLUMN_PREFIXbits INTEGER NOT NULL,
 DB_COLUMN_PREFIXflags INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXPermissionSetMap
 ADD UNIQUE (DB_COLUMN_PREFIXpermission)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PermissionSetMap', 1, 0);

# GalleryPhotoItem
CREATE TABLE DB_TABLE_PREFIXPhotoItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXPhotoItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PhotoItem', 1, 0);

# GalleryPluginMap
CREATE TABLE DB_TABLE_PREFIXPluginMap(
 DB_COLUMN_PREFIXpluginType VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXactive NUMBER(1) NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXPluginMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginMap', 1, 1);

# GalleryPluginPackageMap
CREATE TABLE DB_TABLE_PREFIXPluginPackageMap(
 DB_COLUMN_PREFIXpluginType VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXpackageName VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXpackageVersion VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXpackageBuild VARCHAR2(32) NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXPluginPackageMap_80596
   ON DB_TABLE_PREFIXPluginPackageMap(DB_COLUMN_PREFIXpluginType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginPackageMap', 1, 0);

# GalleryPluginParameterMap
CREATE TABLE DB_TABLE_PREFIXPluginParameterMap(
 DB_COLUMN_PREFIXpluginType VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXparameterName VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXparameterValue VARCHAR2(4000)
);

CREATE INDEX DB_TABLE_PREFIXPluginParameterMap_80596
   ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType);

CREATE INDEX DB_TABLE_PREFIXPluginParameterMap_12808
   ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId);

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap
 ADD UNIQUE (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXparameterName)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginParameterMap', 1, 3);

# GalleryRecoverPasswordMap
CREATE TABLE DB_TABLE_PREFIXRecoverPasswordMap(
 DB_COLUMN_PREFIXuserName VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXauthString VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXrequestExpires INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRecoverPasswordMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXuserName)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RecoverPasswordMap', 1, 1);

# GallerySessionMap
CREATE TABLE DB_TABLE_PREFIXSessionMap(
 DB_COLUMN_PREFIXid VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXremoteIdentifier VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXmodificationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXdata CLOB
);

CREATE INDEX DB_TABLE_PREFIXSessionMap_53500
   ON DB_TABLE_PREFIXSessionMap(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXcreationTimestamp, DB_COLUMN_PREFIXmodificationTimestamp);

ALTER TABLE DB_TABLE_PREFIXSessionMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('SessionMap', 1, 0);

# GalleryToolkitOperationMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMap(
 DB_COLUMN_PREFIXname VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXparametersCrc VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXoutputMimeType VARCHAR2(128),
 DB_COLUMN_PREFIXdescription VARCHAR2(255)
);

ALTER TABLE DB_TABLE_PREFIXTkOperatnMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXname)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMap', 1, 0);

# GalleryToolkitOperationMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMimeTypeMap(
 DB_COLUMN_PREFIXoperationName VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXpriority INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_2014
   ON DB_TABLE_PREFIXTkOperatnMimeTypeMap(DB_COLUMN_PREFIXoperationName);

CREATE INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_79463
   ON DB_TABLE_PREFIXTkOperatnMimeTypeMap(DB_COLUMN_PREFIXmimeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMimeTypeMap', 1, 0);

# GalleryToolkitOperationParameterMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnParameterMap(
 DB_COLUMN_PREFIXoperationName VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXposition INTEGER NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR2(255)
);

CREATE INDEX DB_TABLE_PREFIXTkOperatnParameterMap_2014
   ON DB_TABLE_PREFIXTkOperatnParameterMap(DB_COLUMN_PREFIXoperationName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnParameterMap', 1, 0);

# GalleryToolkitPropertyMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMap(
 DB_COLUMN_PREFIXname VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR2(128) NOT NULL);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMap', 1, 0);

# GalleryToolkitPropertyMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMimeTypeMap(
 DB_COLUMN_PREFIXpropertyName VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR2(128) NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_52881
   ON DB_TABLE_PREFIXTkPropertyMimeTypeMap(DB_COLUMN_PREFIXpropertyName);

CREATE INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_79463
   ON DB_TABLE_PREFIXTkPropertyMimeTypeMap(DB_COLUMN_PREFIXmimeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMimeTypeMap', 1, 0);

# GalleryUnknownItem
CREATE TABLE DB_TABLE_PREFIXUnknownItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXUnknownItem
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UnknownItem', 1, 0);

# GalleryUser
CREATE TABLE DB_TABLE_PREFIXUser(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserName VARCHAR2(32) NOT NULL,
 DB_COLUMN_PREFIXfullName VARCHAR2(128),
 DB_COLUMN_PREFIXhashedPassword VARCHAR2(128),
 DB_COLUMN_PREFIXemail VARCHAR2(255),
 DB_COLUMN_PREFIXlanguage VARCHAR2(128)
);

ALTER TABLE DB_TABLE_PREFIXUser
 ADD PRIMARY KEY (DB_COLUMN_PREFIXid)
 ADD UNIQUE (DB_COLUMN_PREFIXuserName)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('User', 1, 1);

# GalleryUserGroupMap
CREATE TABLE DB_TABLE_PREFIXUserGroupMap(
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupId INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXUserGroupMap_69068
   ON DB_TABLE_PREFIXUserGroupMap(DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXUserGroupMap_89328
   ON DB_TABLE_PREFIXUserGroupMap(DB_COLUMN_PREFIXgroupId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UserGroupMap', 1, 0);

# Lock
CREATE TABLE DB_TABLE_PREFIXLock(
 DB_COLUMN_PREFIXlockId INTEGER,
 DB_COLUMN_PREFIXreadEntityId INTEGER,
 DB_COLUMN_PREFIXwriteEntityId INTEGER,
 DB_COLUMN_PREFIXfreshUntil INTEGER,
 DB_COLUMN_PREFIXrequest INTEGER
);

CREATE INDEX DB_TABLE_PREFIXLock_11039
   ON DB_TABLE_PREFIXLock(DB_COLUMN_PREFIXlockId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Lock', 1, 0);

# R_GalleryCache_1.0
DROP TABLE DB_TABLE_PREFIXCache;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='Cache';

# R_GalleryItemPropertiesMap_1.0
DROP TABLE DB_TABLE_PREFIXItemPropertiesMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='ItemPropertiesMap';

# R_GalleryPermissionMap_1.0
DROP TABLE DB_TABLE_PREFIXPermissionMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='PermissionMap';

# Schema
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXmajor INTEGER NOT NULL,
 DB_COLUMN_PREFIXminor INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXSchema
 ADD PRIMARY KEY (DB_COLUMN_PREFIXname)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_1
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname VARCHAR2(128) NOT NULL,
 DB_COLUMN_PREFIXmajor INTEGER NOT NULL,
 DB_COLUMN_PREFIXminor INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXSchema
 ADD PRIMARY KEY (DB_COLUMN_PREFIXname)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_2
ALTER TABLE DB_TABLE_PREFIXSchema
  ADD (DB_COLUMN_PREFIXtestCol VARCHAR2(128));

CREATE INDEX DB_TABLE_PREFIXSchema_18169 ON DB_TABLE_PREFIXSchema(DB_COLUMN_PREFIXtestCol);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# T_InstallerTest_3
  DROP INDEX DB_TABLE_PREFIXSchema_18169;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# T_InstallerTest_4
DROP TABLE DB_TABLE_PREFIXSchema;

## db2
# A_GalleryAccessMap_1.0
DROP INDEX DB_TABLE_PREFIXAccessMap_33666;

ALTER TABLE DB_TABLE_PREFIXAccessMap ADD COLUMN DB_COLUMN_PREFIXuserOrGroupId INTEGER DEFAULT '0' NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryAccessMap_1.1
ALTER TABLE DB_TABLE_PREFIXAccessMap DROP COLUMN DB_COLUMN_PREFIXuserId;

ALTER TABLE DB_TABLE_PREFIXAccessMap DROP COLUMN DB_COLUMN_PREFIXgroupId;

ALTER TABLE DB_TABLE_PREFIXAccessMap ADD PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAcces69_48775 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXuserOrGroupId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryAccessMap_1.2
CREATE INDEX DB_TABLE_PREFIXAcces69_83732 ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXaccessListId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='AccessMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryAlbumItem_1.0
ALTER TABLE DB_TABLE_PREFIXAlbumItem DROP COLUMN DB_COLUMN_PREFIXlayout;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='AlbumItem' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryDerivative_1.0
ALTER TABLE DB_TABLE_PREFIXDerivative ADD COLUMN DB_COLUMN_PREFIXisBroken SMALLINT;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Derivative' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.0
ALTER TABLE DB_TABLE_PREFIXEntity ADD COLUMN DB_COLUMN_PREFIXonLoadHandlers VARCHAR(128);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryEntity_1.1
CREATE INDEX DB_TABLE_PREFIXEntit6f_44738 ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXlinkId);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Entity' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryGroup_1.0
ALTER TABLE DB_TABLE_PREFIXGroup ADD COLUMN DB_COLUMN_PREFIXgroupNameTemp VARCHAR(128);

UPDATE DB_TABLE_PREFIXGroup SET DB_COLUMN_PREFIXgroupNameTemp = CAST(DB_COLUMN_PREFIXgroupName AS VARCHAR(128));

ALTER TABLE DB_TABLE_PREFIXGroup DROP DB_COLUMN_PREFIXgroupName;

ALTER TABLE DB_TABLE_PREFIXGroup RENAME DB_COLUMN_PREFIXgroupNameTemp to DB_COLUMN_PREFIXgroupName;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Group' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryItem_1.0
ALTER TABLE DB_TABLE_PREFIXItem ADD COLUMN DB_COLUMN_PREFIXoriginationTimestamp INTEGER;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Item' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginMap ADD COLUMN DB_COLUMN_PREFIXpluginTypeTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginMap SET DB_COLUMN_PREFIXpluginTypeTemp = CAST(DB_COLUMN_PREFIXpluginType AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginMap DROP DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginMap RENAME DB_COLUMN_PREFIXpluginTypeTemp to DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginMap ALTER DB_COLUMN_PREFIXpluginType SET NOT NULL;

ALTER TABLE DB_TABLE_PREFIXPluginMap ADD COLUMN DB_COLUMN_PREFIXpluginIdTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginMap SET DB_COLUMN_PREFIXpluginIdTemp = CAST(DB_COLUMN_PREFIXpluginId AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginMap DROP DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginMap RENAME DB_COLUMN_PREFIXpluginIdTemp to DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginMap ALTER DB_COLUMN_PREFIXpluginId SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.0
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD COLUMN DB_COLUMN_PREFIXpluginTypeTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXpluginTypeTemp = CAST(DB_COLUMN_PREFIXpluginType AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME DB_COLUMN_PREFIXpluginTypeTemp to DB_COLUMN_PREFIXpluginType;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ALTER DB_COLUMN_PREFIXpluginType SET NOT NULL;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD COLUMN DB_COLUMN_PREFIXpluginIdTemp VARCHAR(32);

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXpluginIdTemp = CAST(DB_COLUMN_PREFIXpluginId AS VARCHAR(32));

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME DB_COLUMN_PREFIXpluginIdTemp to DB_COLUMN_PREFIXpluginId;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ALTER DB_COLUMN_PREFIXpluginId SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# A_GalleryPluginParameterMap_1.1
UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# A_GalleryPluginParameterMap_1.2
ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ADD COLUMN DB_COLUMN_PREFIXparameterValueTemp VARCHAR(10000);

UPDATE DB_TABLE_PREFIXPluginParameterMap SET DB_COLUMN_PREFIXparameterValueTemp = CAST(DB_COLUMN_PREFIXparameterValue AS VARCHAR(10000));

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap DROP DB_COLUMN_PREFIXparameterValue;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap RENAME DB_COLUMN_PREFIXparameterValueTemp to DB_COLUMN_PREFIXparameterValue;

ALTER TABLE DB_TABLE_PREFIXPluginParameterMap ALTER DB_COLUMN_PREFIXparameterValue SET NOT NULL;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=3
  WHERE DB_COLUMN_PREFIXname='PluginParameterMap' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=2;

# A_GalleryUser_1.0
ALTER TABLE DB_TABLE_PREFIXUser ADD COLUMN DB_COLUMN_PREFIXemailTemp VARCHAR(255);

UPDATE DB_TABLE_PREFIXUser SET DB_COLUMN_PREFIXemailTemp = CAST(DB_COLUMN_PREFIXemail AS VARCHAR(255));

ALTER TABLE DB_TABLE_PREFIXUser DROP DB_COLUMN_PREFIXemail;

ALTER TABLE DB_TABLE_PREFIXUser RENAME DB_COLUMN_PREFIXemailTemp to DB_COLUMN_PREFIXemail;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='User' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# ExternalIdMap
CREATE TABLE DB_TABLE_PREFIXExternalIdMap(
 DB_COLUMN_PREFIXexternalId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXentityType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXentityId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXExternalIdMap ADD PRIMARY KEY (DB_COLUMN_PREFIXexternalId, DB_COLUMN_PREFIXentityType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ExternalIdMap', 1, 0);

# GalleryAccessMap
CREATE TABLE DB_TABLE_PREFIXAccessMap(
 DB_COLUMN_PREFIXaccessListId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserOrGroupId INTEGER NOT NULL,
 DB_COLUMN_PREFIXpermission VARCHAR(32) FOR BIT DATA NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXAccessMap ADD PRIMARY KEY (DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAcces69_83732
   ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXaccessListId);

CREATE INDEX DB_TABLE_PREFIXAcces69_48775
   ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXuserOrGroupId);

CREATE INDEX DB_TABLE_PREFIXAcces69_18058
   ON DB_TABLE_PREFIXAccessMap(DB_COLUMN_PREFIXpermission);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessMap', 1, 3);

# GalleryAccessSubscriberMap
CREATE TABLE DB_TABLE_PREFIXAccessSubscriberMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaccessListId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXAccessSubscriberMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXAccesca_83732
   ON DB_TABLE_PREFIXAccessSubscriberMap(DB_COLUMN_PREFIXaccessListId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AccessSubscriberMap', 1, 0);

# GalleryAlbumItem
CREATE TABLE DB_TABLE_PREFIXAlbumItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXtheme VARCHAR(32),
 DB_COLUMN_PREFIXorderBy VARCHAR(128),
 DB_COLUMN_PREFIXorderDirection VARCHAR(32)
);

ALTER TABLE DB_TABLE_PREFIXAlbumItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AlbumItem', 1, 1);

# GalleryAnimationItem
CREATE TABLE DB_TABLE_PREFIXAnimationItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXAnimationItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('AnimationItem', 1, 0);

# GalleryCacheMap
CREATE TABLE DB_TABLE_PREFIXCacheMap(
 DB_COLUMN_PREFIXkey VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXvalue CLOB(2G) NOT LOGGED,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXtimestamp INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXCacheMap ADD PRIMARY KEY (DB_COLUMN_PREFIXkey, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXtype);

CREATE INDEX DB_TABLE_PREFIXCacheff_69068
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXCacheff_75985
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXCacheff_81545
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXtype);

CREATE INDEX DB_TABLE_PREFIXCacheff_24286
   ON DB_TABLE_PREFIXCacheMap(DB_COLUMN_PREFIXtimestamp);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('CacheMap', 1, 0);

# GalleryChildEntity
CREATE TABLE DB_TABLE_PREFIXChildEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXparentId INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXChildEntity ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXChild93_52718
   ON DB_TABLE_PREFIXChildEntity(DB_COLUMN_PREFIXparentId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ChildEntity', 1, 0);

# GalleryDataItem
CREATE TABLE DB_TABLE_PREFIXDataItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128),
 DB_COLUMN_PREFIXsize INTEGER
);

ALTER TABLE DB_TABLE_PREFIXDataItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DataItem', 1, 0);

# GalleryDerivative
CREATE TABLE DB_TABLE_PREFIXDerivative(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeSourceId INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeOperations VARCHAR(255),
 DB_COLUMN_PREFIXderivativeOrder INTEGER NOT NULL,
 DB_COLUMN_PREFIXderivativeSize INTEGER,
 DB_COLUMN_PREFIXderivativeType INTEGER NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXpostFilterOperations VARCHAR(255),
 DB_COLUMN_PREFIXisBroken SMALLINT
);

ALTER TABLE DB_TABLE_PREFIXDerivative ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXDerivfd_85338
   ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeSourceId);

CREATE INDEX DB_TABLE_PREFIXDerivfd_25243
   ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeOrder);

CREATE INDEX DB_TABLE_PREFIXDerivfd_97216
   ON DB_TABLE_PREFIXDerivative(DB_COLUMN_PREFIXderivativeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Derivative', 1, 1);

# GalleryDerivativeImage
CREATE TABLE DB_TABLE_PREFIXDerivativeImage(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXDerivativeImage ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativeImage', 1, 0);

# GalleryDerivativePreferencesMap
CREATE TABLE DB_TABLE_PREFIXDerivativePrefsMap(
 DB_COLUMN_PREFIXitemId INTEGER,
 DB_COLUMN_PREFIXorder INTEGER,
 DB_COLUMN_PREFIXderivativeType INTEGER,
 DB_COLUMN_PREFIXderivativeOperations VARCHAR(255)
);

CREATE INDEX DB_TABLE_PREFIXDeriv94_75985
   ON DB_TABLE_PREFIXDerivativePrefsMap(DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DerivativePrefsMap', 1, 0);

# GalleryDescendentCountsMap
CREATE TABLE DB_TABLE_PREFIXDescendentCountsMap(
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXdescendentCount INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXDescendentCountsMap ADD PRIMARY KEY (DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('DescendentCountsMap', 1, 0);

# GalleryEntity
CREATE TABLE DB_TABLE_PREFIXEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXisLinkable SMALLINT NOT NULL,
 DB_COLUMN_PREFIXlinkId INTEGER,
 DB_COLUMN_PREFIXmodificationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXserialNumber INTEGER NOT NULL,
 DB_COLUMN_PREFIXentityType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXonLoadHandlers VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXEntity ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXEntit6f_76255
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXcreationTimestamp);

CREATE INDEX DB_TABLE_PREFIXEntit6f_35978
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXisLinkable);

CREATE INDEX DB_TABLE_PREFIXEntit6f_44738
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXlinkId);

CREATE INDEX DB_TABLE_PREFIXEntit6f_63025
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXmodificationTimestamp);

CREATE INDEX DB_TABLE_PREFIXEntit6f_60702
   ON DB_TABLE_PREFIXEntity(DB_COLUMN_PREFIXserialNumber);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Entity', 1, 2);

# GalleryFactoryMap
CREATE TABLE DB_TABLE_PREFIXFactoryMap(
 DB_COLUMN_PREFIXclassType VARCHAR(128),
 DB_COLUMN_PREFIXclassName VARCHAR(128),
 DB_COLUMN_PREFIXimplId VARCHAR(128),
 DB_COLUMN_PREFIXimplPath VARCHAR(128),
 DB_COLUMN_PREFIXimplModuleId VARCHAR(128),
 DB_COLUMN_PREFIXhints VARCHAR(255),
 DB_COLUMN_PREFIXorderWeight VARCHAR(255));

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FactoryMap', 1, 0);

# GalleryFileSystemEntity
CREATE TABLE DB_TABLE_PREFIXFileSystemEntity(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXpathComponent VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXFileSystemEntity ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXFileS56_3406
   ON DB_TABLE_PREFIXFileSystemEntity(DB_COLUMN_PREFIXpathComponent);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('FileSystemEntity', 1, 0);

# GalleryGroup
CREATE TABLE DB_TABLE_PREFIXGroup(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupType INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupName VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXGroup ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE UNIQUE INDEX DB_TABLE_PREFIXGroupa0_19099  
 ON DB_TABLE_PREFIXGroup(DB_COLUMN_PREFIXgroupName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Group', 1, 1);

# GalleryItem
CREATE TABLE DB_TABLE_PREFIXItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXcanContainChildren SMALLINT NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(10000),
 DB_COLUMN_PREFIXkeywords VARCHAR(255),
 DB_COLUMN_PREFIXownerId INTEGER NOT NULL,
 DB_COLUMN_PREFIXsummary VARCHAR(255),
 DB_COLUMN_PREFIXtitle VARCHAR(128),
 DB_COLUMN_PREFIXviewedSinceTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXoriginationTimestamp INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXItem79_99070
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXkeywords);

CREATE INDEX DB_TABLE_PREFIXItem79_21573
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXownerId);

CREATE INDEX DB_TABLE_PREFIXItem79_54147
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXsummary);

CREATE INDEX DB_TABLE_PREFIXItem79_90059
   ON DB_TABLE_PREFIXItem(DB_COLUMN_PREFIXtitle);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Item', 1, 1);

# GalleryItemAttributesMap
CREATE TABLE DB_TABLE_PREFIXItemAttributesMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXviewCount INTEGER,
 DB_COLUMN_PREFIXorderWeight INTEGER,
 DB_COLUMN_PREFIXparentSequence VARCHAR(255) NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXItemAttributesMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXItemAca_95270
   ON DB_TABLE_PREFIXItemAttributesMap(DB_COLUMN_PREFIXparentSequence);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('ItemAttributesMap', 1, 0);

# GalleryMaintenanceMap
CREATE TABLE DB_TABLE_PREFIXMaintenanceMap(
 DB_COLUMN_PREFIXrunId INTEGER NOT NULL,
 DB_COLUMN_PREFIXtaskId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtimestamp INTEGER,
 DB_COLUMN_PREFIXsuccess SMALLINT,
 DB_COLUMN_PREFIXdetails VARCHAR(10000)
);

ALTER TABLE DB_TABLE_PREFIXMaintenanceMap ADD PRIMARY KEY (DB_COLUMN_PREFIXrunId);

CREATE INDEX DB_TABLE_PREFIXMaintb2_21687
   ON DB_TABLE_PREFIXMaintenanceMap(DB_COLUMN_PREFIXtaskId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MaintenanceMap', 1, 0);

# GalleryMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXMimeTypeMap(
 DB_COLUMN_PREFIXextension VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXviewable SMALLINT
);

ALTER TABLE DB_TABLE_PREFIXMimeTypeMap ADD PRIMARY KEY (DB_COLUMN_PREFIXextension);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MimeTypeMap', 1, 0);

# GalleryMovieItem
CREATE TABLE DB_TABLE_PREFIXMovieItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER,
 DB_COLUMN_PREFIXduration INTEGER
);

ALTER TABLE DB_TABLE_PREFIXMovieItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('MovieItem', 1, 0);

# GalleryPermissionSetMap
CREATE TABLE DB_TABLE_PREFIXPermissionSetMap(
 DB_COLUMN_PREFIXmodule VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXpermission VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(255),
 DB_COLUMN_PREFIXbits VARCHAR(32) FOR BIT DATA NOT NULL,
 DB_COLUMN_PREFIXflags INTEGER NOT NULL
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXPermi6a_18058  
 ON DB_TABLE_PREFIXPermissionSetMap(DB_COLUMN_PREFIXpermission);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PermissionSetMap', 1, 0);

# GalleryPhotoItem
CREATE TABLE DB_TABLE_PREFIXPhotoItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXwidth INTEGER,
 DB_COLUMN_PREFIXheight INTEGER
);

ALTER TABLE DB_TABLE_PREFIXPhotoItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PhotoItem', 1, 0);

# GalleryPluginMap
CREATE TABLE DB_TABLE_PREFIXPluginMap(
 DB_COLUMN_PREFIXpluginType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXactive SMALLINT NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXPluginMap ADD PRIMARY KEY (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginMap', 1, 1);

# GalleryPluginPackageMap
CREATE TABLE DB_TABLE_PREFIXPluginPackageMap(
 DB_COLUMN_PREFIXpluginType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpackageName VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpackageVersion VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpackageBuild VARCHAR(32) NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXPlugied_80596
   ON DB_TABLE_PREFIXPluginPackageMap(DB_COLUMN_PREFIXpluginType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginPackageMap', 1, 0);

# GalleryPluginParameterMap
CREATE TABLE DB_TABLE_PREFIXPluginParameterMap(
 DB_COLUMN_PREFIXpluginType VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXpluginId VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXparameterName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXparameterValue VARCHAR(10000) NOT NULL
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXPlugia2_26955  
 ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXparameterName);

CREATE INDEX DB_TABLE_PREFIXPlugia2_80596
   ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType);

CREATE INDEX DB_TABLE_PREFIXPlugia2_12808
   ON DB_TABLE_PREFIXPluginParameterMap(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('PluginParameterMap', 1, 3);

# GalleryRecoverPasswordMap
CREATE TABLE DB_TABLE_PREFIXRecoverPasswordMap(
 DB_COLUMN_PREFIXuserName VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXauthString VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXrequestExpires INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRecoverPasswordMap ADD PRIMARY KEY (DB_COLUMN_PREFIXuserName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RecoverPasswordMap', 1, 1);

# GallerySessionMap
CREATE TABLE DB_TABLE_PREFIXSessionMap(
 DB_COLUMN_PREFIXid VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXremoteIdentifier VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXcreationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXmodificationTimestamp INTEGER NOT NULL,
 DB_COLUMN_PREFIXdata VARCHAR(15000)
);

ALTER TABLE DB_TABLE_PREFIXSessionMap ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE INDEX DB_TABLE_PREFIXSessibc_53500
   ON DB_TABLE_PREFIXSessionMap(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXcreationTimestamp, DB_COLUMN_PREFIXmodificationTimestamp);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('SessionMap', 1, 0);

# GalleryToolkitOperationMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMap(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXparametersCrc VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXoutputMimeType VARCHAR(128),
 DB_COLUMN_PREFIXdescription VARCHAR(255)
);

ALTER TABLE DB_TABLE_PREFIXTkOperatnMap ADD PRIMARY KEY (DB_COLUMN_PREFIXname);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMap', 1, 0);

# GalleryToolkitOperationMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnMimeTypeMap(
 DB_COLUMN_PREFIXoperationName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXpriority INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXTkOpe98_2014
   ON DB_TABLE_PREFIXTkOperatnMimeTypeMap(DB_COLUMN_PREFIXoperationName);

CREATE INDEX DB_TABLE_PREFIXTkOpe98_79463
   ON DB_TABLE_PREFIXTkOperatnMimeTypeMap(DB_COLUMN_PREFIXmimeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnMimeTypeMap', 1, 0);

# GalleryToolkitOperationParameterMap
CREATE TABLE DB_TABLE_PREFIXTkOperatnParameterMap(
 DB_COLUMN_PREFIXoperationName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXposition INTEGER NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(255)
);

CREATE INDEX DB_TABLE_PREFIXTkOpee1_2014
   ON DB_TABLE_PREFIXTkOperatnParameterMap(DB_COLUMN_PREFIXoperationName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkOperatnParameterMap', 1, 0);

# GalleryToolkitPropertyMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMap(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtype VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXdescription VARCHAR(128) NOT NULL);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMap', 1, 0);

# GalleryToolkitPropertyMimeTypeMap
CREATE TABLE DB_TABLE_PREFIXTkPropertyMimeTypeMap(
 DB_COLUMN_PREFIXpropertyName VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXtoolkitId VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmimeType VARCHAR(128) NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXTkProcf_52881
   ON DB_TABLE_PREFIXTkPropertyMimeTypeMap(DB_COLUMN_PREFIXpropertyName);

CREATE INDEX DB_TABLE_PREFIXTkProcf_79463
   ON DB_TABLE_PREFIXTkPropertyMimeTypeMap(DB_COLUMN_PREFIXmimeType);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('TkPropertyMimeTypeMap', 1, 0);

# GalleryUnknownItem
CREATE TABLE DB_TABLE_PREFIXUnknownItem(
 DB_COLUMN_PREFIXid INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXUnknownItem ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UnknownItem', 1, 0);

# GalleryUser
CREATE TABLE DB_TABLE_PREFIXUser(
 DB_COLUMN_PREFIXid INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserName VARCHAR(32) NOT NULL,
 DB_COLUMN_PREFIXfullName VARCHAR(128),
 DB_COLUMN_PREFIXhashedPassword VARCHAR(128),
 DB_COLUMN_PREFIXemail VARCHAR(255),
 DB_COLUMN_PREFIXlanguage VARCHAR(128)
);

ALTER TABLE DB_TABLE_PREFIXUser ADD PRIMARY KEY (DB_COLUMN_PREFIXid);

CREATE UNIQUE INDEX DB_TABLE_PREFIXUser75_16233  
 ON DB_TABLE_PREFIXUser(DB_COLUMN_PREFIXuserName);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('User', 1, 1);

# GalleryUserGroupMap
CREATE TABLE DB_TABLE_PREFIXUserGroupMap(
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXgroupId INTEGER NOT NULL
);

CREATE INDEX DB_TABLE_PREFIXUserGa7_69068
   ON DB_TABLE_PREFIXUserGroupMap(DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXUserGa7_89328
   ON DB_TABLE_PREFIXUserGroupMap(DB_COLUMN_PREFIXgroupId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('UserGroupMap', 1, 0);

# Lock
CREATE TABLE DB_TABLE_PREFIXLock(
 DB_COLUMN_PREFIXlockId INTEGER,
 DB_COLUMN_PREFIXreadEntityId INTEGER,
 DB_COLUMN_PREFIXwriteEntityId INTEGER,
 DB_COLUMN_PREFIXfreshUntil INTEGER,
 DB_COLUMN_PREFIXrequest INTEGER
);

CREATE INDEX DB_TABLE_PREFIXLock59_11039
   ON DB_TABLE_PREFIXLock(DB_COLUMN_PREFIXlockId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Lock', 1, 0);

# R_GalleryCache_1.0
DROP TABLE DB_TABLE_PREFIXCache;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='Cache';

# R_GalleryItemPropertiesMap_1.0
DROP TABLE DB_TABLE_PREFIXItemPropertiesMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='ItemPropertiesMap';

# R_GalleryPermissionMap_1.0
DROP TABLE DB_TABLE_PREFIXPermissionMap;

DELETE FROM DB_TABLE_PREFIXSchema WHERE DB_COLUMN_PREFIXname='PermissionMap';

# Schema
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmajor INTEGER NOT NULL,
 DB_COLUMN_PREFIXminor INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXSchema ADD PRIMARY KEY (DB_COLUMN_PREFIXname);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_1
CREATE TABLE DB_TABLE_PREFIXSchema(
 DB_COLUMN_PREFIXname VARCHAR(128) NOT NULL,
 DB_COLUMN_PREFIXmajor INTEGER NOT NULL,
 DB_COLUMN_PREFIXminor INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXSchema ADD PRIMARY KEY (DB_COLUMN_PREFIXname);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('Schema', 1, 0);

# T_InstallerTest_2
ALTER TABLE DB_TABLE_PREFIXSchema ADD COLUMN DB_COLUMN_PREFIXtestCol VARCHAR(128);

CREATE INDEX DB_TABLE_PREFIXSchem9a_18169 ON DB_TABLE_PREFIXSchema(DB_COLUMN_PREFIXtestCol);

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=1
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=0;

# T_InstallerTest_3
DROP INDEX DB_TABLE_PREFIXSchem9a_18169;

UPDATE DB_TABLE_PREFIXSchema
  SET DB_COLUMN_PREFIXmajor=1, DB_COLUMN_PREFIXminor=2
  WHERE DB_COLUMN_PREFIXname='Schema' AND DB_COLUMN_PREFIXmajor=1 AND DB_COLUMN_PREFIXminor=1;

# T_InstallerTest_4
DROP TABLE DB_TABLE_PREFIXSchema;

