/* GADMIN-SQUID - An easy to use GTK+ frontend for the Squid proxy server.
 * Copyright (C) 2006 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_servers.h"
#include "show_info.h"
#include "commented.h"
#include "functions.h"

//extern char global_server_port[1024];
//extern char global_server_name[1024];
//extern char global_server_type[1024];



/* List servers in the serverlist */
void populate_servers(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    char *line, *new_buffer;
    long conf_size;
    gboolean edit=0;
    int x=0, found_server = 0;
    gchar *utf8=NULL;

    gtk_list_store_clear(widgets->server_store);

    if((fp=fopen(SQUID_CONF, "r"))==NULL)
    {
	/* Dont show annoying popup */
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size);
    new_buffer = allocate(conf_size+20000); /* For certificate paths */

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) )
	  continue;

	new_buffer[0]='\0';

	if( cmplowercase(line, "http_port ") || cmplowercase(line, "https_port"))
	{
	    found_server = 1;

	    /* Add a row and insert values */
	    gtk_list_store_append(GTK_LIST_STORE(widgets->server_store), &iter);

	    /* Scroll to the option "ip:port" or just "port" */
	    for(x=0; line[x]!='\0'; x++)
	      if( line[x]!=' ' )
	    	break;

	    for(x=x; line[x]!='\0'; x++)
	      if( line[x]==' ' && line[x+1]!=' ' )
	    	break;
	    x++; /* We are at the beginning of the option */
	    
	    snprintf(new_buffer, 16384, "%s", &line[x]);

	    /* The syntax here should be address:port */
	    if( cmplowercase(line, ":") && cmplowercase(line, ".") )
	    {
		/* Cut away the port ":2468" */
		for(x=0; new_buffer[x]!='\0'; x++)
	          if( new_buffer[x]==':' )
	    	    break;
		new_buffer[x]='\0';
	    }
	    else
	      {   /* The syntax here is http_port PORT.
	             Address is always 0.0.0.0 then */
		  snprintf(new_buffer, 16384, "%s", "0.0.0.0");
	      }

	    if( new_buffer[strlen(new_buffer)-1]=='\n' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    /* Insert the address */
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 0, utf8, -1);

	    /* Insert the server port... */
	    if( cmplowercase(line, ":") && cmplowercase(line, ".") )
	    {
		/* Scroll to the server port */
		for(x=0; line[x]!='\0'; x++)
	          if( line[x]==':' )
	    	    break;
	    	x++;
	    }

	    for(x=x; line[x]!='\0'; x++)
	      if( line[x]!=' ' )
	    	break;

	    /* If theres a "/" its a https server with a certificate path */
	    if( cmplowercase(line, "/") )
	    {
	        snprintf(new_buffer, 16384, "%s", &line[x]);

		/* Find out where we need to cut after the port */
		for(x=0; new_buffer[x]!='\0'; x++)
	          if( new_buffer[x]==' ' )
	    	    break;

	    	new_buffer[x]='\0';
	    }
	    else
	      snprintf(new_buffer, 16384, "%s", &line[x]);

	    if( new_buffer[strlen(new_buffer)-1]=='\n' )
		new_buffer[strlen(new_buffer)-1]='\0';

	    /* Insert the port */
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 1, utf8, -1);


	    /* Insert the certificate if its a https server */
	    if( cmplowercase(line, "/") )
	    {
		/* Find out where we need to cut before the cert path */
		for(x=0; line[x]!='\0'; x++)
	          if( line[x]=='/' )
	    	    break;

	        snprintf(new_buffer, 16384, "%s", &line[x]);

		if( new_buffer[strlen(new_buffer)-1]=='\n' )
	          new_buffer[strlen(new_buffer)-1]='\0';

		/* Insert the port */
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
	    }
	}
    }		    
    /* End of listing servers */

    fclose(fp);
    free(line);
    free(new_buffer);

    if( utf8 !=NULL )
      g_free(utf8);

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->server_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
