/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007-2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/




#include <gtk/gtk.h>
#include "make_settings_labels.h"


void make_3columns_label(GtkTable *table,
                                 const gchar *label_text,
                                 gint left_attach,
                                 gint right_attach,
                                 gint top_attach,
                                 gint bottom_attach)
{
    GtkWidget *label;

    label = gtk_label_new(label_text);
    gtk_table_attach(table, label, left_attach, right_attach + 3, top_attach, bottom_attach, GTK_FILL, GTK_EXPAND, 5, 5);
    gtk_widget_show(label);
}

GtkWidget * make_3columns_label_spin(GtkTable *table,
                                 const gchar *label_text,
                                 gint left_attach,
                                 gint right_attach,
                                 gint top_attach,
                                 gint bottom_attach)
{
    GtkWidget *hbox, *label;
    GtkWidget *checkbutton = gtk_check_button_new();

    hbox = gtk_hbox_new(FALSE, 0);    
    label = gtk_label_new(label_text);
    
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), checkbutton, TRUE, TRUE, 0);
    
    gtk_table_attach(table, hbox, left_attach, right_attach + 2, top_attach, bottom_attach, 0, 0, 2, 2);

    gtk_widget_show(label);
    gtk_widget_show(checkbutton);

    return checkbutton;
}
