/*
    llseek.c -- llseek stub
    Derived from work Copyright (C) 1994, 1995, 1996 Theodore Ts'o.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"
#include <sys/types.h>

#if HAVE_LSEEK64
#define __USE_LARGEFILE64
#include <unistd.h>
/* I'm not sure if this is the right thing to do, or if it even works  */
inline loff_t ext2_llseek (unsigned int fd, loff_t offset, unsigned int whence)
{
	loff_t ret = lseek64(fd, offset, whence);
	return ret != offset;
}

#elif HAVE_LLSEEK
inline loff_t ext2_llseek (unsigned int fd, loff_t offset, unsigned int whence)
{
	return llseek(fd, offset, whence);
}
#elif HAVE_LINUX_UNISTD_H

static const char _llseek_c[] = "$Id: llseek.c,v 1.6 2000/10/10 18:34:33 adilger Exp $";

#include <errno.h>
#include <sys/types.h>
#include <unistd.h>

#include <linux/unistd.h>

#if defined(__i386__)

#ifndef __NR__llseek
#define __NR__llseek 140
#endif

static _syscall5(int,_llseek,unsigned int,fd,unsigned long,offset_high,unsigned long,offset_low,loff_t *,result,unsigned int,origin);

loff_t ext2_llseek (unsigned int fd, loff_t offset, unsigned int whence)
{
	loff_t result;
	int retval;

	retval = _llseek(fd,
			 ((unsigned long long)offset) >> 32,
			 ((unsigned long long)offset) & 0xffffffff,
			 &result,
			 whence);

	return (retval == -1 ? (loff_t) retval : result);
}

#endif /* __i386__ */


#endif /* !HAVE_LLSEEK && HAVE_LINUX_UNISTD_H */
