/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 *
*************************************************************/

/*************************************************************
*
*  File:  noproto.h
*
*  Purpose: function declarations for systems that
*           don't take ANSI prototypes.
*/

#ifndef drand48
 extern double drand48(); /* may not be in header file */
#endif
int compare_edge_attr();
int b_yylex();
char *my_fgets();
void rawunput();
void renumber_all();
void reorder_storage();
int identtype();
REAL kb_drand();
void kb_initr(); 
void move_to_free_front();
void dump_macros();
void calc_all_grads();
void check_pinning();
void convert_forms_to_vectors();
void clear_v_conmap();
void list_attributes();
void reset_rot_order();
void start_logfile();
void stop_logfile();
void calc_leftside();
void one_sided_adjust();
dll_func_type search_libraries();
void load_library();
void unload_libraries();
REAL get_internal_variable();
void check_element_type ( );
int count_fixed_vol();
int oid();
void error_help();
void set_zoom();
void flip_toggle();
int gram_schmidt();
int new_vertex_average();
void keyword_help();
void write_to_console();
void read_line_from_console();
int do_edgeswap();
void apply_h_inverse_metric();
void list_proc();
void list_procedures();
void linear_to_lagrange();
void quad_to_lagrange();
void lagrange_to_linear();
void lagrange_to_quad();
void simplex_lagrange_to_lagrange();
void sparse_permute();
void do_tree_factor();
void do_tree_solve();
int find_method_instance();
int find_quantity();
void reconvert_bodies_to_quantities();
int string_rebody();
void lagrange_to_lagrange();
void metis_partition();
void metis_partition_dual();
void metis_order();
void metis_vertex_order();
int lagrange_index();
int increment_lagrange_index();
void gauss_lagrange_setup();
void det_hess();
int simplex_delete_facet();
int simplex_delete_edge();
void write_hessian();
void read_extra();
void convert_string();
void hessian_legal();
void reset_quant_bits();
void check_one_sided_constraints();
void set_v_global();
void set_v_conmap();
void set_e_conmap();
void set_f_conmap();
void set_v_constraint_map();
void unset_v_constraint_map();
void set_v_constraint_status();
void unset_v_constraint_status();
void clear_v_constraint_status();
void set_e_constraint_map();
void unset_e_constraint_map();
void set_f_constraint_map();
void unset_f_constraint_map();
int v_on_constraint();
int e_on_constraint();
int f_on_constraint();
void get_v_common_conmap();
int simplex_tiny_edges();
int simplex_delete_edge();
int get_tag();
void set_tag();
REAL hessian_line_seek();
void ritz_command();
void do_ritz();
void print_hessian_menu();
void expand_attribute();
int edgeswap();
void gauss_jacobi();
REAL sparse_metric_dot();
void jacobi_eigenpairs();
void star_metric_setup();
void linear_metric_setup();
void linear_metric_setup_quadratic();
void linear_metric_setup_lagrange();
facet_id xget_next_vertex_facet();
REAL get_vertex_length_star();
REAL get_vertex_area_star();
void convert_body_to_quantity();
void convert_to_quantities();
void long_jiggle();
void free_system();
int simplex_long_edges();
void lanczos_command();
void eigenprobe_command();
void myfree();
void option_facet(); 
void geomview_command();
void newton_ysmp();
void ysmp_numeric_factor();
void newton_ysmp_solve();
void newton_ysmp_factor();
void AIJ_setup();
void hessian_exit();
void hessian_cleanup();
void hessian_solve(); 
void hessian_downhill(); 
void hessian_move();
void hessian_init();
void surfen_hess();
int selective_lanczos();
void tridiag_QL();
void intersect_detect();
void bk_eigenprobe();
void bk_inverse_it();
void bk_mul();
void bk_AIJ_setup();
void sp_hessian_solve();
void sp_Hessian_solver();
void bk_constraint_setup();
void BK_hess_project_setup();
void ysmp_factor();
void ysmp_solve();
void ysmp_solve_multi();
void find_ordering();
void xmd_factor();
void xmd_solve();
void xmd_solve_multi();
void tree_factor();
void tree_solve();
void tree_solve_multi();
void hessian_saddle();
void bk_hessian_solve();
void BK_Hessian_solver();
int project_all();
REAL lowest_eigenpair();
REAL cg_lowest_eigenpair();
REAL new_cg_lowest_eigenpair();
element_id get_ordinal_id();
void CC_setup();
void CC_end();
void fill_self_entry();
void fill_grad();
int add_attribute();
int find_attribute();
char *get_extra();
int find_extra();
int matrix_index();
void exec_commands();
void push_fd();
void pop_fd();
facet_id get_vertex_facet();
void macro_init();
REAL ** mat2d_setup();
REAL *** mat3d_setup();
REAL **** mat4d_setup();
void zerohess();
void get_facet_normal();
int get_toggle_value();
REAL user_attribute();
void force_normalization();
void insert_vertex_edge();
void remove_vertex_edge();
void catfulltext();
int identcase();
int eliminate_facet();
REAL quantity_attribute();
REAL instance_attribute();
element_id id;
REAL user_attribute();
int kb_checksum();
void apply_quantity();
void unapply_quantity();
void read_named_quantity();
void read_instance_attr();
DY_OFFSET dy_calloc();
DY_OFFSET dy_realloc();
void dy_free();
void dump_method_specs();
void read_method_attr();
void calc_periods();
void read_method_instance();
void add_standard_quantity();
int new_method_instance();
int attach_method();
void apply_method();
void apply_method_num();
void unapply_method();
int rebody();
int get_body_valence();
int get_vertex_evalence();
int get_vertex_fvalence();
void make_vfacet_lists();
void make_bfacet_lists();
void make_vedge_lists();
REAL dirichlet();
REAL sobolev();
int unstar();
void reduce_string(); 
REAL vertex_angle();
void fix_ctm();
void my_exit();
int dissolve_vertex();
int dissolve_edge();
int dissolve_facet();
int dissolve_body();
char *print_express();
REAL vertex_sq_mean_curvature();
void burchard();
void do_gfile();
int mat_simplify();
void transform_gen_expr();
void generate_transforms();
void read_transform_generators();
int const_expr();
REAL wedge_angle();
void begin_normal_motion();
void end_normal_motion();
REAL gauss_int_gradient();
REAL gauss_int_energy();
REAL gray_level();
void  metric_form_to_vector();
void end_geomview_object();
REAL mean_int_value();
REAL mean_int_gradient();
int new_quantity();
void q_edge_setup();
void q_facet_setup();
void q_vertex_setup();
void q_body_setup();
void calc_quant_grads();
void refine_simplex();
void refine_all_simplices();
vertex_id simplex_edge_divide();
void simplex_hessian();
void hessian_fill();
void hessian_init();
void find_hess_entry();
void hess_hash_search();
void fill_self_entry();
int find_mixed_entry();
void fill_mixed_entry(); 
int find_hess_entries();
void calc_quant_hess();
void m_calc_quant_hess();
void m_fix_hess();
void difference_hessian();
void simplex_facet_hessian();
void simplex_edge_hessian();
void edge_constr_hessian();
int simplex_long_edges();
void quantity_init();
void add_quantity();
REAL calc_quants();
REAL null_q_value();
REAL null_q_grad();
REAL null_q_hess();
REAL q_edge_tension_value();
REAL q_facet_tension_value();
REAL q_edge_tension_gradient();
REAL q_facet_tension_gradient();
void graph_edge_transforms();
void graph_facet_transforms();
REAL * other_stuff();
REAL * more_other_stuff();
void ask_wrap_display();
void print_attr();
void print_set_attr();
void set_print();
void binary_print();
int lookup_global();
void klein_length_grad();
REAL klein_length();
void klein_area_grad();
REAL klein_area();
void  geomview_start();
void  geomview_facet();
void  geomview_edge();
void  geomview_end();
void tree_copy();
void conf_edge_curv_energy();
void conf_edge_curv_force();
int add_global();
REAL dihedral();
void clear_symtable();
char *keywordname();
void subtree_swap();
void exec_file();
int begin_scope();
void end_scope();
void set_scope();
struct sym * symbol_add();
struct sym *symbol_lookup();
vertex_id void_test();
char *tokname();
void update_aggr();
void area_hessian();
void edge_energy_hessian();
int body_hessian();
void sqcurv_hessian();
void tree_exec();
void letter_command();
int node_eval();
void pop_commandfd();
void push_commandfd();
void pop_datafd();
void push_datafd();
void unput_tok();
void unput_string();
void set_f_phase_density();
void set_e_phase_density();
void sp_order();
int  sp_fill_setup();
void sp_factor();
void sp_backsub();
void stability_test();
void mobility_cleanup();
void mobility_mult();
void mobility_setup();
void approx_curv_calc();
void approx_curvature();
void phase_initialize();
void check_vertex_fe();
int new_popverst();
void information();
void show_volumes();
int set_parameters();
void string_fixup();
char *KB_realloc();
void runge_kutta();
void autopop_pop();
void autochop_chop();
void autopop_detect();
vertex_id find_other_vertex();
void simplex_delaunay_test();
void push_face();
int pop_face();
void end_face_stack();
void init_face_stack();
int simplex_equiangulate();
int kernel_basis();
int kernel_basis_rows();
void tr_mat_mul();
void mat_mul_tr();
void  mat_tsquare();
void calc_simplex_edge_energy();
void exterior_product();
int binom_coeff();
void hi_dim_graph();
void recalc();
void reset_conj_grad();
void kusner_energy();
void sqgauss_energy();
void sqgauss_force();
void kusner_force();
int prompt();
void newton_ysmp();
void set_spinr();
void set_spinl();
void set_tipup();
void set_tipdown();
void set_clockwise();
void set_counterclockwise();
void skinny_histogram();
int skinny();
int get_edge_valence();
void alice();
void sqcurve_force_string_end();
void sqcurve_force_string();
void sqcurve_energy_string();
void sqcurve_energy_string_init();
void sqcurve_force_init();
void sqcurve_energy_init();
void sqcurve_energy(); 
void sqcurve_force(); 
void sqcurve_energy_end();
void sqcurve_force_end();
void top_dump();
void bottom_dump();
void vertex_dump();
void edge_dump();
void facet_dump();
void facetedge_dump();
void body_dump();
WRAPTYPE torus_inverse();
WRAPTYPE torus_compose();
void torus_wrap();
void torus_form_pullback();
WRAPTYPE group_inverse();
WRAPTYPE group_compose();
void group_wrap();
void group_form_pullback();
void print_matrix();
REAL simplex_energy_metric();
void simplex_force_metric();
void gauss_setup();
REAL quadratic_form();
void vec_mat_mul();
void check_orientation();
void end_hash_table();
int poponest();
void free_discards();
int find_vertex_to_pop();
void puff();
REAL splinepoly();
REAL splinederiv();
void spline_partial();
void spline_partial_t();
int  command();
void newcommand();
void new_history();
void old_history();
char *kb_calloc();
char *temp_calloc();
char * temp_realloc();
void temp_free();
void temp_free_all();
void cg_direction();
void cg_calc_gamma();
void facet_average();
void simplex_facet_average();
void edge_average();
void recalc_verts();
void grule();
void read_facet_edges();
void read_faces();
void read_edges();
void read_vertices();
void read_bodies();
void read_quantity();
void End_OOGL();
void UpdateOOGL();
void Begin_OOGL();
void softimage();
void constraint_init();
void constraint_free();
REAL find_flux();
void startup();
void read_surface_energy();
void read_parameter();
void read_transforms();
void zoom_vertex();
REAL distance();
int collapse_check();
void merge_collapsed_facets();
void homothety();
void ex_fold();
void fold_recur();
int  yylex();
int yybegin();
void yylex_init();
int  macro();
void record_macro();
int gettoken();
void fe_reorder();
void pix_start();
void pix_facet();
void pix_end();
void constr_edge_force_q();
void restore_vertex();
REAL normal_change_check();
FILE *path_open();
char *getenv();
void fil_finish();
void fil_facet();
void fil_edge();
void fil_init();
void ps_finish();
void ps_facet();
void ps_edge();
void ps_init();
void display_file();
void graph_help();
void main_help();
REAL edge_grav_density();
int facetedge_check();
int facet_body_check();
int list_check();
int run_checks();
int pop_vertex();
int popfilm();
void face_triangulate();
void file_wulff();
void lens_wulff();
void hemi_wulff();
int curtest_facet();
int curtest_facet();
int curtest_edge();
void curtest();
void fix_volconst();
element_id upgrade();
facet_id dup_facet();
body_id dup_body();
REAL estimate_decrease();
void constr_edge_content_q();
void constr_edge_energy_q();
void tordup();
void add_outside();
REAL calc_content();
int equal_constr() ;
void bdry_spring_energy();
void constr_spring_energy();
int boundary_pull_film();
void torus_cells();
void torus_edge_clip();                 
void null_function();
void diffuse();
int cone_analyze();
vertex_id dup_vertex();
edge_id dup_edge();
void versplit() ;
int try_prop();
int edgepop_film();
void exprint_recur();
char *kb_strstr();
void kb_memmove();
void  constr_springs();
void save_coords();
void restore_coords();
void unsave_coords();
void b_proj();
void b_extrapolate();
void bdry_force();
void calc_bdry_force_v();
void calc_bdry_force_e();
void calc_bdry_energy_v();
void calc_bdry_energy_e();
void calc_bdry_content_v();
void calc_bdry_content_e();
void calc_force();
void calc_energy();
void calc_pressure();
void reset_mode();
void cgigraph_edge();
void cgigraph_facet();
void display();
int  constr_proj();
int project_v_constr();
void calc_constr_force_v();
void calc_constr_force_e();
void calc_constr_energy_v();
void calc_constr_energy_e();
void calc_constr_content_v();
void calc_constr_content_e();
void dump();
void do_dump();
REAL eval();
void eval_all();
void eval_second();
REAL tree_eval();
REAL eval_deriv();
REAL tree_eval_deriv();
int exparse();
void calc_simplex_forces();
void calc_simplex_energy();
void calc_simplex_volume();
void facet_force_l();
void facet_energy_l();
void facet_force_l_hi_d();
void facet_energy_l_hi_d();
void facet_volume_l();
void film_grad_l();
void film_bdry_grad();
void film_constr_grad();
void facet_force_q();
void facet_energy_q();
void facet_volume_q();
void film_grad_q();
REAL tq7_integral();
REAL intpoly6();
REAL intpoly6part();
REAL vintzf();
void vcoeff_init();
int graphgen();
void calc_volgrads();
void pressure_forces();
void calc_lagrange();
void lagrange_adjust();
void volume_restore();
void plain_facets();
void bare_edges();
void triple_edges();
void plain_edges();
void torus_clip();
int bfcomp();
void torus_bodies();
void reset_web();
void initialize();
void read_periods();
void wulff_initialize();
void read_boundary();
void read_constraint();
void iterate();
void fix_vertices();
int move_vertices();
void jiggle();
void long_jiggle();
REAL gaussian();
void nrerror();
void matcopy();
REAL * *kb_dmatrix();
REAL * * *kb_dmatrix3();
REAL * * * *kb_dmatrix4();
int *ivector();
REAL *vector();
void free_ivector();
void free_vector();
void free_matrix();
void free_matrix3();
void vector_add();
void vector_add_smul();
void vector_sub();
void vnormal();
void cross_prod();
REAL triple_prod();
REAL dot();
REAL dotf();
REAL dotdf();
void matvec_mul();
void mat_mult();
int  mat_inv();
REAL  determinant();
REAL  det_adjoint();
void change_model();
void linear_to_quad();
void quad_to_linear();
void edge_divide();
void cross_cut();
void display();
void painter_start();
void painter_facet();
void painter_end();
int in_back();
int separating_plane();
int separating_line();
void painter_edge();
int verpop_film();
void do_save();
void do_restore();
void set_attr();
void print_set_attr();
void unset_attr();
void set_fe_edge();
void set_fe_facet();
element_id get_fe_facet();
element_id get_prev_facet();
element_id get_next_facet();
void set_prev_edge();
void set_next_edge();
void set_prev_facet();
void set_next_facet();
void set_edge_wrap();
WRAPTYPE get_edge_wrap();
void set_edge_fe();
element_id get_edge_fe();
void set_edge_tailv();
void set_edge_headv();
void set_edge_midv();
element_id get_facet_body();
void set_facet_body();
element_id get_facet_fe();
void set_facet_fe();
element_id new_vertex();
element_id new_edge();
element_id new_facet();
element_id new_body();
element_id new_facetedge();
REAL get_edge_length();
REAL get_facet_pressure();
void generate_facet_fe_init();
int generate_facet_fe();
void generate_edge_fe_init();
int generate_edge_fe();
struct element *elptr();
void extend();
void expand();
element_id new_element();
void free_element();
void unfree_element();
int generate_all();
void memory_report();
void reset_skeleton();
void vgrad_init();
void vgrad_end();
struct volgrad *get_vertex_vgrad();
struct volgrad *get_next_vgrad();
struct volgrad *new_vgrad();
struct volgrad *get_bv_vgrad();
struct volgrad *get_bv_new_vgrad();
struct element *elptr();
void extend();
element_id new_element();
void free_element();
int generate_all();
void memory_report();
void reset_skeleton();
struct volgrad *get_next_vgrad();
struct volgrad *new_vgrad();
struct volgrad *get_bv_vgrad();
struct volgrad *get_bv_new_vgrad();
void edge_force_l();
void edge_energy_l();
void edge_area_l();
void edge_force_l_metric();
void edge_energy_l_metric();
void edge_force_q_metric();
void edge_energy_q_metric();
void string_grad_l();
void string_bdry_grad();
void string_constr_grad();
REAL interpoly();
REAL interpolyderiv();
void scoeff_init();
void edge_force_q();
void edge_energy_q();
void edge_area_q();
void string_grad_q();
int main();
void do_show();
int  view_transform();
void init_view();
void resize();
void old_menu();
void extrapolate();
void save();
void restore();
void torvol();
void torvol_project();
void refine();
int areaweed();
void area_histogram();
int edgeweed();
void edge_histogram();
int eliminate_edge();
void change_vertex();
int articulate();
int edge_refine();
int equiangulate();
int ridge_notcher();
void outstring();
void erroutstring();
void getstring();
void kb_error();
void catcher();
void calc_edge();
void get_edge_side();
void get_adjust();
void get_edge_adjust();
REAL calc_vertex_normal();
void calc_vertex_smooth_normal();
int new_calc_vertex_normal();
int simplex_vertex_normal();
void get_edge_verts();
void get_facet_verts();
void get_facet_verts_special();
void get_facet_verts_q();
int verpop_str();
void chebychev_hess();
void chebychev_ev();
void dump_force();
void vertex_average();
void hessian_menu();
void hessian_auto();
REAL hessian_seek();
void set_body_fixvol();
facet_id get_next_vertex_facet();

#ifdef PVM
void my_pvm_exit(void);
#endif

facet_id get_next_body_facet();
void set_next_vertex_facet();
void set_next_body_facet();

#ifdef PARALLEL_MACHINE
/* some functions replaced by macros in serial version */
edge_id get_fe_edge();
facetedge_id get_prev_edge();
facetedge_id get_next_edge();
vertex_id get_edge_tailv();
vertex_id get_edge_headv();
edge_id get_next_tail_edge();
edge_id get_next_head_edge();
void set_next_tail_edge();
facetedge_id get_body_fe();
void set_body_fe();
REAL get_body_density();
REAL get_body_volume();
REAL get_body_fixvol();
REAL  get_body_pressure();
REAL get_body_volconst();
void set_body_volconst();
void set_body_density();
void set_body_volume();
void set_body_pressure();
facetedge_id get_vertex_fe();
#endif

