/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: widget.h
 */

#define CLIST_MAX_TABLE_ROWS            3
#define OPTION_MENU_NO_SELECTION_TEXT   _("-- select a menu item --")

#define VALUE_REQUIRED_COLUMN           0
#define WIDGET_LABEL_COLUMN             1
#define WIDGET_COLUMN                   2

/*
 * The following structure contains some common fields used
 * between option descriptors and extended info structures
 * to allow widget selection and initialization. There are
 * a few new fields unique to our needs as well.
 */
 
typedef struct evms_value_descriptor_s
{
   char              *name;             /* Field name */
   char              *title;            /* One or two word description of field */
   char              *desc;             /* Multi-sentence description of field */
   value_type_t       type;             /* Defines data type of value */
   value_unit_t       unit;             /* Defines unit value */
   value_format_t     format;           /* Suggested format for display of values */
   value_t            value;            /* Initial value */
   collection_type_t  collection_type;  /* Defines if either a list or range of values */
   value_collection_t collection;       /* Either a list or range of values of value_type_t */
   group_info_t       group;            /* Group information for display purposes */
   gboolean           is_info_only;     /* TRUE if for display purpose only */
   gboolean           has_initial_value;/* TRUE if the value field was initialized (assumed for extended info) */
   gboolean           ok_to_convert;    /* TRUE if we are allowed to convert the unit and value */
   gboolean           value_is_list;    /* TRUE if value field is really a mutiple input value list */
   gboolean           more_data_avail;  /* TRUE for extended info field that can provide additional info */
   gboolean           multi_input_list; /* TRUE if the widget is to allow multiple selections for a value list */
   gboolean           is_required;      /* TRUE if plugin requires the option widget value be set */
   value_unit_t       unit_conversion;  /* Used to identify unit conversion, e.g. sectors->K or K->sectors */
} evms_value_descriptor_t;

/*
 * The following structure is bound to the widget during widget
 * creation. It provides the notebook layout routines enough
 * information to label, group, indent and provide a tooltip.
 * Once the widget has been inserted, the structure is freed.
 */

typedef struct widget_properties_s 
{
    gchar            *name;
    gchar            *title;
    gchar            *tip;
    gboolean          is_info_only;
    gboolean          more_data_avail;
    gboolean          is_required;
    group_info_t      group;
    value_unit_t      unit;
} widget_properties_t;

/*                                          
 * The option_widget_info_t allows tracking all pertinent information
 * about the value, description and state of a an option widget.
 */
 
typedef struct option_widget_info_s {
    GtkWidget           *widget;          /* the option input widget */
    value_t              value;           /* current value */
    value_unit_t         unit_conversion; /* if not the same as option->unit then use to convert to it */
    gboolean             has_value;       /* indicates if value has been provided/exists */
    option_descriptor_t *option;          /* address of the option descriptor for the widget */
} option_widget_info_t;

typedef void (*options_callback_callout) (option_widget_info_t *info, value_t value, 
                                          task_effect_t set_side_effect);

inline void bind_options_callout_to_toplevel_widget (GtkWidget *widget, options_callback_callout callout);
inline options_callback_callout retrieve_options_callout_from_toplevel_widget (GtkWidget *widget);

void connect_option_widget_callback (GtkWidget *widget, option_widget_info_t *info, gboolean connect_destroy);

option_widget_info_t* create_widget_from_option_descriptor (option_descriptor_t *option);

GtkWidget* create_widget_from_extended_info (extended_info_t *info);

GtkWidget* create_widget_notebook (GSList *widgets, gchar *label, guint max_widgets_per_page, gint currpage);

void on_option_entry_focus_out (GtkEditable *editable, GdkEventFocus *event, option_widget_info_t *info);
