/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_io.c
 *
 * Description: This file contains all functions pertaining to disk I/O within
 *              the MD region manager plugin. This file should be the only
 *              location of calls to READ and WRITE (except the md_read and
 *              md_write API calls).
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <plugin.h>
#define MY_PLUGIN my_plugin
#include "md.h"



/* Function: bytes_to_sectors
 *
 *	Convert a number of bytes into a number of sectors, rounding up.
 */
inline u_int64_t bytes_to_sectors( u_int64_t bytes )
{
	return( ((bytes + EVMS_VSECTOR_SIZE - 1) >> EVMS_VSECTOR_SIZE_SHIFT) );
}


inline u_int64_t sectors_to_bytes( u_int64_t sectors )
{
	return( sectors << EVMS_VSECTOR_SIZE_SHIFT );
}


int md_delete_volume(md_volume_t * volume){
	int rc = 0;
	int i;
	int found = 0;
	LOG_ENTRY;

	for (i = 0; (i < MAX_MD_DEVICES) && (found < volume->nr_disks); i++) {
		if (volume->child_object[i]) {
			KILL_SECTORS(volume->child_object[i],
				MD_NEW_SIZE_SECTORS(volume->child_object[i]->size),
				MD_RESERVED_SECTORS);
			found++;
			md_deallocate_memory(volume->super_array[i]);
		}
	}
	md_remove_volume_from_list(volume);
	if (volume->added_disks != NULL) {
		DestroyList(&volume->added_disks, TRUE);
	}
	if (volume->removed_disks != NULL) {
		DestroyList(&volume->removed_disks, TRUE);
	}
	if (volume->activated_disks != NULL) {
		DestroyList(&volume->activated_disks, TRUE);
	}
	if (volume->deactivated_disks != NULL) {
		DestroyList(&volume->deactivated_disks, TRUE);
	}
	md_deallocate_memory(volume);

	RETURN(rc);
}


