/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_volumes.h
 */ 

#ifndef _LVM_VOLUMES_H_
#define _LVM_VOLUMES_H_ 1

// Functions exported from lvm_volumes.c
extern int lvm_find_volume_by_name(	char			* name,
					lvm_volume_group_t	* group,
					lvm_logical_volume_t	** volume );
extern lvm_logical_volume_t * lvm_allocate_logical_volume(lv_disk_t		* lv,
							lvm_volume_group_t	* group );
extern int lvm_deallocate_logical_volume( lvm_logical_volume_t * volume );
extern int lvm_create_freespace_volume( lvm_volume_group_t * group );
extern int lvm_update_freespace_volume( lvm_volume_group_t * group );
extern int lvm_update_expanded_volume(	lvm_logical_volume_t	* volume,
					lvm_lv_expand_options_t	* lv_opts );
extern int lvm_update_shrunk_volume(	lvm_logical_volume_t	* volume,
					u_int32_t		remove_extents );
extern int lvm_build_le_maps( lvm_volume_group_t * group );
extern int lvm_check_le_maps(	lvm_volume_group_t	* group,
				boolean			final_call );
extern int lvm_export_logical_volumes(	dlist_t	regions,
					boolean	final_call );
extern int lvm_get_freespace_volume(	dlist_t			freespace_region_list,
					lvm_logical_volume_t	** freespace_volume );
extern int lvm_check_lv_name(	char			* name,
				lvm_volume_group_t	* group );
extern int lvm_check_lv_size(	u_int32_t	* lv_size,
				u_int32_t	pe_size );
extern int lvm_compare_lv_size_and_extents(	u_int32_t	* lv_size,
						u_int32_t	* extents,
						u_int32_t	pe_size );
extern int lvm_check_stripe_size(u_int32_t	* stripe_size,
				u_int32_t	pe_size );
extern int lvm_check_chunk_size(u_int32_t	* chunk_size,
				u_int32_t	pe_size );
extern int lvm_initialize_new_lv(	lvm_lv_create_options_t	* lv_opts,
					lvm_volume_group_t	* group,
					lv_disk_t		** lv );
extern int lvm_check_available_extents(	lvm_volume_group_t	* group,
					lvm_lv_create_options_t	* lv_opts );
extern int lvm_check_available_expand_extents(	lvm_logical_volume_t	* volume,
						lvm_lv_expand_options_t	* lv_opts );
extern int lvm_allocate_extents_to_volume(lvm_logical_volume_t	* volume,
					lvm_lv_create_options_t	* lv_opts );
extern int lvm_allocate_expand_extents_to_volume(lvm_logical_volume_t	* volume,
						lvm_lv_expand_options_t	* lv_opts );
extern int lvm_deallocate_extents_from_volume( lvm_logical_volume_t * volume );
extern int lvm_deallocate_shrink_extents_from_volume(	lvm_logical_volume_t	* volume,
							u_int32_t		remove_extents );
extern int lvm_clear_lv( lv_disk_t * lv );

#endif

