/*
 *  Eukleides  version 0.9.2
 *  Copyright (c) Christian Obrecht 2000-2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

char *buffer;

int filter = 0, lineno = 1, first = 1, inputmode = 1;

extern int yyparse (void);

void usage (int code)
{
    printf
	("Usage is:\n\teukleides [ -v | -h ]\n\teukleides [ -f ] <filename>\n"
	 "Options:\n\t-v\tPrint version number.\n\t-h\tPrint this help.\n"
	 "\t-f\tRun as a filter.\nSee man page for more informations.\n");
    exit (code);
}

void version (void)
{
    printf ("This is eukleides version 0.9.2\n"
	    "Copyright (c) Christian Obrecht 2000-2002\n");
    exit (0);
}

void warning (char *msg)
{
    fprintf (stderr, "Warning at line %i: %s\n", lineno, msg);
}

void yyerror (char *msg)
{
    fprintf (stderr, "Error at line %i: %s\n", lineno, msg);
    exit (1);
}

void parser (char *file_name)
{
    FILE *file;
    int size, number, file_length;

    file = fopen (file_name, "r");
    if (!file) {
	  fprintf (stderr, "Could not open %s\n", file_name);
	  exit (1);
    }

    file_length = 0;
    size = 1024;
    number = 1024;
    buffer = (char *) malloc (size);
    while (number == 1024) {
	  number = fread (buffer + file_length, 1, 1024, file);
	  file_length += number;
	  if (size == file_length) {
		size *= 2;
		buffer = (char *) realloc (buffer, size);
	  }
    }
    fclose (file);

    if (!filter)
	printf ("%% Generated by eukleides 0.9.2\n"
		"\\psset{linecolor=black, linewidth=.5pt, arrowsize=2pt 4}\n");
    yyparse ();
    if (!filter)
	printf ("\\endpspicture\n");
    exit (0);
}

int main (int argc, char **argv)
{
    switch (argc)
      {
      case 1:
	  usage (0);

      case 2:
	  if (argv[1][0] == '-') {
		if (argv[1][1] == 'v')
		    version ();
		else if (argv[1][1] == 'h')
		    usage (0);
		else
		    usage (1);
	  }
	  else
	      parser (argv[1]);

      case 3:
	  if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
		filter = 1;
		inputmode = 0;
		parser (argv[2]);
	  }
	  else
	      usage (1);
      default:
	  usage (1);
      }
    return 0;
}
