# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Editor Properties (2) configuration page.
"""

from PyQt4.Qsci import QsciScintilla

from ConfigurationPageBase import ConfigurationPageBase
from Ui_EditorProperties2Page import Ui_EditorProperties2Page

import Preferences

class EditorProperties2Page(ConfigurationPageBase, Ui_EditorProperties2Page):
    """
    Class implementing the Editor Properties (2) configuration page.
    """
    def __init__(self):
        """
        Constructor
        
        @param lexers reference to the lexers dictionary
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("EditorProperties2Page")
        
        # set initial values
        self.foldPythonCommentCheckBox.setChecked(\
            Preferences.getEditor("PythonFoldComment"))
        self.foldPythonStringCheckBox.setChecked(\
            Preferences.getEditor("PythonFoldString"))
        self.pythonBadIndentationCheckBox.setChecked(\
            Preferences.getEditor("PythonBadIndentation"))
        self.pythonAutoindentCheckBox.setChecked(\
            Preferences.getEditor("PythonAutoIndent"))
        
        self.foldPerlCommentCheckBox.setChecked(\
            Preferences.getEditor("PerlFoldComment"))
        
        self.foldSqlCommentCheckBox.setChecked(\
            Preferences.getEditor("SqlFoldComment"))
        self.sqlBackslashEscapesCheckBox.setChecked(\
            Preferences.getEditor("SqlBackslashEscapes"))
        
        self.foldPovrayCommentCheckBox.setChecked(\
            Preferences.getEditor("PovFoldComment"))
        self.foldPovrayDirectivesCheckBox.setChecked(\
            Preferences.getEditor("PovFoldDirectives"))
        
        self.vhdlFoldCommentCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldComment"))
        self.vhdlFoldAtElseCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldAtElse"))
        self.vhdlFoldAtBeginCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldAtBegin"))
        self.vhdlFoldAtParenthesisCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldAtParenthesis"))
        
    def save(self):
        """
        Public slot to save the Editor Properties (2) configuration.
        """
        Preferences.setEditor("PythonFoldComment",
            int(self.foldPythonCommentCheckBox.isChecked()))
        Preferences.setEditor("PythonFoldString",
            int(self.foldPythonStringCheckBox.isChecked()))
        Preferences.setEditor("PythonBadIndentation",
            int(self.pythonBadIndentationCheckBox.isChecked()))
        Preferences.setEditor("PythonAutoIndent",
            int(self.pythonAutoindentCheckBox.isChecked()))
        
        Preferences.setEditor("PerlFoldComment",
            int(self.foldPerlCommentCheckBox.isChecked()))
            
        Preferences.setEditor("SqlFoldComment",
            int(self.foldSqlCommentCheckBox.isChecked()))
        Preferences.setEditor("SqlBackslashEscapes",
            int(self.sqlBackslashEscapesCheckBox.isChecked()))
            
        Preferences.setEditor("PovFoldComment",
            int(self.foldPovrayCommentCheckBox.isChecked()))
        Preferences.setEditor("PovFoldDirectives",
            int(self.foldPovrayDirectivesCheckBox.isChecked()))
        
        Preferences.setEditor("VHDLFoldComment",
            int(self.vhdlFoldCommentCheckBox.isChecked()))
        Preferences.setEditor("VHDLFoldAtElse",
            int(self.vhdlFoldAtElseCheckBox.isChecked()))
        Preferences.setEditor("VHDLFoldAtBegin",
            int(self.vhdlFoldAtBeginCheckBox.isChecked()))
        Preferences.setEditor("VHDLFoldAtParenthesis",
            int(self.vhdlFoldAtParenthesisCheckBox.isChecked()))

def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = EditorProperties2Page()
    return page
